/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.Model;
import com.metamatrix.admin.api.objects.QueueWorkerPool;
import com.metamatrix.admin.api.objects.Request;
import com.metamatrix.admin.api.objects.SystemObject;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.api.server.ServerMonitoringAdmin;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.admin.objects.MMConnectorBinding;
import com.metamatrix.admin.objects.MMConnectorType;
import com.metamatrix.admin.objects.MMDQP;
import com.metamatrix.admin.objects.MMExtensionModule;
import com.metamatrix.admin.objects.MMHost;
import com.metamatrix.admin.objects.MMProcess;
import com.metamatrix.admin.objects.MMQueueWorkerPool;
import com.metamatrix.admin.objects.MMRequest;
import com.metamatrix.admin.objects.MMResource;
import com.metamatrix.admin.objects.MMSession;
import com.metamatrix.admin.objects.MMSourceRequest;
import com.metamatrix.admin.objects.MMSystem;
import com.metamatrix.admin.server.AbstractAdminImpl;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicDeployedComponent;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.ZipFileUtil;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.SystemState;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.vm.controller.ProcessStatistics;
import com.metamatrix.platform.vm.controller.SocketListenerStats;
import com.metamatrix.server.serverapi.RequestInfo;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ServerMonitoringAdminImpl
extends AbstractAdminImpl
implements ServerMonitoringAdmin {
    private static final String QUERY_SERVICE = "QueryService";

    public ServerMonitoringAdminImpl(ServerAdminImpl parent, ClusteredRegistryState registry) {
        super(parent, registry);
    }

    public Collection getCaches(String identifier) throws AdminException {
        return null;
    }

    public Collection getConnectorBindings(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        HashSet<MMConnectorBinding> results = new HashSet<MMConnectorBinding>();
        try {
            MMConnectorBinding binding;
            Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
            Collection components = config.getDeployedComponents();
            HashMap<String, MMConnectorBinding> runtimeMap = new HashMap<String, MMConnectorBinding>();
            for (BasicDeployedComponent component : components) {
                String bindingName = component.getName();
                String[] identifierParts = new String[]{component.getHostID().getName(), component.getVMComponentDefnID().getName(), bindingName};
                ConnectorBinding configBinding = config.getConnectorBinding(bindingName);
                if (configBinding == null || !ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                binding = new MMConnectorBinding(identifierParts);
                binding.setConnectorTypeName(configBinding.getComponentTypeID().getFullName());
                binding.setRoutingUUID(configBinding.getRoutingUUID());
                binding.setEnabled(configBinding.isEnabled());
                binding.setDeployed(true);
                binding.setRegistered(false);
                binding.setState(5);
                binding.setProperties(configBinding.getProperties());
                binding.setCreated(configBinding.getCreatedDate());
                binding.setCreatedBy(configBinding.getCreatedBy());
                binding.setLastUpdated(configBinding.getLastChangedDate());
                binding.setLastUpdatedBy(configBinding.getLastChangedBy());
                String key = binding.getIdentifier().toUpperCase();
                runtimeMap.put(key, binding);
                results.add(binding);
            }
            List<ServiceRegistryBinding> serviceBindings = this.registry.getServiceBindings(null, null);
            for (ServiceRegistryBinding serviceBinding : serviceBindings) {
                DeployedComponent deployedComponent = serviceBinding.getDeployedComponent();
                if (deployedComponent == null || !deployedComponent.isDeployedConnector()) continue;
                String name = serviceBinding.getDeployedName();
                String[] identifierParts = new String[]{serviceBinding.getHostName(), serviceBinding.getProcessName(), name};
                String key = MMAdminObject.buildIdentifier((String[])identifierParts).toUpperCase();
                if (runtimeMap.containsKey(key)) {
                    binding = (MMConnectorBinding)runtimeMap.get(key);
                } else {
                    binding = new MMConnectorBinding(identifierParts);
                    binding.setDeployed(false);
                    binding.setState(7);
                }
                if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                binding.setConnectorTypeName(deployedComponent.getComponentTypeID().getFullName());
                binding.setDescription(deployedComponent.getDescription());
                binding.setState(serviceBinding.getCurrentState());
                binding.setStateChangedTime(serviceBinding.getStateChangeTime());
                binding.setRegistered(true);
                binding.setServiceID(serviceBinding.getServiceID().getID());
                results.add(binding);
            }
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        return results;
    }

    public Collection getConnectorBindingsInVDB(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        HashSet allBindingNames = new HashSet();
        Collection vdbs = this.getVDBs(identifier);
        for (VDB aVdb : vdbs) {
            Collection models = aVdb.getModels();
            for (Model aModel : models) {
                List bindingNames = aModel.getConnectorBindingNames();
                if (bindingNames == null || bindingNames.size() <= 0) continue;
                allBindingNames.addAll(bindingNames);
            }
        }
        ArrayList connectorBindings = new ArrayList();
        Iterator bindingNameItr = allBindingNames.iterator();
        while (bindingNameItr.hasNext()) {
            Collection cb = this.getConnectorBindings("*" + (String)bindingNameItr.next());
            connectorBindings.addAll(cb);
        }
        return connectorBindings;
    }

    public Collection getConnectorTypes(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        ArrayList<MMConnectorType> results = null;
        try {
            Collection types = this.getConfigurationServiceProxy().getAllComponentTypes(false);
            results = new ArrayList<MMConnectorType>(types.size());
            for (ComponentType componentType : types) {
                if (componentType.getComponentTypeCode() != 2) continue;
                String name = componentType.getName();
                String[] identifierParts = new String[]{name};
                if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                MMConnectorType type = new MMConnectorType(identifierParts);
                type.setCreated(componentType.getCreatedDate());
                type.setCreatedBy(componentType.getCreatedBy());
                type.setLastUpdated(componentType.getLastChangedDate());
                type.setLastUpdatedBy(componentType.getLastChangedBy());
                results.add(type);
            }
            return results;
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
    }

    public Collection getDQPs(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        HashSet<MMDQP> results = new HashSet<MMDQP>();
        try {
            Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
            Collection components = config.getDeployedComponents();
            HashMap<String, MMDQP> runtimeMap = new HashMap<String, MMDQP>();
            for (BasicDeployedComponent component : components) {
                String dqpName = component.getName();
                String[] identifierParts = new String[]{component.getHostID().getName(), component.getVMComponentDefnID().getName(), dqpName};
                if (!QUERY_SERVICE.equals(component.getComponentTypeID().getName()) || !ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                MMDQP dqp = new MMDQP(identifierParts);
                dqp.setDeployed(true);
                dqp.setRegistered(false);
                dqp.setState(5);
                ServiceComponentDefn defn = config.getServiceComponentDefn(dqpName);
                if (defn != null) {
                    dqp.setProperties(defn.getProperties());
                }
                String key = MMAdminObject.buildIdentifier((String[])identifierParts).toUpperCase();
                runtimeMap.put(key, dqp);
                results.add(dqp);
            }
            List<ServiceRegistryBinding> serviceBindings = this.registry.getServiceBindings(null, null);
            for (ServiceRegistryBinding serviceBinding : serviceBindings) {
                MMDQP dqp;
                DeployedComponent deployedComponent = serviceBinding.getDeployedComponent();
                if (!QUERY_SERVICE.equals(serviceBinding.getServiceType())) continue;
                String name = serviceBinding.getDeployedName();
                String[] identifierParts = new String[]{serviceBinding.getHostName(), serviceBinding.getProcessName(), name};
                String key = MMAdminObject.buildIdentifier((String[])identifierParts).toUpperCase();
                if (runtimeMap.containsKey(key)) {
                    dqp = (MMDQP)runtimeMap.get(key);
                } else {
                    dqp = new MMDQP(identifierParts);
                    dqp.setDeployed(false);
                    dqp.setState(7);
                }
                if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                dqp.setCreated(deployedComponent.getCreatedDate());
                dqp.setCreatedBy(deployedComponent.getCreatedBy());
                dqp.setLastUpdated(deployedComponent.getLastChangedDate());
                dqp.setLastUpdatedBy(deployedComponent.getLastChangedBy());
                dqp.setDescription(deployedComponent.getDescription());
                dqp.setState(serviceBinding.getCurrentState());
                dqp.setStateChangedTime(serviceBinding.getStateChangeTime());
                dqp.setRegistered(true);
                dqp.setServiceID(serviceBinding.getServiceID().getID());
                results.add(dqp);
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        return results;
    }

    public Collection getExtensionModules(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        ArrayList<MMExtensionModule> results = null;
        try {
            List modules = this.getExtensionSourceManager().getSourceDescriptors();
            results = new ArrayList<MMExtensionModule>(modules.size());
            for (ExtensionModuleDescriptor descriptor : modules) {
                String sourceName = descriptor.getName();
                String[] identifierParts = new String[]{sourceName};
                if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                MMExtensionModule module = new MMExtensionModule(identifierParts);
                module.setModuleType(descriptor.getType());
                module.setDescription(descriptor.getDescription());
                module.setEnabled(descriptor.isEnabled());
                byte[] contents = this.getExtensionSourceManager().getSource(sourceName);
                module.setFileContents(contents);
                module.setCreated(DateUtil.convertStringToDate((String)descriptor.getCreationDate()));
                module.setCreatedBy(descriptor.getCreatedBy());
                module.setLastUpdated(DateUtil.convertStringToDate((String)descriptor.getLastUpdatedDate()));
                module.setLastUpdatedBy(descriptor.getLastUpdatedBy());
                results.add(module);
            }
        }
        catch (ExtensionModuleNotFoundException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ParseException e) {
            throw new AdminComponentException((Throwable)e);
        }
        return results;
    }

    public Collection getHosts(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        HashSet<MMHost> results = new HashSet<MMHost>();
        try {
            MMHost host;
            SystemState systemState = this.getRuntimeStateAdminAPIHelper().getSystemState();
            Collection hostDatas = systemState.getHosts();
            HashMap<String, MMHost> runtimeMap = new HashMap<String, MMHost>();
            for (HostData hostData : hostDatas) {
                String hostName = hostData.getName();
                String[] identifierParts = new String[]{hostName};
                if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                host = new MMHost(identifierParts);
                host.setRunning(hostData.isRegistered());
                host.setRegistered(hostData.isRegistered());
                host.setDeployed(false);
                host.setProperties(hostData.getProperties());
                runtimeMap.put(hostName.toUpperCase(), host);
                results.add(host);
            }
            Collection hosts = this.getConfigurationServiceProxy().getHosts();
            for (Host hostObject : hosts) {
                String hostName = hostObject.getName();
                if (runtimeMap.containsKey(hostName.toUpperCase())) {
                    host = (MMHost)runtimeMap.get(hostName.toUpperCase());
                } else {
                    String[] identifierParts = new String[]{hostName};
                    host = new MMHost(identifierParts);
                    host.setRunning(false);
                    host.setRegistered(false);
                }
                if (!ServerMonitoringAdminImpl.identifierMatches(identifier, host.getIdentifierArray())) continue;
                host.setCreated(hostObject.getCreatedDate());
                host.setCreatedBy(hostObject.getCreatedBy());
                host.setLastUpdated(hostObject.getLastChangedDate());
                host.setLastUpdatedBy(hostObject.getLastChangedBy());
                host.setEnabled(hostObject.isEnabled());
                Properties properties = hostObject.getProperties();
                if (host.getProperties() != null) {
                    host.getProperties().putAll((Map<?, ?>)properties);
                } else {
                    host.setProperties(properties);
                }
                host.setDeployed(true);
                results.add(host);
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        return results;
    }

    public Collection getProcesses(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        HashSet<MMProcess> results = new HashSet<MMProcess>();
        try {
            MMProcess process;
            SystemState systemState = this.getRuntimeStateAdminAPIHelper().getSystemState();
            Collection hostDatas = systemState.getHosts();
            HashMap<String, MMProcess> runtimeMap = new HashMap<String, MMProcess>();
            for (HostData hostData : hostDatas) {
                Collection processDatas = hostData.getProcesses();
                for (ProcessData processData : processDatas) {
                    String processName = processData.getName();
                    String hostName = hostData.getName();
                    String[] identifierParts = new String[]{hostName, processName};
                    if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                    process = new MMProcess(identifierParts);
                    process.setRunning(processData.isRegistered());
                    if (processData.isRegistered()) {
                        try {
                            ProcessStatistics statistics = this.getRuntimeStateAdminAPIHelper().getVMStatistics(hostName, processName);
                            if (statistics != null) {
                                WorkerPoolStats workerStats;
                                process.setFreeMemory(statistics.freeMemory);
                                process.setTotalMemory(statistics.totalMemory);
                                process.setThreadCount(statistics.threadCount);
                                SocketListenerStats socketStats = statistics.socketListenerStats;
                                if (socketStats != null) {
                                    process.setSockets(socketStats.sockets);
                                    process.setMaxSockets(socketStats.maxSockets);
                                    process.setObjectsRead(socketStats.objectsRead);
                                    process.setObjectsWritten(socketStats.objectsWritten);
                                }
                                if ((workerStats = statistics.processPoolStats) != null) {
                                    String[] workerPoolIdentifierParts = new String[]{hostName, processName, workerStats.name};
                                    MMQueueWorkerPool workerPool = new MMQueueWorkerPool(workerPoolIdentifierParts);
                                    workerPool.setDequeues(0);
                                    workerPool.setEnqueues(0);
                                    workerPool.setHighwaterMark(0);
                                    workerPool.setThreads(workerStats.threads);
                                    workerPool.setQueued(workerStats.queued);
                                    workerPool.setTotalDequeues(workerStats.totalCompleted);
                                    workerPool.setTotalEnqueues(workerStats.totalSubmitted);
                                    workerPool.setTotalHighwaterMark(0);
                                    process.setQueueWorkerPool((QueueWorkerPool)workerPool);
                                }
                            }
                            process.setInetAddress(this.getRuntimeStateAdminAPIHelper().getVMHostName(hostName, processName));
                        }
                        catch (MetaMatrixComponentException e) {
                            // empty catch block
                        }
                    }
                    process.setDeployed(false);
                    String key = MMAdminObject.buildIdentifier((String[])identifierParts).toUpperCase();
                    runtimeMap.put(key, process);
                    results.add(process);
                }
            }
            Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
            Collection defns = config.getVMComponentDefns();
            for (VMComponentDefn defn : defns) {
                String processName = defn.getName();
                Host h = config.getHost(defn.getHostID().getName());
                String[] identifierParts = new String[]{h.getName(), processName};
                String key = MMAdminObject.buildIdentifier((String[])identifierParts).toUpperCase();
                if (runtimeMap.containsKey(key)) {
                    process = (MMProcess)runtimeMap.get(key);
                } else {
                    process = new MMProcess(identifierParts);
                    process.setRunning(false);
                }
                if (!ServerMonitoringAdminImpl.identifierMatches(identifier, process.getIdentifierArray())) continue;
                process.setCreated(defn.getCreatedDate());
                process.setCreatedBy(defn.getCreatedBy());
                process.setLastUpdated(defn.getLastChangedDate());
                process.setLastUpdatedBy(defn.getLastChangedBy());
                process.setProperties(defn.getProperties());
                process.setEnabled(defn.isEnabled());
                process.setDeployed(true);
                String portString = defn.getPort();
                if (portString != null) {
                    process.setPort(Integer.parseInt(portString));
                }
                if (process.getInetAddress() == null) {
                    try {
                        process.setInetAddress(InetAddress.getByName(h.getHostAddress()));
                    }
                    catch (UnknownHostException e) {
                        throw new AdminComponentException((Throwable)e);
                    }
                }
                results.add(process);
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        return results;
    }

    public Collection getQueueWorkerPools(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        ArrayList<MMQueueWorkerPool> results = null;
        try {
            List<ServiceRegistryBinding> serviceBindings = this.registry.getServiceBindings(null, null);
            results = new ArrayList<MMQueueWorkerPool>(serviceBindings.size());
            for (ServiceRegistryBinding binding : serviceBindings) {
                DeployedComponent component = binding.getDeployedComponent();
                if (!component.isDeployedConnector() && !QUERY_SERVICE.equals(component.getComponentTypeID().getName())) continue;
                Collection statsCollection = this.getRuntimeStateAdminAPIHelper().getServiceQueueStatistics(binding);
                for (WorkerPoolStats stats : statsCollection) {
                    String name = stats.name;
                    String[] identifierParts = new String[]{binding.getHostName(), component.getVMComponentDefnID().getName(), binding.getDeployedName(), name};
                    if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                    MMQueueWorkerPool pool = new MMQueueWorkerPool(identifierParts);
                    pool.setDeployed(true);
                    pool.setRegistered(true);
                    pool.setDequeues(0);
                    pool.setEnqueues(0);
                    pool.setHighwaterMark(0);
                    pool.setQueued(stats.queued);
                    pool.setThreads(stats.threads);
                    pool.setTotalDequeues(stats.totalCompleted);
                    pool.setTotalEnqueues(stats.totalSubmitted);
                    pool.setTotalHighwaterMark(0);
                    results.add(pool);
                }
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        return results;
    }

    public Collection getRequests(String identifier) throws AdminException {
        return this.getRequests(identifier, false);
    }

    private Collection getRequests(String identifier, boolean source) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        ArrayList<MMRequest> results = null;
        try {
            Collection requests = null;
            requests = this.getQueryServiceProxy().getAllQueries();
            HashSet<String> uuids = new HashSet<String>(requests.size());
            for (RequestInfo info : requests) {
                uuids.add(info.getConnectorBindingUUID());
            }
            Map uuidToBindingNameMap = this.getConnectorBindingNamesMapFromUUIDs(uuids);
            results = new ArrayList<MMRequest>(requests.size());
            for (RequestInfo info : requests) {
                boolean correctType;
                MMRequest request;
                SessionToken st = info.getSessionToken();
                String[] identifierParts = new String[2];
                identifierParts[0] = info.getRequestID().getConnectionID();
                if (source) {
                    identifierParts[1] = info.getRequestID().getExecutionID() + Request.DELIMITER + info.getNodeID();
                    request = new MMSourceRequest(identifierParts);
                    correctType = info.isAtomicQuery();
                } else {
                    identifierParts[1] = Long.toString(info.getRequestID().getExecutionID());
                    request = new MMRequest(identifierParts);
                    boolean bl = correctType = !info.isAtomicQuery();
                }
                if (!correctType || !ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                Object bindingName = uuidToBindingNameMap.get(info.getConnectorBindingUUID());
                request.setConnectorBindingName(bindingName != null ? (String)bindingName : null);
                request.setCreated(info.getSubmittedTimestamp());
                request.setSqlCommand(info.getCommand());
                request.setProcessingDate(info.getProcessingTimestamp());
                if (info.getTransactionId() != null) {
                    request.setTransactionID(info.getTransactionId());
                }
                if (st != null && st.getSessionID() != null) {
                    request.setUserName(st.getUsername());
                }
                results.add(request);
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        return results;
    }

    public Collection getResources(String identifier) throws AdminException {
        ArrayList<MMResource> results = null;
        Collection resources = null;
        try {
            resources = this.getConfigurationServiceProxy().getResources();
            if (resources != null) {
                results = new ArrayList<MMResource>(resources.size());
                for (SharedResource sr : resources) {
                    String name = sr.getName();
                    String[] identifierParts = new String[]{name};
                    if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                    MMResource resource = new MMResource(identifierParts);
                    resource.setResourceType(sr.getComponentTypeID().getName());
                    resource.setCreated(sr.getCreatedDate());
                    resource.setCreatedBy(sr.getCreatedBy());
                    resource.setLastUpdated(sr.getLastChangedDate());
                    resource.setLastUpdatedBy(sr.getLastChangedBy());
                    resource.setProperties(sr.getProperties());
                    resource.setConnectionPoolIdentifier(sr.getProperty("metamatrix.common.pooling.resource.name"));
                    results.add(resource);
                }
            }
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        return results;
    }

    public Collection getSessions(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        ArrayList<MMSession> results = null;
        try {
            Collection sessions = null;
            sessions = this.getSessionServiceProxy().getActiveSessions();
            results = new ArrayList<MMSession>(sessions.size());
            for (MetaMatrixSessionInfo info : sessions) {
                String sessionID = info.getSessionID().toString();
                String[] identifierParts = new String[]{sessionID};
                if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                MMSession session = new MMSession(identifierParts);
                SessionToken st = info.getSessionToken();
                String vdbName = ServerMonitoringAdminImpl.trimString(info.getProductInfo("VirtualDatabaseName"));
                String vdbVersionString = ServerMonitoringAdminImpl.trimString(info.getProductInfo("VirtualDatabaseVersion"));
                session.setUserName(info.getUserName());
                session.setCreatedBy(info.getUserName());
                session.setApplicationName(info.getApplicationName());
                session.setCreated(new Date(info.getTimeCreated()));
                session.setLastUpdated(new Date(info.getTimeCreated()));
                session.setVDBName(vdbName);
                session.setVDBVersion(vdbVersionString);
                session.setProductName(info.getProductName());
                session.setLastPingTime(info.getLastPingTime());
                session.setSessionState(info.getState());
                session.setIPAddress(info.getClientIp());
                session.setHostName(info.getClientHostname());
                results.add(session);
            }
        }
        catch (SessionServiceException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        return results;
    }

    public Collection getSourceRequests(String identifier) throws AdminException {
        return this.getRequests(identifier, true);
    }

    public SystemObject getSystem() throws AdminException {
        MMSystem system = null;
        try {
            boolean isStarted = this.getRuntimeStateAdminAPIHelper().isSystemStarted();
            Date startTime = this.getConfigurationServiceProxy().getServerStartupTime();
            Configuration currentConfiguration = this.getConfigurationServiceProxy().getCurrentConfiguration();
            system = new MMSystem();
            system.setStartTime(startTime);
            system.setStarted(isStarted);
            system.setProperties(currentConfiguration.getProperties());
            system.setCreated(currentConfiguration.getCreatedDate());
            system.setCreatedBy(currentConfiguration.getCreatedBy());
            system.setLastUpdated(currentConfiguration.getLastChangedDate());
            system.setLastUpdatedBy(currentConfiguration.getLastChangedBy());
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        return system;
    }

    public Collection getVDBs(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        List results = null;
        try {
            Collection virtualDatabases = RuntimeMetadataCatalog.getInstance().getVirtualDatabases();
            results = this.getVDBs(identifier, virtualDatabases);
        }
        catch (VirtualDatabaseException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        return results;
    }

    public Collection getPropertyDefinitions(String identifier, String className) throws AdminException {
        Collection adminObjects;
        if (identifier == null || className == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        if ((adminObjects = this.getAdminObjects(identifier, className)) == null || adminObjects.size() == 0) {
            this.throwProcessingException("ServerMonitoringAdminImpl.No_Objects_Found", new Object[]{identifier, className});
        }
        if (adminObjects.size() > 1) {
            this.throwProcessingException("ServerMonitoringAdminImpl.Multiple_Objects_Found", new Object[]{identifier, className});
        }
        AdminObject adminObject = (AdminObject)adminObjects.iterator().next();
        try {
            ComponentObject component = null;
            String objectIdentifier = adminObject.getIdentifier();
            int type = MMAdminObject.getObjectType((String)className);
            switch (type) {
                case 19: {
                    return this.convertPropertyDefinitions((ComponentObject)this.getConfigurationServiceProxy().getCurrentConfiguration());
                }
                case 8: {
                    return this.convertPropertyDefinitions(this.getHostComponent(objectIdentifier));
                }
                case 11: {
                    return this.convertPropertyDefinitions(this.getProcessComponent(objectIdentifier));
                }
                case 2: {
                    Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
                    ConnectorBinding configBinding = config.getConnectorBinding(MMAdminObject.getNameFromIdentifier((String)objectIdentifier));
                    component = this.getConnectorBindingComponent(objectIdentifier);
                    return this.convertPropertyDefinitions(component, configBinding.getProperties());
                }
                case 3: {
                    ComponentType componentType = this.getConnectorTypeComponentType(objectIdentifier);
                    return this.convertPropertyDefinitions(componentType, new Properties());
                }
                case 4: {
                    Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
                    ServiceComponentDefn defn = config.getServiceComponentDefn(MMAdminObject.getNameFromIdentifier((String)objectIdentifier));
                    return this.convertPropertyDefinitions(this.getDQPComponent(objectIdentifier), defn.getProperties());
                }
                case 15: {
                    return this.convertPropertyDefinitions(this.getResourceComponent(objectIdentifier));
                }
            }
            this.throwProcessingException("ServerMonitoringAdminImpl.Unsupported_Admin_Object", new Object[]{className});
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
        return Collections.EMPTY_LIST;
    }

    public byte[] exportLogs() throws AdminException {
        File resultFile = null;
        String tempDirName = System.getProperty("java.io.tmpdir") + File.separator + "all_logs" + System.currentTimeMillis();
        try {
            resultFile = File.createTempFile("alllogs", ".zip");
            resultFile.deleteOnExit();
            new File(tempDirName).mkdirs();
            SystemState systemState = this.getRuntimeStateAdminAPIHelper().getSystemState();
            Collection hostDatas = systemState.getHosts();
            for (HostData hostData : hostDatas) {
                String hostName = hostData.getName();
                Collection processDatas = hostData.getProcesses();
                Iterator iter2 = processDatas.iterator();
                if (!iter2.hasNext()) continue;
                ProcessData processData = (ProcessData)iter2.next();
                try {
                    byte[] logBytes = this.getRuntimeStateAdminAPIHelper().exportLogs(processData.getHostName(), processData.getName());
                    FileUtils.convertByteArrayToFile((byte[])logBytes, (String)tempDirName, (String)(hostName + ".zip"));
                }
                catch (MetaMatrixComponentException e) {}
            }
            ZipFileUtil.addAll((File)resultFile, (String)tempDirName);
            byte[] byArray = new FileUtil(resultFile.getAbsolutePath()).readBytes();
            return byArray;
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (IOException e) {
            throw new AdminComponentException((Throwable)e);
        }
        finally {
            resultFile.delete();
            FileUtils.removeDirectoryAndChildren((File)new File(tempDirName));
        }
    }

    protected static String trimString(String string) {
        if (string != null) {
            return string.trim();
        }
        return "";
    }

    private ComponentObject getHostComponent(String identifier) throws ConfigurationException {
        Collection hosts = this.getConfigurationServiceProxy().getHosts();
        for (Host host : hosts) {
            if (!identifier.equalsIgnoreCase(host.getName())) continue;
            return host;
        }
        return null;
    }

    private ComponentObject getProcessComponent(String identifier) throws ConfigurationException {
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        Collection defns = config.getVMComponentDefns();
        for (VMComponentDefn defn : defns) {
            String[] identifierParts = new String[]{defn.getHostID().getName(), defn.getName()};
            if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
            return defn;
        }
        return null;
    }

    private ComponentObject getConnectorBindingComponent(String identifier) throws ConfigurationException {
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        Collection components = config.getDeployedComponents();
        for (BasicDeployedComponent bdc : components) {
            String[] identifierParts = new String[]{bdc.getHostID().getName(), bdc.getVMComponentDefnID().getName(), bdc.getName()};
            if (!ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
            return bdc;
        }
        return null;
    }

    private ComponentType getConnectorTypeComponentType(String identifier) throws ConfigurationException {
        Collection types = this.getConfigurationServiceProxy().getAllComponentTypes(false);
        for (ComponentType componentType : types) {
            if (componentType.getComponentTypeCode() != 2 || !identifier.equalsIgnoreCase(componentType.getName())) continue;
            return componentType;
        }
        return null;
    }

    private ComponentObject getDQPComponent(String identifier) throws ConfigurationException {
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        Collection components = config.getDeployedComponents();
        for (BasicDeployedComponent bdc : components) {
            String[] identifierParts = new String[]{bdc.getHostID().getName(), bdc.getVMComponentDefnID().getName(), bdc.getName()};
            if (!QUERY_SERVICE.equals(bdc.getComponentTypeID().getName()) || !ServerMonitoringAdminImpl.identifierMatches(identifier, identifierParts)) continue;
            return bdc;
        }
        return null;
    }

    private ComponentObject getResourceComponent(String identifier) throws ConfigurationException {
        Collection resources = this.getConfigurationServiceProxy().getResources();
        for (SharedResource sr : resources) {
            if (!identifier.equalsIgnoreCase(sr.getName())) continue;
            return sr;
        }
        return null;
    }
}

