/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.admin.api.objects.ProcessObject;
import com.metamatrix.admin.api.objects.Request;
import com.metamatrix.admin.api.server.ServerRuntimeStateAdmin;
import com.metamatrix.admin.objects.MMConnectorBinding;
import com.metamatrix.admin.objects.MMProcess;
import com.metamatrix.admin.objects.MMRequest;
import com.metamatrix.admin.objects.MMVDB;
import com.metamatrix.admin.server.AbstractAdminImpl;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.api.exception.server.InvalidRequestIDException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicDeployedComponent;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeVDBDeleteUtility;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.SystemState;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.service.api.CacheAdmin;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ServerRuntimeStateAdminImpl
extends AbstractAdminImpl
implements ServerRuntimeStateAdmin {
    public ServerRuntimeStateAdminImpl(ServerAdminImpl parent, ClusteredRegistryState registry) {
        super(parent, registry);
    }

    public void cancelRequest(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        String sessionID = null;
        long requestIDLong = -1L;
        try {
            String[] identifierParts = null;
            try {
                identifierParts = MMRequest.buildIdentifierArray((String)identifier);
                sessionID = identifierParts[0];
                requestIDLong = Long.parseLong(identifierParts[1]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.throwProcessingException("ServerRuntimeStateAdminImpl.Invalid_Request_Identifier", new Object[]{identifier, Request.DELIMITER});
            }
        }
        catch (NumberFormatException e) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.Invalid_Request_Identifier", new Object[]{identifier, Request.DELIMITER});
        }
        try {
            RequestID requestID = new RequestID(sessionID, requestIDLong);
            this.getQueryServiceProxy().cancelQuery(requestID, true);
        }
        catch (InvalidRequestIDException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void cancelSourceRequest(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        String sessionID = null;
        long requestIDLong = -1L;
        int nodeID = -1;
        try {
            String[] identifierParts = MMRequest.buildIdentifierArray((String)identifier);
            sessionID = identifierParts[0];
            requestIDLong = Long.parseLong(identifierParts[1]);
            nodeID = Integer.parseInt(identifierParts[2]);
        }
        catch (NumberFormatException e) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.Invalid_Source_Request_Identifier", new Object[]{identifier, Request.DELIMITER});
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.Invalid_Request_Identifier", new Object[]{identifier, Request.DELIMITER});
        }
        try {
            RequestID requestID = new RequestID(sessionID, requestIDLong);
            this.getQueryServiceProxy().cancelQuery(requestID, nodeID);
        }
        catch (InvalidRequestIDException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void startConnectorBinding(String identifier) throws AdminException {
        Collection bindings;
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        if ((bindings = this.parent.getConnectorBindings(identifier)) == null || bindings.size() == 0) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.No_Connector_Bindings_Found", new Object[]{identifier});
        }
        try {
            HashSet expectedServiceNames = new HashSet();
            for (MMConnectorBinding binding : bindings) {
                if (binding.getState() == 1 || binding.getState() == 6) continue;
                String[] identifierParts = binding.getIdentifierArray();
                String hostName = identifierParts[0];
                String processName = identifierParts[1];
                String bindingName = identifierParts[2];
                expectedServiceNames.addAll(this.getServiceNamesFromConfiguration(hostName, processName, bindingName));
                ServiceID serviceID = new ServiceID(binding.getServiceID(), hostName, processName);
                this.getRuntimeStateAdminAPIHelper().restartService(serviceID);
            }
            this.parent.waitForServicesToStart(expectedServiceNames);
        }
        catch (ConfigurationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void startHost(String hostName, boolean waitUntilDone) throws AdminException {
        if (hostName == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        try {
            this.getRuntimeStateAdminAPIHelper().startHost(hostName);
            if (waitUntilDone) {
                Collection expectedServiceNames = this.getServiceNamesFromConfiguration(hostName);
                this.parent.waitForServicesToStart(expectedServiceNames);
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void startProcess(String identifier, boolean waitUntilDone) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        String[] identifierParts = null;
        try {
            identifierParts = MMProcess.buildIdentifierArray((String)identifier);
            if (identifierParts.length != 2) {
                this.throwProcessingException("ServerRuntimeStateAdminImpl.Invalid_Process_Identifier", new Object[]{identifier, ProcessObject.DELIMITER});
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.Invalid_Request_Identifier", new Object[]{identifier, Request.DELIMITER});
        }
        catch (StringIndexOutOfBoundsException e) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.Invalid_Request_Identifier", new Object[]{identifier, Request.DELIMITER});
        }
        String hostName = identifierParts[0];
        String processName = identifierParts[1];
        try {
            this.getRuntimeStateAdminAPIHelper().startProcess(hostName, processName);
            if (waitUntilDone) {
                Collection expectedServiceNames = this.getServiceNamesFromConfiguration(hostName, processName);
                this.parent.waitForServicesToStart(expectedServiceNames);
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void stopConnectorBinding(String identifier, boolean stopNow) throws AdminException {
        Collection bindings;
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        if ((bindings = this.parent.getConnectorBindings(identifier)) == null || bindings.size() == 0) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.No_Connector_Bindings_Found", new Object[]{identifier});
        }
        try {
            HashSet expectedServiceNames = new HashSet();
            for (MMConnectorBinding binding : bindings) {
                String[] identifierParts = binding.getIdentifierArray();
                String hostName = identifierParts[0];
                String processName = identifierParts[1];
                String bindingName = identifierParts[2];
                expectedServiceNames.addAll(this.getServiceNamesFromConfiguration(hostName, processName, bindingName));
                ServiceID serviceID = new ServiceID(binding.getServiceID(), hostName, processName);
                this.getRuntimeStateAdminAPIHelper().stopService(serviceID, stopNow);
            }
            this.parent.waitForServicesToStop(expectedServiceNames);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void stopHost(String hostName, boolean stopNow, boolean waitUntilDone) throws AdminException {
        if (hostName == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        try {
            this.getRuntimeStateAdminAPIHelper().stopHost(hostName, stopNow);
            if (waitUntilDone) {
                boolean done = false;
                while (!done) {
                    done = this.isHostStopped(hostName);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        catch (MultipleException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void stopProcess(String identifier, boolean stopNow, boolean waitUntilDone) throws AdminException {
        Collection processes;
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        if ((processes = this.parent.getProcesses(identifier)) == null || processes.size() == 0) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.No_Processes_Found", new Object[]{identifier});
        } else if (processes.size() > 1) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.Multiple_Processes_Found", new Object[]{identifier});
        }
        try {
            MMProcess process = (MMProcess)processes.iterator().next();
            this.getRuntimeStateAdminAPIHelper().stopProcess(process.getHostName(), process.getProcessName(), stopNow);
            if (waitUntilDone) {
                boolean done = false;
                while (!done) {
                    done = this.isProcessStopped(process.getName(), process.getHostName());
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new AdminProcessingException((Throwable)e);
        }
    }

    public void stopSystem() throws AdminException {
        try {
            this.getRuntimeStateAdminAPIHelper().shutdownServer();
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void bounceSystem(boolean waitUntilDone) throws AdminException {
        try {
            this.getRuntimeStateAdminAPIHelper().bounceServer();
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public void synchronizeSystem(boolean waitUntilDone) throws AdminException {
        try {
            Collection expectedServiceNames = this.getServiceNamesFromConfiguration();
            this.getRuntimeStateAdminAPIHelper().synchronizeServer();
            if (waitUntilDone) {
                this.parent.waitForServicesToStart(expectedServiceNames);
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (MultipleException e) {
            throw new AdminProcessingException((Throwable)e);
        }
    }

    public void clearCache(String cacheIdentifier) throws AdminException {
        if (cacheIdentifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        if (cacheIdentifier != null && (cacheIdentifier.equals("CodeTableCache") || cacheIdentifier.equals("PreparedPlanCache") || cacheIdentifier.equals("QueryServiceResultSetCache") || cacheIdentifier.equals("ConnectorResultSetCache"))) {
            List<ServiceRegistryBinding> serviceBindings = this.registry.getServiceBindings(null, null);
            for (ServiceRegistryBinding serviceBinding : serviceBindings) {
                try {
                    CacheAdmin admin;
                    Map caches;
                    ServiceInterface service = serviceBinding.getService();
                    if (!(service instanceof CacheAdmin) || (caches = (admin = (CacheAdmin)((Object)service)).getCaches()) == null) continue;
                    for (String cacheName : caches.keySet()) {
                        String cacheType = (String)caches.get(cacheName);
                        if (!cacheType.equals(cacheIdentifier)) continue;
                        super.logDetail("ServerRuntimeStateAdminImpl.clearing_cache", new Object[]{cacheName});
                        admin.clearCache(cacheName, null);
                    }
                }
                catch (MetaMatrixComponentException e) {
                    throw new AdminComponentException((Throwable)e);
                }
            }
        } else {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.Invalid_cache_Identifier", new Object[]{cacheIdentifier});
        }
    }

    public void terminateSession(String identifier) throws AdminException {
        if (identifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        try {
            MetaMatrixSessionID sessionID = new MetaMatrixSessionID(identifier);
            this.getSessionServiceProxy().terminateSession(sessionID, null);
        }
        catch (IllegalArgumentException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (InvalidSessionException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new AdminProcessingException((Throwable)e);
        }
        catch (SessionServiceException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new AdminComponentException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changeVDBStatus(String name, String version, int newStatus) throws AdminException {
        Collection vdbs;
        if (name == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        if ((vdbs = this.parent.getVDBs(name)) == null || vdbs.size() == 0) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.No_VDBs_Found", new Object[]{name});
        }
        boolean found = false;
        MMVDB vdb2 = null;
        for (MMVDB vdb2 : vdbs) {
            if (!vdb2.getVDBVersion().equals(version)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.throwProcessingException("ServerRuntimeStateAdminImpl.No_VDBs_Found_With_Version", new Object[]{name, version});
        }
        BasicVirtualDatabaseID vdbID = new BasicVirtualDatabaseID(name, version, vdb2.getUID());
        int currentStatus = vdb2.getState();
        if (newStatus == 4) {
            try {
                if (currentStatus != 2 && currentStatus != 1) {
                    try {
                        RuntimeMetadataCatalog.getInstance().setVDBStatus((VirtualDatabaseID)vdbID, (short)2, this.getUserName());
                        RuntimeMetadataCatalog.getInstance().setVDBStatus((VirtualDatabaseID)vdbID, (short)4, this.getUserName());
                        return;
                    }
                    catch (VirtualDatabaseException e) {
                        throw new AdminProcessingException((Throwable)e);
                    }
                }
                if (currentStatus == 4) return;
                try {
                    RuntimeMetadataCatalog.getInstance().setVDBStatus((VirtualDatabaseID)vdbID, (short)4, this.getUserName());
                    return;
                }
                catch (VirtualDatabaseException e) {
                    throw new AdminProcessingException((Throwable)e);
                }
            }
            finally {
                RuntimeVDBDeleteUtility vdbDeleter = new RuntimeVDBDeleteUtility();
                try {
                    vdbDeleter.deleteVDBMarkedForDelete((VirtualDatabaseID)vdbID);
                }
                catch (VirtualDatabaseException e) {
                    throw new AdminProcessingException((Throwable)e);
                }
                catch (MetaMatrixComponentException e) {
                    throw new AdminComponentException((Throwable)e);
                }
            }
        }
        try {
            RuntimeMetadataCatalog.getInstance().setVDBStatus((VirtualDatabaseID)vdbID, (short)newStatus, this.getUserName());
            return;
        }
        catch (VirtualDatabaseException e) {
            throw new AdminProcessingException((Throwable)e);
        }
    }

    private Collection getServiceNamesFromConfiguration() throws MetaMatrixComponentException {
        ArrayList<String> expectedServiceNames = new ArrayList<String>();
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        Collection components = config.getDeployedComponents();
        for (BasicDeployedComponent component : components) {
            expectedServiceNames.add(component.getID().getFullName());
        }
        return expectedServiceNames;
    }

    private Collection getServiceNamesFromConfiguration(String hostName) throws MetaMatrixComponentException {
        ArrayList<String> expectedServiceNames = new ArrayList<String>();
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        Collection components = config.getDeployedComponents();
        for (BasicDeployedComponent component : components) {
            if (!component.getHostID().getName().equalsIgnoreCase(hostName)) continue;
            expectedServiceNames.add(component.getID().getFullName());
        }
        return expectedServiceNames;
    }

    private Collection getServiceNamesFromConfiguration(String hostName, String processName) throws MetaMatrixComponentException {
        ArrayList<String> expectedServiceNames = new ArrayList<String>();
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        Collection components = config.getDeployedComponents();
        for (BasicDeployedComponent component : components) {
            if (!component.getHostID().getName().equalsIgnoreCase(hostName) || !component.getVMComponentDefnID().getName().equalsIgnoreCase(processName)) continue;
            expectedServiceNames.add(component.getID().getFullName());
        }
        return expectedServiceNames;
    }

    private Collection getServiceNamesFromConfiguration(String hostName, String processName, String serviceName) throws ConfigurationException {
        ArrayList<String> expectedServiceNames = new ArrayList<String>();
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        Collection components = config.getDeployedComponents();
        for (BasicDeployedComponent component : components) {
            if (!component.getHostID().getName().equalsIgnoreCase(hostName) || !component.getVMComponentDefnID().getName().equalsIgnoreCase(processName) || !component.getID().getName().equalsIgnoreCase(serviceName)) continue;
            expectedServiceNames.add(component.getID().getFullName());
        }
        return expectedServiceNames;
    }

    private boolean isProcessStopped(String hostName, String processName) throws MetaMatrixComponentException {
        SystemState systemState = this.getRuntimeStateAdminAPIHelper().getSystemState();
        Collection hostDatas = systemState.getHosts();
        for (HostData hostData : hostDatas) {
            if (!hostData.getName().equalsIgnoreCase(hostName)) continue;
            Collection processDatas = hostData.getProcesses();
            for (ProcessData processData : processDatas) {
                if (!processData.getName().equalsIgnoreCase(processName) || !processData.isRegistered()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isHostStopped(String hostName) throws MetaMatrixComponentException {
        SystemState systemState = this.getRuntimeStateAdminAPIHelper().getSystemState();
        Collection hostDatas = systemState.getHosts();
        for (HostData hostData : hostDatas) {
            if (!hostData.getName().equalsIgnoreCase(hostName)) continue;
            Collection processDatas = hostData.getProcesses();
            for (ProcessData processData : processDatas) {
                if (!processData.isRegistered()) continue;
                return false;
            }
        }
        return true;
    }
}

