/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.admin.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.server.AdminRoles;
import com.metamatrix.admin.api.server.ServerSecurityAdmin;
import com.metamatrix.admin.objects.MMGroup;
import com.metamatrix.admin.objects.MMRole;
import com.metamatrix.admin.server.AbstractAdminImpl;
import com.metamatrix.admin.server.AdminServerPlugin;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.security.api.AuthorizationObjectEditor;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ServerSecurityAdminImpl
extends AbstractAdminImpl
implements ServerSecurityAdmin {
    public ServerSecurityAdminImpl(ServerAdminImpl parent, ClusteredRegistryState registry) {
        super(parent, registry);
    }

    public void assignRoleToGroup(String roleIdentifier, String groupIdentifier) throws AdminException {
        if (!AdminRoles.containsRole((String)roleIdentifier)) {
            Object[] params = new Object[]{roleIdentifier};
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.Non_existant_role", params));
        }
        if (groupIdentifier.equals("*")) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.Cant_use_wildcard"));
        }
        SessionToken adminToken = this.validateSession();
        AuthorizationObjectEditor aoe = new AuthorizationObjectEditor();
        AuthorizationPolicy role = null;
        try {
            role = this.getAuthorizationServiceProxy().getPolicy(adminToken, new AuthorizationPolicyID(roleIdentifier, null, RolePermissionFactory.getRealm()));
        }
        catch (InvalidSessionException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationMgmtException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        role = aoe.addPrincipal(role, new MetaMatrixPrincipalName(groupIdentifier, 1));
        this.executeAuthorizationActions(aoe);
    }

    public void removeRoleFromGroup(String roleIdentifier, String groupIdentifier) throws AdminException {
        if (!AdminRoles.containsRole((String)roleIdentifier)) {
            Object[] params = new Object[]{roleIdentifier};
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.Non_existant_role", params));
        }
        if (groupIdentifier.equals("*")) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.Cant_use_wildcard"));
        }
        SessionToken adminToken = this.validateSession();
        AuthorizationObjectEditor aoe = new AuthorizationObjectEditor();
        AuthorizationPolicy role = null;
        try {
            role = this.getAuthorizationServiceProxy().getPolicy(adminToken, new AuthorizationPolicyID(roleIdentifier, null, RolePermissionFactory.getRealm()));
        }
        catch (InvalidSessionException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationMgmtException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        role = aoe.removePrincipal(role, new MetaMatrixPrincipalName(groupIdentifier, 1));
        this.executeAuthorizationActions(aoe);
    }

    private void executeAuthorizationActions(AuthorizationObjectEditor aoe) throws AdminException {
        ModificationActionQueue maq = aoe.getDestination();
        try {
            this.getAuthorizationServiceProxy().executeTransaction(this.validateSession(), maq.popActions());
        }
        catch (InvalidSessionException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationMgmtException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new AdminComponentException((Throwable)e);
        }
    }

    public Collection getRolesForUser(String userIdentifier) throws AdminException {
        if (userIdentifier.equals("*")) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.Cant_use_wildcard"));
        }
        Collection roleNames = null;
        try {
            roleNames = this.getAuthorizationServiceProxy().getRoleNamesForPrincipal(this.validateSession(), new MetaMatrixPrincipalName(userIdentifier, 0));
        }
        catch (InvalidSessionException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationMgmtException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        ArrayList<MMRole> roles = new ArrayList<MMRole>();
        for (String roleName : roleNames) {
            roles.add(new MMRole(new String[]{roleName}));
        }
        return roles;
    }

    public Collection getGroupsForUser(String userIdentifier) throws AdminException {
        if (userIdentifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        if (userIdentifier.equals("*")) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.Cant_use_wildcard"));
        }
        ArrayList<MMGroup> groups = new ArrayList<MMGroup>();
        Set allMemberships = null;
        try {
            allMemberships = this.getMembershipServiceProxy().getGroupsForUser(userIdentifier);
        }
        catch (MetaMatrixSecurityException e) {
            throw new AdminComponentException((Throwable)e);
        }
        Iterator allMembershipsItr = allMemberships.iterator();
        while (allMembershipsItr.hasNext()) {
            groups.add(new MMGroup(new String[]{(String)allMembershipsItr.next()}));
        }
        return groups;
    }

    public Collection getGroups(String groupIdentifier) throws AdminException {
        if (groupIdentifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        ArrayList<MMGroup> groups = new ArrayList<MMGroup>();
        Set allGroups = null;
        try {
            allGroups = this.getMembershipServiceProxy().getGroupNames();
        }
        catch (MetaMatrixSecurityException e) {
            throw new AdminComponentException((Throwable)e);
        }
        for (String groupName : allGroups) {
            if (!groupIdentifier.equals("*") && !groupName.equals(groupIdentifier)) continue;
            groups.add(new MMGroup(new String[]{groupName}));
        }
        return groups;
    }

    public Collection getRolesForGroup(String groupIdentifier) throws AdminException {
        if (groupIdentifier == null) {
            this.throwProcessingException("AdminImpl.requiredparameter", new Object[0]);
        }
        if (groupIdentifier.equals("*")) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.Cant_use_wildcard"));
        }
        Collection roleNames = null;
        try {
            roleNames = this.getAuthorizationServiceProxy().getRoleNamesForPrincipal(this.validateSession(), new MetaMatrixPrincipalName(groupIdentifier, 1));
        }
        catch (InvalidSessionException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationMgmtException e) {
            throw new AdminComponentException((Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new AdminComponentException((Throwable)e);
        }
        ArrayList<MMRole> roles = new ArrayList<MMRole>();
        for (String roleName : roleNames) {
            roles.add(new MMRole(new String[]{roleName}));
        }
        return roles;
    }

    @Override
    public String importDataRoles(String vdbName, String vdbVersion, char[] xmlContents, AdminOptions options) throws AdminException {
        if (vdbName == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.vdbName_can_not_be_null"));
        }
        if (vdbVersion == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.vdbVersion_can_not_be_null"));
        }
        if (options == null) {
            options = new AdminOptions(2);
        }
        return super.importDataRoles(vdbName, vdbVersion, xmlContents, options);
    }

    @Override
    public char[] exportDataRoles(String vdbName, String vdbVersion) throws AdminException {
        if (vdbName == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.vdbName_can_not_be_null"));
        }
        if (vdbVersion == null) {
            throw new AdminProcessingException(AdminServerPlugin.Util.getString("ServerSecurityAdminImpl.vdbVersion_can_not_be_null"));
        }
        return super.exportDataRoles(vdbName, vdbVersion);
    }
}

