/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.util;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.server.AdminRoles;
import com.metamatrix.common.util.PropertiesUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class AdminMethodRoleResolver {
    public static final String ANONYMOUS_ROLE = "Anonymous";
    private Map methodsToRoles = new HashMap();
    private static final String DEFAULT_METHOD_ROLES_FILE = "methodroles.properties";

    public String getRoleNameForMethod(String methodName) throws AdminException {
        if (!this.methodsToRoles.containsKey(methodName)) {
            Object[] params = new Object[]{methodName};
            String msg = AdminPlugin.Util.getString("AdminMethodRoleResolver.Unknown_method", params);
            throw new AdminProcessingException(msg);
        }
        String roleName = (String)this.methodsToRoles.get(methodName);
        return roleName;
    }

    public void init() throws AdminException {
        Properties properties = null;
        try {
            properties = PropertiesUtils.loadAsResource(this.getClass(), (String)DEFAULT_METHOD_ROLES_FILE);
        }
        catch (IOException err) {
            throw new AdminComponentException("Unable to load methodroles.properties file", (Throwable)err);
        }
        Properties allProps = new Properties();
        allProps.putAll((Map<?, ?>)properties);
        Set validRoleNames = AdminRoles.getAllRoleNames();
        for (String string : allProps.keySet()) {
            String roleName = allProps.getProperty(string);
            if (roleName == null || roleName.length() == 0) {
                Object[] params = new Object[]{string};
                String msg = AdminPlugin.Util.getString("AdminMethodRoleResolver.No_roles_defined_for_method", params);
                throw new AdminComponentException(msg);
            }
            if (!validRoleNames.contains(roleName) && !ANONYMOUS_ROLE.equals(roleName)) {
                Object[] params = new Object[]{string, roleName};
                String msg = AdminPlugin.Util.getString("AdminMethodRoleResolver.Invalid_role_defined_for_method", params);
                throw new AdminComponentException(msg);
            }
            this.methodsToRoles.put(string, roleName);
        }
    }
}

