/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket;

import com.metamatrix.common.comm.exception.SingleInstanceCommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.socket.ChannelListener;
import com.metamatrix.common.comm.platform.socket.ObjectChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.serialization.ObjectDecoder;
import org.jboss.netty.handler.codec.serialization.ObjectEncoder;
import org.jboss.netty.handler.ssl.SslHandler;

@ChannelPipelineCoverage(value="all")
public class SSLAwareChannelHandler
extends SimpleChannelHandler
implements ChannelPipelineFactory {
    private final ChannelListener.ChannelListenerFactory listenerFactory;
    private final SSLEngine engine;
    private final ClassLoader classLoader;
    private Map<Channel, ChannelListener> listeners = Collections.synchronizedMap(new HashMap());
    private AtomicLong objectsRead = new AtomicLong(0L);
    private AtomicLong objectsWritten = new AtomicLong(0L);
    private volatile int maxChannels;
    private ChannelFutureListener completionListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture arg0) throws Exception {
            if (arg0.isSuccess()) {
                SSLAwareChannelHandler.this.objectsWritten.getAndIncrement();
            }
        }
    };

    public SSLAwareChannelHandler(ChannelListener.ChannelListenerFactory listenerFactory, SSLEngine engine, ClassLoader classloader) {
        this.listenerFactory = listenerFactory;
        this.engine = engine;
        this.classLoader = classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelConnected(ChannelHandlerContext ctx, final ChannelStateEvent e) throws Exception {
        ChannelListener listener = this.listenerFactory.createChannelListener(new ObjectChannelImpl(e.getChannel()));
        Map<Channel, ChannelListener> map = this.listeners;
        synchronized (map) {
            this.listeners.put(e.getChannel(), listener);
            this.maxChannels = Math.max(this.maxChannels, this.listeners.size());
        }
        if (this.engine != null) {
            SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
            sslHandler.handshake(e.getChannel()).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture arg0) throws Exception {
                    SSLAwareChannelHandler.this.onConnection(e.getChannel());
                }
            });
        } else {
            this.onConnection(e.getChannel());
        }
    }

    private void onConnection(Channel channel) throws Exception {
        ChannelListener listener = this.listeners.get(channel);
        if (listener != null) {
            listener.onConnection();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ChannelListener listener = this.listeners.get(e.getChannel());
        if (listener != null) {
            listener.exceptionOccurred(e.getCause());
        }
        e.getChannel().close();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.objectsRead.getAndIncrement();
        ChannelListener listener = this.listeners.get(e.getChannel());
        if (listener != null) {
            listener.receivedMessage(e.getMessage());
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ChannelListener listener = this.listeners.remove(e.getChannel());
        if (listener != null) {
            listener.exceptionOccurred((Throwable)new SingleInstanceCommunicationException(CommPlatformPlugin.Util.getString("SSLAwareChannelHandler.channel_closed")));
        }
    }

    public ChannelPipeline getPipeline() throws Exception {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
        if (this.engine != null) {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.engine));
        }
        pipeline.addLast("decoder", (ChannelHandler)new ObjectDecoder(0x1000000, this.classLoader));
        pipeline.addLast("encoder", (ChannelHandler)new ObjectEncoder());
        pipeline.addLast("handler", (ChannelHandler)this);
        return pipeline;
    }

    public long getObjectsRead() {
        return this.objectsRead.get();
    }

    public long getObjectsWritten() {
        return this.objectsWritten.get();
    }

    public int getConnectedChannels() {
        return this.listeners.size();
    }

    public int getMaxConnectedChannels() {
        return this.maxChannels;
    }

    public class ObjectChannelImpl
    implements ObjectChannel {
        private final Channel channel;

        public ObjectChannelImpl(Channel channel) {
            this.channel = channel;
        }

        public void close() {
            this.channel.close();
        }

        public boolean isOpen() {
            return this.channel.isOpen();
        }

        public SocketAddress getRemoteAddress() {
            return this.channel.getRemoteAddress();
        }

        public Object read() throws IOException, ClassNotFoundException {
            throw new UnsupportedOperationException();
        }

        public Future<?> write(Object msg) {
            final ChannelFuture future = this.channel.write(msg);
            future.addListener(SSLAwareChannelHandler.this.completionListener);
            return new Future<Void>(){

                @Override
                public boolean cancel(boolean arg0) {
                    return future.cancel();
                }

                @Override
                public Void get() throws InterruptedException, ExecutionException {
                    future.await();
                    if (!future.isSuccess()) {
                        throw new ExecutionException(future.getCause());
                    }
                    return null;
                }

                @Override
                public Void get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
                    if (future.await(arg0, arg1)) {
                        if (!future.isSuccess()) {
                            throw new ExecutionException(future.getCause());
                        }
                        return null;
                    }
                    throw new TimeoutException();
                }

                @Override
                public boolean isCancelled() {
                    return future.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return future.isDone();
                }
            };
        }
    }
}

