/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.metamatrix.common.comm.platform.socket.server.SocketListener;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.net.ServerSocketConfiguration;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolFactory;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.registry.ClusteredRegistryState;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.platform.vm.controller.ProcessController;
import com.metamatrix.platform.vm.controller.ServerEvents;
import com.metamatrix.platform.vm.controller.SocketListenerStats;
import com.metamatrix.server.HostManagement;
import com.metamatrix.server.Main;
import java.util.Properties;

@Singleton
public class SocketVMController
extends ProcessController {
    public static final String SOCKET_CONTEXT = "ServerSocket";
    private static final String SERVER_PORT = "vm.socketPort";
    private static final String MAX_THREADS = "vm.maxThreads";
    private static final String TIMETOLIVE = "vm.timetolive";
    private static final String INPUT_BUFFER_SIZE = "vm.inputBufferSize";
    private static final String OUTPUT_BUFFER_SIZE = "vm.outputBufferSize";
    private static final int DEFAULT_SERVER_PORT = 31000;
    private static final int DEFAULT_MAX_THREADS = 15;
    private static final long DEFAULT_TIMETOLIVE = 15000L;
    private static final long DEFAULT_WAITFORSERVICES = 500L;
    private static final int DEFAULT_INPUT_BUFFER_SIZE = 102400;
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 102400;
    private static final String SOCKET_WORKER_POOL_NAME = "SocketWorkerQueue";
    private SocketListener listener;
    private WorkerPool workerPool;

    @Inject
    public SocketVMController(@Named(value="Host") Host host, @Named(value="ProcessName") String processName, ClusteredRegistryState registry, ServerEvents serverEvents, MessageBus bus, HostManagement hostManagement) throws Exception {
        super(host, processName, registry, serverEvents, bus, hostManagement);
    }

    @Override
    public void start() {
        super.start();
        this.waitForServices();
        this.startSocketListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean now) {
        if (this.workerPool != null) {
            try {
                this.workerPool.shutdownNow();
            }
            catch (Exception e) {
            }
            finally {
                this.workerPool = null;
            }
        }
        if (this.listener != null) {
            try {
                this.listener.stop();
            }
            catch (Exception exception) {
            }
            finally {
                this.listener = null;
            }
        }
        super.shutdown(now);
    }

    private void startSocketListener() {
        Properties props = this.getProperties();
        int socketPort = PropertiesUtils.getIntProperty((Properties)props, (String)SERVER_PORT, (int)31000);
        int maxThreads = PropertiesUtils.getIntProperty((Properties)props, (String)MAX_THREADS, (int)15);
        long timeToLive = PropertiesUtils.getLongProperty((Properties)props, (String)TIMETOLIVE, (long)15000L);
        int inputBufferSize = PropertiesUtils.getIntProperty((Properties)props, (String)INPUT_BUFFER_SIZE, (int)102400);
        int outputBufferSize = PropertiesUtils.getIntProperty((Properties)props, (String)OUTPUT_BUFFER_SIZE, (int)102400);
        String bindaddress = VMNaming.getBindAddress();
        Object[] param = new Object[]{this.processName, bindaddress, String.valueOf(socketPort)};
        this.logMessage(PlatformPlugin.Util.getString("SocketVMController.1", param));
        this.workerPool = WorkerPoolFactory.newWorkerPool((String)SOCKET_WORKER_POOL_NAME, (int)maxThreads, (long)timeToLive);
        ServerSocketConfiguration helper = new ServerSocketConfiguration();
        try {
            helper.init();
            this.listener = new SocketListener(socketPort, bindaddress, this.clientServices, inputBufferSize, outputBufferSize, this.workerPool, helper.getServerSSLEngine(), helper.isClientEncryptionEnabled(), PlatformProxyHelper.getSessionServiceProxy("ROUND_ROBIN_LOCAL"));
        }
        catch (Exception e) {
            LogManager.logCritical((String)"CONTROLLER", (Throwable)e, (String)PlatformPlugin.Util.getString("SocketVMController.2", param));
            System.exit(1);
        }
    }

    private void waitForServices() {
        boolean isReady = false;
        while (!isReady) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            isReady = this.isStarted();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SocketVMController:  ");
        buffer.append(" socketHost:").append(this.host.getFullName());
        buffer.append(" socketPort:").append(this.listener.getPort());
        return buffer.toString();
    }

    @Override
    protected SocketListenerStats getSocketListenerStats() {
        if (this.listener == null) {
            return null;
        }
        return this.listener.getStats();
    }

    @Override
    protected WorkerPoolStats getProcessPoolStats() {
        if (this.workerPool == null) {
            return null;
        }
        return this.workerPool.getStats();
    }

    @Deprecated
    public static void main(String[] args) throws Exception {
        Main.main(args);
    }
}

