/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.admin.util.AdminMethodRoleResolver;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.platform.admin.apiimpl.IAdminHelper;
import com.metamatrix.platform.security.api.SessionToken;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class AdminAuthorizationInterceptor
implements InvocationHandler {
    private final IAdminHelper authorizationService;
    private final AdminMethodRoleResolver methodNames;
    private final ServerAdmin serverAdmin;

    public AdminAuthorizationInterceptor(IAdminHelper authorizationService, AdminMethodRoleResolver methodNames, ServerAdmin serverAdmin) {
        ArgCheck.isNotNull((Object)authorizationService);
        ArgCheck.isNotNull((Object)methodNames);
        this.authorizationService = authorizationService;
        this.methodNames = methodNames;
        this.serverAdmin = serverAdmin;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        SessionToken adminToken = DQPWorkContext.getWorkContext().getSessionToken();
        String requiredRoleName = this.methodNames.getRoleNameForMethod(method.getName());
        if (!"Anonymous".equals(requiredRoleName)) {
            Object[] msgParts = null;
            boolean msgWillBeRecorded = LogManager.isMessageToBeRecorded((String)"AUDIT_ADMIN", (int)4);
            if (msgWillBeRecorded) {
                msgParts = this.buildAuditMessage(adminToken, requiredRoleName, method);
                LogManager.logInfo((String)"AUDIT_ADMIN", (String)CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_Audit_request", msgParts));
            }
            try {
                this.authorizationService.checkForRequiredRole(adminToken, requiredRoleName);
                LogManager.logInfo((String)"AUDIT_ADMIN", (String)CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_granted", msgParts));
            }
            catch (AuthorizationException err) {
                if (msgParts == null) {
                    msgParts = this.buildAuditMessage(adminToken, requiredRoleName, method);
                }
                String errMsg = CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_not_authorized", msgParts);
                LogManager.logWarning((String)"AUDIT_ADMIN", (String)errMsg);
                throw new AdminProcessingException(errMsg);
            }
            catch (ComponentNotFoundException err) {
                if (msgParts == null) {
                    msgParts = this.buildAuditMessage(adminToken, requiredRoleName, method);
                }
                String errMsg = CommPlatformPlugin.Util.getString("AdminAuthorizationInterceptor.Admin_not_authorized", msgParts);
                LogManager.logWarning((String)"AUDIT_ADMIN", (String)errMsg);
                throw new AdminProcessingException(errMsg);
            }
        }
        try {
            return method.invoke((Object)this.serverAdmin, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private Object[] buildAuditMessage(SessionToken adminToken, String requiredRoleName, Method invocation) {
        return new Object[]{adminToken.getUsername(), adminToken.getSessionID().toString(), requiredRoleName, invocation.getName()};
    }
}

