/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.api.exception.security.MetaMatrixAuthenticationException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.dqp.client.ResultsFuture;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.server.ServerPlugin;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import org.teiid.connector.api.ConnectorException;
import org.teiid.connector.api.CredentialMap;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class LogonImpl
implements ILogon {
    private SessionServiceInterface service;
    private String clusterName;

    public LogonImpl(SessionServiceInterface service, String clusterName) {
        this.service = service;
        this.clusterName = clusterName;
    }

    public LogonResult logon(Properties connProps) throws LogonException, ComponentNotFoundException {
        String applicationName = connProps.getProperty("ApplicationName");
        String user = connProps.getProperty("user");
        String password = connProps.getProperty("password");
        String productName = connProps.getProperty("productName");
        Credentials credential = null;
        if (password != null) {
            credential = new Credentials(password.toCharArray());
        }
        if (connProps.containsKey("credentials")) {
            this.handleCredentials(connProps, user, password);
        }
        Object payload = connProps.get("clientToken");
        try {
            MetaMatrixSessionInfo sessionInfo = this.service.createSession(user, credential, (Serializable)payload, applicationName, productName, connProps);
            MetaMatrixSessionID sessionID = this.updateDQPContext(sessionInfo);
            LogManager.logDetail((String)"SESSION", (Object[])new Object[]{"Logon successful for \"", user, "\" - created SessionID \"", "" + sessionID, "\""});
            return new LogonResult(sessionID, sessionInfo.getUserName(), sessionInfo.getProductInfo(), this.service.getPingInterval(), this.clusterName);
        }
        catch (MetaMatrixAuthenticationException e) {
            throw new LogonException((Throwable)e, e.getMessage());
        }
        catch (ServiceException e) {
            throw new ComponentNotFoundException((Throwable)((Object)e), e.getMessage());
        }
        catch (SessionServiceException e) {
            throw new LogonException((Throwable)e, e.getMessage());
        }
    }

    private void handleCredentials(Properties connProps, String user, String password) throws LogonException {
        if (connProps.containsKey("clientToken")) {
            throw new LogonException(ServerPlugin.Util.getString("LogonImpl.Invalid_use_of_credentials_and_token"));
        }
        try {
            int parenIndex;
            String credentials = connProps.getProperty("credentials");
            CredentialMap credentialMap = null;
            boolean defaultToLogon = false;
            if (credentials.startsWith("defaultToLogon")) {
                defaultToLogon = true;
            }
            credentialMap = (parenIndex = credentials.indexOf("(")) >= 0 ? CredentialMap.parseCredentials((String)credentials.substring(parenIndex)) : new CredentialMap();
            if (defaultToLogon) {
                credentialMap.setDefaultCredentialMode((short)1);
                HashMap<String, String> defaultCredentials = new HashMap<String, String>();
                defaultCredentials.put("user", user);
                defaultCredentials.put("password", password);
                credentialMap.setDefaultCredentials(defaultCredentials);
            } else {
                credentialMap.setDefaultCredentialMode((short)0);
            }
            connProps.put("clientToken", credentialMap);
        }
        catch (ConnectorException e) {
            throw new LogonException(e.getMessage());
        }
        connProps.remove("credentials");
    }

    private MetaMatrixSessionID updateDQPContext(MetaMatrixSessionInfo sessionInfo) {
        MetaMatrixSessionID sessionID = sessionInfo.getSessionID();
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        workContext.setSessionToken(sessionInfo.getSessionToken());
        workContext.setAppName(sessionInfo.getApplicationName());
        workContext.setSessionId(sessionInfo.getSessionID());
        workContext.setTrustedPayload(sessionInfo.getTrustedToken());
        workContext.setUserName(sessionInfo.getUserName());
        workContext.setVdbName(sessionInfo.getProductInfo("VirtualDatabaseName"));
        workContext.setVdbVersion(sessionInfo.getProductInfo("VirtualDatabaseVersion"));
        return sessionID;
    }

    public ResultsFuture<?> logoff() throws InvalidSessionException, MetaMatrixComponentException {
        try {
            this.service.closeSession(DQPWorkContext.getWorkContext().getSessionId());
        }
        catch (SessionServiceException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e));
        }
        return null;
    }

    public ResultsFuture<?> ping() throws InvalidSessionException, MetaMatrixComponentException {
        try {
            this.service.pingServer(DQPWorkContext.getWorkContext().getSessionId());
        }
        catch (ServiceStateException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e));
        }
        return null;
    }

    public void assertIdentity(MetaMatrixSessionID sessionId) throws InvalidSessionException, MetaMatrixComponentException {
        MetaMatrixSessionInfo sessionInfo;
        try {
            sessionInfo = this.service.validateSession(sessionId);
        }
        catch (SessionServiceException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e));
        }
        this.updateDQPContext(sessionInfo);
    }
}

