/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.ExceptionHolder;
import com.metamatrix.common.comm.platform.socket.client.ServiceInvocationStruct;
import com.metamatrix.common.comm.platform.socket.server.ClientInstance;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ReflectionHelper;
import com.metamatrix.dqp.client.ResultsFuture;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import javax.crypto.SealedObject;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class ServerWorkItem
implements Runnable {
    private final ClientInstance socketClientInstance;
    private final Serializable messageKey;
    private final Message message;
    private final ClientServiceRegistry server;
    private final SessionServiceInterface sessionService;

    public ServerWorkItem(ClientInstance socketClientInstance, Serializable messageKey, Message message, ClientServiceRegistry server, SessionServiceInterface sessionService) {
        this.socketClientInstance = socketClientInstance;
        this.messageKey = messageKey;
        this.message = message;
        this.server = server;
        this.sessionService = sessionService;
    }

    @Override
    public void run() {
        boolean encrypt;
        Message result;
        block12: {
            DQPWorkContext.setWorkContext((DQPWorkContext)this.socketClientInstance.getWorkContext());
            if (LogManager.isMessageToBeRecorded((String)"ServerSocket", (int)5)) {
                LogManager.logDetail((String)"ServerSocket", (Object[])new Object[]{"forwarding message to listener:" + this.message});
            }
            result = null;
            String service = null;
            encrypt = this.message.getContents() instanceof SealedObject;
            try {
                Object methodResult;
                if (this.message.getContents() instanceof Throwable) {
                    LogManager.logWarning((String)"ServerSocket", (Throwable)((Throwable)this.message.getContents()), (String)"Exception while deserializing message packet.");
                    result = this.message;
                    break block12;
                }
                this.message.setContents(this.socketClientInstance.getCryptor().unsealObject(this.message.getContents()));
                if (!(this.message.getContents() instanceof ServiceInvocationStruct)) {
                    throw new AssertionError((Object)"unknown message contents");
                }
                final ServiceInvocationStruct serviceStruct = (ServiceInvocationStruct)this.message.getContents();
                Object instance = this.server.getClientService(serviceStruct.targetClass);
                if (instance == null) {
                    throw new ComponentNotFoundException(PlatformPlugin.Util.getString("ServerWorkItem.Component_Not_Found", new Object[]{serviceStruct.targetClass}));
                }
                if (!(instance instanceof ILogon)) {
                    DQPWorkContext workContext = this.socketClientInstance.getWorkContext();
                    this.sessionService.validateSession(workContext.getSessionId());
                }
                service = serviceStruct.targetClass;
                ReflectionHelper helper = new ReflectionHelper(instance.getClass());
                Method m = helper.findBestMethodOnTarget(serviceStruct.methodName, serviceStruct.args);
                try {
                    methodResult = m.invoke(instance, serviceStruct.args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                if (ResultsFuture.class.isAssignableFrom(m.getReturnType()) && methodResult != null) {
                    ResultsFuture future = (ResultsFuture)methodResult;
                    future.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Serializable>(){

                        public void onCompletion(ResultsFuture<Serializable> completedFuture) {
                            Message asynchResult = new Message();
                            try {
                                asynchResult.setContents((Serializable)completedFuture.get());
                            }
                            catch (InterruptedException e) {
                                asynchResult.setContents(ServerWorkItem.this.processException(e, serviceStruct.targetClass));
                            }
                            catch (ExecutionException e) {
                                asynchResult.setContents(ServerWorkItem.this.processException(e.getCause(), serviceStruct.targetClass));
                            }
                            ServerWorkItem.this.sendResult(asynchResult, encrypt);
                        }
                    });
                } else {
                    Message resultHolder = new Message();
                    resultHolder.setContents((Serializable)methodResult);
                    result = resultHolder;
                }
            }
            catch (Throwable t) {
                Message holder = new Message();
                holder.setContents(this.processException(t, service));
                result = holder;
            }
        }
        if (result != null) {
            this.sendResult(result, encrypt);
        }
    }

    void sendResult(Message result, boolean encrypt) {
        if (encrypt) {
            try {
                result.setContents(this.socketClientInstance.getCryptor().sealObject(result.getContents()));
            }
            catch (CryptoException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
        }
        this.socketClientInstance.send(result, this.messageKey);
    }

    private Serializable processException(Throwable e, String service) {
        String context = null;
        if (service != null) {
            context = this.server.getLoggingContextForService(service);
        }
        if (context == null) {
            context = "ROUTER";
        }
        String msg = PlatformPlugin.Util.getString("ServerWorkItem.Received_exception_processing_request");
        if (e instanceof MetaMatrixProcessingException) {
            LogManager.logWarning((String)context, (Throwable)e, (String)msg);
        } else if (e instanceof AdminProcessingException) {
            LogManager.logWarning((String)context, (Throwable)e, (String)msg);
        } else {
            LogManager.logError((String)context, (Throwable)e, (String)msg);
        }
        if (e instanceof AdminException) {
            return e;
        }
        return new ExceptionHolder(e);
    }
}

