/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.socket.ChannelListener;
import com.metamatrix.common.comm.platform.socket.Handshake;
import com.metamatrix.common.comm.platform.socket.ObjectChannel;
import com.metamatrix.common.comm.platform.socket.server.ClientInstance;
import com.metamatrix.common.comm.platform.socket.server.ServerWorkItem;
import com.metamatrix.common.comm.platform.socket.server.SocketListener;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.DhKeyGenerator;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class SocketClientInstance
implements ChannelListener,
ClientInstance {
    private final ObjectChannel objectSocket;
    private final WorkerPool workerPool;
    private final ClientServiceRegistry server;
    private Cryptor cryptor;
    private boolean usingEncryption;
    private DhKeyGenerator keyGen;
    private DQPWorkContext workContext = new DQPWorkContext();
    private SessionServiceInterface sessionService;

    public SocketClientInstance(ObjectChannel objectSocket, WorkerPool workerPool, ClientServiceRegistry server, boolean isClientEncryptionEnabled, SessionServiceInterface sessionService) {
        this.objectSocket = objectSocket;
        this.workerPool = workerPool;
        this.server = server;
        this.usingEncryption = isClientEncryptionEnabled;
        this.sessionService = sessionService;
        SocketAddress address = this.objectSocket.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)address;
            this.workContext.setClientAddress(addr.getAddress().getHostAddress());
            this.workContext.setClientHostname(addr.getHostName());
        }
    }

    @Override
    public void send(Message message, Serializable messageKey) {
        if (LogManager.isMessageToBeRecorded((String)"ServerSocket", (int)5)) {
            LogManager.logDetail((String)"ServerSocket", (Object[])new Object[]{" message: " + message + " for request ID:" + messageKey});
        }
        message.setMessageKey(messageKey);
        this.objectSocket.write((Object)message);
    }

    @Override
    public Cryptor getCryptor() {
        return this.cryptor;
    }

    @Override
    public void exceptionOccurred(Throwable t) {
        LogManager.logDetail((String)"ServerSocket", (Throwable)t, (String)"Unhandled exception, closing client instance");
    }

    @Override
    public void onConnection() throws CommunicationException {
        Handshake handshake = new Handshake();
        handshake.setVersion(SocketListener.getVersionInfo());
        if (this.usingEncryption) {
            byte[] publicKey;
            this.keyGen = new DhKeyGenerator();
            try {
                publicKey = this.keyGen.createPublicKey();
            }
            catch (CryptoException e) {
                throw new CommunicationException((Throwable)e);
            }
            handshake.setPublicKey(publicKey);
        }
        this.objectSocket.write((Object)handshake);
    }

    private void receivedHahdshake(Handshake handshake) throws CommunicationException {
        if (this.usingEncryption) {
            byte[] returnedPublicKey = handshake.getPublicKey();
            if (returnedPublicKey == null) {
                throw new CommunicationException(CommPlatformPlugin.Util.getString("SocketClientInstance.invalid_sessionkey"));
            }
            try {
                this.cryptor = this.keyGen.getSymmetricCryptor(returnedPublicKey);
            }
            catch (CryptoException e) {
                throw new CommunicationException((Throwable)e);
            }
            this.keyGen = null;
        } else {
            this.cryptor = new NullCryptor();
        }
    }

    @Override
    public void receivedMessage(Object msg) throws CommunicationException {
        if (msg instanceof Message) {
            this.processMessagePacket((Message)msg);
        } else if (msg instanceof Handshake) {
            this.receivedHahdshake((Handshake)msg);
        }
    }

    private void processMessagePacket(Message packet) {
        if (LogManager.isMessageToBeRecorded((String)"ServerSocket", (int)5)) {
            LogManager.logDetail((String)"ServerSocket", (Object[])new Object[]{"processing message:" + packet});
        }
        this.workerPool.execute((Runnable)new ServerWorkItem(this, packet.getMessageKey(), packet, this.server, this.sessionService));
    }

    @Override
    public void shutdown() throws CommunicationException {
        this.objectSocket.close();
    }

    @Override
    public DQPWorkContext getWorkContext() {
        return this.workContext;
    }
}

