/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.common.comm.ClientServiceRegistry;
import com.metamatrix.common.comm.platform.socket.ChannelListener;
import com.metamatrix.common.comm.platform.socket.ObjectChannel;
import com.metamatrix.common.comm.platform.socket.SSLAwareChannelHandler;
import com.metamatrix.common.comm.platform.socket.server.SocketClientInstance;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolFactory;
import com.metamatrix.core.util.MetaMatrixProductVersion;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.vm.controller.SocketListenerStats;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class SocketListener
implements ChannelListener.ChannelListenerFactory {
    private ClientServiceRegistry server;
    private WorkerPool workerPool;
    private SSLAwareChannelHandler channelHandler;
    private Channel serverChanel;
    private boolean isClientEncryptionEnabled;
    private SessionServiceInterface sessionService;

    public SocketListener(int port, String bindAddress, ClientServiceRegistry server, int inputBufferSize, int outputBufferSize, WorkerPool workerPool, SSLEngine engine, boolean isClientEncryptionEnabled, SessionServiceInterface sessionService) {
        this.isClientEncryptionEnabled = isClientEncryptionEnabled;
        this.sessionService = sessionService;
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        this.server = server;
        this.workerPool = workerPool;
        if (LogManager.isMessageToBeRecorded((String)"ServerSocket", (int)5)) {
            LogManager.logDetail((String)"ServerSocket", (Object[])new Object[]{"server = " + this.server + "binding to port:" + port});
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 2L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), (ThreadFactory)new WorkerPoolFactory.DefaultThreadFactory("ServerNio"));
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory((Executor)executor, (Executor)executor, Runtime.getRuntime().availableProcessors() * 2);
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        this.channelHandler = new SSLAwareChannelHandler(this, engine, Thread.currentThread().getContextClassLoader());
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.channelHandler);
        bootstrap.setOption("receiveBufferSize", (Object)new Integer(inputBufferSize));
        bootstrap.setOption("sendBufferSize", (Object)new Integer(outputBufferSize));
        bootstrap.setOption("keepAlive", (Object)Boolean.TRUE);
        this.serverChanel = bootstrap.bind((SocketAddress)new InetSocketAddress(bindAddress, port));
    }

    public int getPort() {
        return ((InetSocketAddress)this.serverChanel.getLocalAddress()).getPort();
    }

    static String getVersionInfo() {
        return MetaMatrixProductVersion.VERSION_NUMBER;
    }

    public void stop() {
        this.serverChanel.close();
    }

    public SocketListenerStats getStats() {
        SocketListenerStats stats = new SocketListenerStats();
        stats.objectsRead = this.channelHandler.getObjectsRead();
        stats.objectsWritten = this.channelHandler.getObjectsWritten();
        stats.sockets = this.channelHandler.getConnectedChannels();
        stats.maxSockets = this.channelHandler.getMaxConnectedChannels();
        return stats;
    }

    @Override
    public ChannelListener createChannelListener(ObjectChannel channel) {
        return new SocketClientInstance(channel, this.workerPool, this.server, this.isClientEncryptionEnabled, this.sessionService);
    }
}

