/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.connection;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.TransactionInterface;

public abstract class BaseTransaction
implements TransactionInterface {
    private static boolean ROLLBACK_ON_FINALIZE = true;
    private ManagedConnection connection;
    private boolean readonly = true;
    private boolean isEnded = false;

    protected void finalize() {
        this.close();
    }

    protected BaseTransaction(ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
        if (connection == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.010.0001"));
        }
        this.readonly = readonly;
        this.connection = connection;
    }

    @Override
    public void commit() throws ManagedConnectionException {
        if (this.isEnded()) {
            if (this.isClosed()) {
                throw new ManagedConnectionException("ERR.003.010.0002", CommonPlugin.Util.getString("ERR.003.010.0002"));
            }
            throw new ManagedConnectionException("ERR.003.010.0003", CommonPlugin.Util.getString("ERR.003.010.0003"));
        }
        this.connection.commit();
        this.isEnded = true;
    }

    @Override
    public void rollback() throws ManagedConnectionException {
        if (this.isEnded()) {
            if (this.isClosed()) {
                throw new ManagedConnectionException("ERR.003.010.0002", CommonPlugin.Util.getString("ERR.003.010.0002"));
            }
            throw new ManagedConnectionException("ERR.003.010.0003", CommonPlugin.Util.getString("ERR.003.010.0003"));
        }
        if (!this.isReadonly()) {
            this.connection.rollback();
            this.isEnded = true;
        }
    }

    public ManagedConnection getConnection() throws ManagedConnectionException {
        if (this.isClosed()) {
            throw new ManagedConnectionException("ERR.003.010.0002", CommonPlugin.Util.getString("ERR.003.010.0002"));
        }
        return this.connection;
    }

    @Override
    public final boolean isReadonly() {
        return this.readonly;
    }

    public final boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public final boolean isClosed() {
        return this.connection == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isClosed()) {
            try {
                if (this.isReadonly()) {
                    if (!this.isEnded()) {
                        this.commit();
                    }
                    this.connection.close();
                } else {
                    if (!this.isEnded()) {
                        if (ROLLBACK_ON_FINALIZE) {
                            this.rollback();
                        } else {
                            this.commit();
                        }
                    }
                    this.connection.close();
                }
            }
            catch (ManagedConnectionException managedConnectionException) {
            }
            finally {
                this.connection = null;
            }
        }
    }

    public static final boolean getRollbackOnFinalize() {
        return ROLLBACK_ON_FINALIZE;
    }

    public static final void setRollbackOnFinalize(boolean rollback) {
        ROLLBACK_ON_FINALIZE = rollback;
    }
}

