/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.connection;

import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.properties.UnmodifiableProperties;
import java.util.Properties;

public abstract class ManagedConnection {
    public static final String DRIVER = "com.metamatrix.common.connection.ManagedConnection.Driver";
    public static final String PROTOCOL = "com.metamatrix.common.connection.ManagedConnection.Protocol";
    public static final String DATABASE = "com.metamatrix.common.connection.ManagedConnection.Database";
    public static final String USERNAME = "com.metamatrix.common.connection.ManagedConnection.User";
    public static final String PASSWORD = "com.metamatrix.common.connection.ManagedConnection.Password";
    private String userName;
    private Properties environment;
    private boolean isOpen = false;
    private ConnectionStatistics stats;
    private static final String NOT_ASSIGNED = "NoUserNameAssigned";

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ManagedConnection(Properties env) {
        Properties p = null;
        this.userName = NOT_ASSIGNED;
        if (env != null) {
            Properties properties = env;
            synchronized (properties) {
                p = (Properties)env.clone();
            }
        } else {
            p = new Properties();
        }
        this.environment = p instanceof UnmodifiableProperties ? p : new UnmodifiableProperties(p);
        this.stats = new ConnectionStatistics();
    }

    protected void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public final Properties getEnvironment() {
        return this.environment;
    }

    public final synchronized void open() throws ManagedConnectionException {
        if (!this.isOpen) {
            this.openConnection();
            this.isOpen = true;
        }
    }

    public final synchronized void close() throws ManagedConnectionException {
        if (this.isOpen) {
            this.closeConnection();
            this.isOpen = false;
        }
    }

    protected abstract void openConnection() throws ManagedConnectionException;

    protected abstract void closeConnection() throws ManagedConnectionException;

    public final void setForRead() throws ManagedConnectionException {
        this.prepareForRead();
    }

    public final void setForWrite() throws ManagedConnectionException {
        this.prepareForWrite();
    }

    protected abstract void prepareForRead() throws ManagedConnectionException;

    protected abstract void prepareForWrite() throws ManagedConnectionException;

    public final void commit() throws ManagedConnectionException {
        this.performCommit();
    }

    public final void rollback() throws ManagedConnectionException {
        this.performRollback();
    }

    protected abstract void performCommit() throws ManagedConnectionException;

    protected abstract void performRollback() throws ManagedConnectionException;

    public final ConnectionStatistics getStats() {
        return this.stats;
    }

    public static class ConnectionStatistics {
        private int concurrentUsers = 0;
        private long lastUsed;

        public ConnectionStatistics() {
            this.markAsUsed();
        }

        public synchronized int getConcurrentUserCount() {
            return this.concurrentUsers;
        }

        public synchronized boolean hasConcurrentUsers() {
            return this.concurrentUsers > 0;
        }

        public synchronized void addConcurrentUser() {
            ++this.concurrentUsers;
            this.markAsUsed();
        }

        public synchronized void removeConcurrentUser() {
            if (this.concurrentUsers > 0) {
                --this.concurrentUsers;
            }
        }

        public synchronized long getLastUsed() {
            return this.lastUsed;
        }

        public synchronized void markAsUsed() {
            this.lastUsed = System.currentTimeMillis();
        }
    }
}

