/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.connection.jdbc;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.log.LogManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCMgdResourceConnection
extends ManagedConnection {
    private Connection jdbcConnection;
    private boolean originalAutocommit;

    public JDBCMgdResourceConnection(Properties env, String userName) {
        super(env);
        super.setUserName(userName);
    }

    public Connection getConnection() {
        return this.jdbcConnection;
    }

    @Override
    protected void openConnection() throws ManagedConnectionException {
        try {
            this.jdbcConnection = JDBCConnectionPoolHelper.getInstance().getConnection();
            this.originalAutocommit = this.jdbcConnection.getAutoCommit();
        }
        catch (SQLException rpe) {
            this.closeConnection();
            throw new ManagedConnectionException(rpe, "ERR.003.010.0010", CommonPlugin.Util.getString("ERR.003.010.0010", new Object[]{this.getUserName()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void closeConnection() throws ManagedConnectionException {
        if (this.jdbcConnection == null) return;
        LogManager.logTrace((String)"RESOURCE_POOLING", (Object[])new Object[]{"Closing connection to JDBC"});
        Throwable firstException = null;
        try {
            boolean isClosed = false;
            try {
                isClosed = this.jdbcConnection.isClosed();
                if (isClosed) return;
                if (this.jdbcConnection.getAutoCommit()) return;
                this.jdbcConnection.commit();
                return;
            }
            catch (Exception sqle) {
                firstException = sqle;
                LogManager.logWarning((String)"RESOURCE_POOLING", (Throwable)sqle, (String)CommonPlugin.Util.getString("ERR.003.010.0011"));
                throw sqle;
            }
            finally {
                if (!isClosed) {
                    try {
                        this.jdbcConnection.setAutoCommit(this.originalAutocommit);
                    }
                    catch (Throwable t) {
                        LogManager.logWarning((String)"RESOURCE_POOLING", (Throwable)t, (String)CommonPlugin.Util.getString("ERR.003.010.0011"));
                        if (firstException == null) {
                            firstException = t;
                            throw t;
                        }
                    }
                    finally {
                        block34: {
                            try {
                                this.jdbcConnection.close();
                            }
                            catch (Throwable t) {
                                LogManager.logWarning((String)"RESOURCE_POOLING", (Throwable)t, (String)CommonPlugin.Util.getString("ERR.003.010.0011"));
                                if (firstException != null) break block34;
                                throw t;
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new ManagedConnectionException(e, "ERR.003.010.0012", CommonPlugin.Util.getString("ERR.003.010.0012", new Object[]{this.getEnvironment().getProperty("com.metamatrix.common.connection.ManagedConnection.Database", "NoDatabaseProperty")}));
        }
        finally {
            this.jdbcConnection = null;
        }
    }

    @Override
    protected void prepareForRead() throws ManagedConnectionException {
        if (this.jdbcConnection != null) {
            try {
                LogManager.logTrace((String)"RESOURCE_POOLING", (Object[])new Object[]{"Attempting to set JDBC transaction to READ ONLY"});
                this.jdbcConnection.setAutoCommit(true);
            }
            catch (SQLException e) {
                LogManager.logTrace((String)"RESOURCE_POOLING", (Object[])new Object[]{"UNABLE to set JDBC transaction to READ ONLY"});
            }
        }
    }

    @Override
    protected void prepareForWrite() throws ManagedConnectionException {
        if (this.jdbcConnection != null) {
            try {
                LogManager.logTrace((String)"RESOURCE_POOLING", (Object[])new Object[]{"Attempting to set JDBC transaction to WRITE"});
                this.jdbcConnection.setAutoCommit(false);
            }
            catch (SQLException e) {
                LogManager.logTrace((String)"RESOURCE_POOLING", (Object[])new Object[]{"UNABLE to set JDBC transaction to WRITE"});
            }
        }
    }

    @Override
    protected void performCommit() throws ManagedConnectionException {
        if (this.jdbcConnection != null) {
            try {
                LogManager.logTrace((String)"RESOURCE_POOLING", (Object[])new Object[]{"Attempting to commit JDBC transaction"});
                if (!this.jdbcConnection.getAutoCommit()) {
                    this.jdbcConnection.commit();
                }
            }
            catch (SQLException e) {
                throw new ManagedConnectionException(e, "ERR.003.010.0013", CommonPlugin.Util.getString("ERR.003.010.0013", new Object[]{this.getEnvironment().getProperty("com.metamatrix.common.connection.ManagedConnection.Database", "NoDatabaseProperty")}));
            }
        }
    }

    @Override
    protected void performRollback() throws ManagedConnectionException {
        if (this.jdbcConnection != null) {
            try {
                if (!this.jdbcConnection.getAutoCommit()) {
                    this.jdbcConnection.rollback();
                }
            }
            catch (SQLException e) {
                throw new ManagedConnectionException(e, "ERR.003.010.0014", CommonPlugin.Util.getString("ERR.003.010.0014", new Object[]{this.getEnvironment().getProperty("com.metamatrix.common.connection.ManagedConnection.Database", "NoDatabaseProperty")}));
            }
        }
    }
}

