/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.TransactionMgr;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.ExtensionModuleEvent;
import com.metamatrix.common.extensionmodule.ExtensionModuleTypes;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleRuntimeException;
import com.metamatrix.common.extensionmodule.exception.InvalidExtensionModuleTypeException;
import com.metamatrix.common.extensionmodule.spi.ExtensionModuleTransaction;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleWriter;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.server.ResourceFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;

public class ExtensionModuleManager {
    public static final int SOURCE_NAME_LENGTH_LIMIT = 255;
    public static final int SOURCE_DESCRIPTION_LENGTH_LIMIT = 255;
    public static final int SOURCE_CONTENTS_LENGTH_LIMIT = 1000000000;
    private static final String LOG_CONTEXT = "EXTENSION_MODULE";
    private TransactionMgr transMgr;
    private static ExtensionModuleManager extensionModuleManager;
    private boolean isInitialized = false;
    private static final String NOT_INITIALIZED_MESSAGE;

    public static synchronized ExtensionModuleManager getInstance() {
        if (extensionModuleManager == null) {
            extensionModuleManager = new ExtensionModuleManager();
            extensionModuleManager.init();
        }
        return extensionModuleManager;
    }

    static synchronized ExtensionModuleManager getInstance(Properties env) {
        if (extensionModuleManager == null) {
            extensionModuleManager = new ExtensionModuleManager();
            extensionModuleManager.init(env);
        }
        return extensionModuleManager;
    }

    static synchronized void reInit() {
        extensionModuleManager = null;
    }

    public ExtensionModuleDescriptor addSource(String principalName, String type, String sourceName, byte[] source, String description, boolean enabled) throws DuplicateExtensionModuleException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)principalName);
        ArgCheck.isNotNull((Object)type);
        ArgCheck.isNotNull((Object)sourceName);
        ArgCheck.isNotNull((Object)source);
        ArgCheck.isNotZeroLength((String)principalName);
        ArgCheck.isNotZeroLength((String)type);
        ArgCheck.isNotZeroLength((String)sourceName);
        ArgCheck.isTrue((sourceName.length() <= 255 ? 1 : 0) != 0, (String)CommonPlugin.Util.getString("ERR.014.004.0009", new Object[]{255}));
        ArgCheck.isTrue((source.length <= 1000000000 ? 1 : 0) != 0, (String)CommonPlugin.Util.getString("ERR.014.004.0011", new Object[]{1000000000}));
        ExtensionModuleTypes.checkTypeIsValid(type);
        description = this.adjustLengthToFit(description);
        LogManager.logDetail((String)LOG_CONTEXT, (Object[])new Object[]{"Adding module", sourceName, "of type", type, "for principal", principalName});
        ExtensionModuleDescriptor result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getWriteTransaction();
            result = transaction.addSource(principalName, type, sourceName, source, this.getChecksum(source), description, enabled);
            transaction.commit();
            this.notifyFileChanged();
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    private String adjustLengthToFit(String oriString) {
        if (oriString != null && oriString.length() > 255) {
            oriString = oriString.substring(0, 255);
        }
        return oriString;
    }

    public void removeSource(String principalName, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)principalName);
        ArgCheck.isNotNull((Object)sourceName);
        ArgCheck.isNotZeroLength((String)principalName);
        ArgCheck.isNotZeroLength((String)sourceName);
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Removing module", sourceName, "for principal", principalName});
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getWriteTransaction();
            transaction.removeSource(principalName, sourceName);
            transaction.commit();
            this.notifyFileChanged();
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.014.004.0015", CommonPlugin.Util.getString("ERR.014.004.0015", new Object[]{sourceName, principalName}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
    }

    public Collection getSourceTypes() throws MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        return ExtensionModuleTypes.ALL_TYPES;
    }

    public List getSourceNames() throws MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        List result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            result = transaction.getSourceNames();
            transaction.commit();
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.014.004.0016", CommonPlugin.Util.getString("ERR.014.004.0016"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    public List getSourceDescriptors() throws MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        List result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            result = transaction.getSourceDescriptors();
            transaction.commit();
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.014.004.0017", CommonPlugin.Util.getString("ERR.014.004.0017"));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    public List getSourceDescriptors(String type) throws InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)type);
        ArgCheck.isNotZeroLength((String)type);
        ExtensionModuleTypes.checkTypeIsValid(type);
        List result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            boolean includeDisabled = true;
            result = transaction.getSourceDescriptors(type, includeDisabled);
            transaction.commit();
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.014.004.0018", CommonPlugin.Util.getString("ERR.014.004.0018", new Object[]{type}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    public boolean isSourceInUse(String sourceName) throws MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)sourceName);
        ArgCheck.isNotZeroLength((String)sourceName);
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            boolean result = transaction.isNameInUse(sourceName);
            transaction.commit();
            boolean bl = result;
            return bl;
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.014.004.0019", CommonPlugin.Util.getString("ERR.014.004.0019", new Object[]{sourceName}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
    }

    public ExtensionModuleDescriptor getSourceDescriptor(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)sourceName);
        ArgCheck.isNotZeroLength((String)sourceName);
        ExtensionModuleDescriptor result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            result = transaction.getSourceDescriptor(sourceName);
            transaction.commit();
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    public List setSearchOrder(String principalName, List sourceNames) throws ExtensionModuleOrderingException, MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)principalName);
        ArgCheck.isNotNull((Object)sourceNames);
        ArgCheck.isNotZeroLength((String)principalName);
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Setting search order for module(s)", sourceNames, "for principal", principalName});
        List result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getWriteTransaction();
            transaction.setSearchOrder(principalName, sourceNames);
            transaction.commit();
            transaction = this.getReadTransaction();
            result = transaction.getSourceDescriptors();
            transaction.commit();
            this.notifyFileChanged();
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.014.004.0020", CommonPlugin.Util.getString("ERR.014.004.0020", new Object[]{principalName}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    public List setEnabled(String principalName, Collection sourceNames, boolean enabled) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)principalName);
        ArgCheck.isNotNull((Object)sourceNames);
        ArgCheck.isNotZeroLength((String)principalName);
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Setting 'enabled' attribute of module(s)", sourceNames, "to", enabled ? Boolean.TRUE : Boolean.FALSE, "for principal", principalName});
        ArrayList<ExtensionModuleDescriptor> result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getWriteTransaction();
            transaction.setEnabled(principalName, sourceNames, enabled);
            transaction.commit();
            transaction = this.getReadTransaction();
            List descriptors = transaction.getSourceDescriptors();
            transaction.commit();
            this.notifyFileChanged();
            result = new ArrayList<ExtensionModuleDescriptor>(descriptors.size());
            ExtensionModuleDescriptor descriptor2 = null;
            for (ExtensionModuleDescriptor descriptor2 : descriptors) {
                if (!sourceNames.contains(descriptor2.getName())) continue;
                result.add(descriptor2);
            }
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.014.004.0021", CommonPlugin.Util.getString("ERR.014.004.0021", new Object[]{principalName}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    public byte[] getSource(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)sourceName);
        ArgCheck.isNotZeroLength((String)sourceName);
        LogManager.logDetail((String)LOG_CONTEXT, (Object[])new Object[]{"Attempting to load extension module", sourceName});
        byte[] result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getReadTransaction();
            result = transaction.getSource(sourceName);
            transaction.commit();
        }
        catch (ExtensionModuleNotFoundException e) {
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0022", CommonPlugin.Util.getString("ERR.014.004.0022", new Object[]{sourceName}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    public ExtensionModuleDescriptor setSource(String principalName, String sourceName, byte[] source) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)principalName);
        ArgCheck.isNotNull((Object)sourceName);
        ArgCheck.isNotZeroLength((String)principalName);
        ArgCheck.isNotZeroLength((String)sourceName);
        ArgCheck.isTrue((source.length <= 1000000000 ? 1 : 0) != 0, (String)CommonPlugin.Util.getString("ERR.014.004.0011", new Object[]{1000000000}));
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Setting content of module", sourceName, "for principal", principalName});
        ExtensionModuleDescriptor result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getWriteTransaction();
            result = transaction.setSource(principalName, sourceName, source, this.getChecksum(source));
            transaction.commit();
            this.notifyFileChanged();
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.014.004.0012", CommonPlugin.Util.getString("ERR.014.004.0012", new Object[]{sourceName}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    public ExtensionModuleDescriptor setSourceName(String principalName, String sourceName, String newName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)principalName);
        ArgCheck.isNotNull((Object)sourceName);
        ArgCheck.isNotNull((Object)newName);
        ArgCheck.isNotZeroLength((String)principalName);
        ArgCheck.isNotZeroLength((String)sourceName);
        ArgCheck.isNotZeroLength((String)newName);
        ArgCheck.isTrue((sourceName.length() <= 255 ? 1 : 0) != 0, (String)CommonPlugin.Util.getString("ERR.014.004.0009", new Object[]{255}));
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Changing name of module from", sourceName, "to", newName, "for principal", principalName});
        ExtensionModuleDescriptor result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getWriteTransaction();
            result = transaction.setSourceName(principalName, sourceName, newName);
            transaction.commit();
            this.notifyFileChanged();
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.014.004.0023", CommonPlugin.Util.getString("ERR.014.004.0023", new Object[]{sourceName}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    public ExtensionModuleDescriptor setSourceDescription(String principalName, String sourceName, String description) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        ArgCheck.isNotNull((Object)principalName);
        ArgCheck.isNotNull((Object)sourceName);
        ArgCheck.isNotZeroLength((String)principalName);
        ArgCheck.isNotZeroLength((String)sourceName);
        description = this.adjustLengthToFit(description);
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Setting description of module", sourceName, "for principal", principalName});
        ExtensionModuleDescriptor result = null;
        ExtensionModuleTransaction transaction = null;
        try {
            transaction = this.getWriteTransaction();
            result = transaction.setSourceDescription(principalName, sourceName, description);
            transaction.commit();
        }
        catch (ManagedConnectionException e) {
            throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.014.004.0024", CommonPlugin.Util.getString("ERR.014.004.0024", new Object[]{sourceName}));
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning((String)LOG_CONTEXT, (Throwable)txne, (String)CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
            }
        }
        return result;
    }

    public void init() {
        String value;
        Properties resourceProps = new Properties();
        String key = "metamatrix.extensionsource.connection.Factory";
        if (resourceProps.getProperty(key) == null && (value = CurrentConfiguration.getInstance().getProperties().getProperty(key)) != null) {
            resourceProps.setProperty(key, value);
        }
        this.init(resourceProps);
    }

    protected void init(Properties env) {
        LogManager.logDetail((String)LOG_CONTEXT, (Object[])new Object[]{"Initializing with Properties:", env});
        this.isInitialized = true;
        try {
            if (env.getProperty("metamatrix.extensionsource.connection.Factory") == null) {
                env.setProperty("metamatrix.extensionsource.connection.Factory", "com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleTransactionFactory");
            }
            env.setProperty("metamatrix.common.connection.transaction.factory", env.getProperty("metamatrix.extensionsource.connection.Factory"));
            this.transMgr = new TransactionMgr(env, "ExtensionModuleManager");
        }
        catch (ManagedConnectionException e) {
            LogManager.logError((String)LOG_CONTEXT, (Throwable)((Object)e), (String)CommonPlugin.Util.getString("ERR.014.004.0028"));
            this.isInitialized = false;
        }
        if (!this.isInitialized) {
            LogManager.logDetail((String)LOG_CONTEXT, (Object[])new Object[]{"ExtensionModuleManager could not be initialized with properties ", env});
        }
    }

    private long getChecksum(byte[] data) {
        CRC32 algorithm = new CRC32();
        algorithm.update(data, 0, data.length);
        return algorithm.getValue();
    }

    protected ExtensionModuleTransaction getReadTransaction() throws ManagedConnectionException {
        return (ExtensionModuleTransaction)this.transMgr.getReadTransaction();
    }

    protected ExtensionModuleTransaction getWriteTransaction() throws ManagedConnectionException {
        return (ExtensionModuleTransaction)this.transMgr.getWriteTransaction();
    }

    private static final void checkIsTrue(boolean condition, String failMessage) {
        if (!condition) {
            throw new ExtensionModuleRuntimeException(failMessage);
        }
    }

    public void notifyFileChanged() {
        try {
            MessageBus bus = ResourceFinder.getMessageBus();
            if (bus != null) {
                bus.processEvent(new ExtensionModuleEvent(JDBCExtensionModuleWriter.class, -100));
            }
        }
        catch (Exception e) {
            LogManager.logError((String)LOG_CONTEXT, (Throwable)e, (String)e.getMessage());
        }
    }

    static {
        NOT_INITIALIZED_MESSAGE = CommonPlugin.Util.getString("ERR.014.004.0007");
    }
}

