/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.connection.BaseTransaction;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.SimpleManagedConnection;
import com.metamatrix.common.connection.TransactionFactory;
import com.metamatrix.common.connection.TransactionInterface;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.common.extensionmodule.spi.ExtensionModuleTransaction;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FileExtensionModuleFactory
implements TransactionFactory {
    Properties env;

    @Override
    public ManagedConnection createConnection(Properties env, String userName) throws ManagedConnectionException {
        this.env = env;
        return new SimpleManagedConnection(env, userName);
    }

    @Override
    public TransactionInterface createTransaction(ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
        return new FileExtensionModuletransaction(this.env, connection, readonly);
    }

    static class FileExtensionModuletransaction
    extends BaseTransaction
    implements ExtensionModuleTransaction {
        File extensionDir;
        Map<String, ExtensionModuleDescriptor> extMap = new HashMap<String, ExtensionModuleDescriptor>();

        FileExtensionModuletransaction(Properties props, ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
            super(connection, readonly);
            this.extensionDir = new File(props.getProperty("extension.dir", "./extensions"));
            if (!this.extensionDir.exists()) {
                this.extensionDir.mkdirs();
            }
            int i = 0;
            for (File f : this.extensionDir.listFiles()) {
                this.extMap.put(f.getName(), new ExtensionModuleDescriptor(f.getName(), this.getType(f.getName()), i++, true, f.getAbsolutePath(), "system", "now", "system", "now", (long)i));
            }
        }

        private String getType(String source) {
            if (source.endsWith(".jar")) {
                return "JAR File";
            }
            if (source.endsWith(".vdb")) {
                return "VDB File";
            }
            if (source.endsWith(".xmi")) {
                return "Function Definition";
            }
            return "Miscellaneous Type";
        }

        @Override
        public ExtensionModuleDescriptor addSource(String principalName, String type, String sourceName, byte[] source, long checksum, String description, boolean enabled) throws DuplicateExtensionModuleException, MetaMatrixComponentException {
            try {
                FileUtils.write((byte[])source, (File)new File(this.extensionDir, sourceName));
            }
            catch (IOException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
            return new ExtensionModuleDescriptor(sourceName, type, 1, enabled, description, principalName, "now", principalName, "now", checksum);
        }

        @Override
        public byte[] getSource(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
            File f = new File(this.extensionDir, sourceName);
            if (f.exists()) {
                FileUtil util = new FileUtil(f);
                return util.readBytes();
            }
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(sourceName);
            if (in != null) {
                return this.readBytes(in);
            }
            throw new ExtensionModuleNotFoundException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readBytes(InputStream input) throws ExtensionModuleNotFoundException {
            byte[] byArray;
            block7: {
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                try {
                    byte[] buffer = new byte[1024];
                    int readCount = input.read(buffer);
                    while (readCount > 0) {
                        result.write(buffer, 0, readCount);
                        readCount = input.read(buffer);
                    }
                    byArray = result.toByteArray();
                    if (input == null) break block7;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ExtensionModuleNotFoundException();
                    }
                }
                input.close();
            }
            return byArray;
        }

        @Override
        public ExtensionModuleDescriptor getSourceDescriptor(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
            ExtensionModuleDescriptor m = this.extMap.get(sourceName);
            if (m == null) {
                throw new ExtensionModuleNotFoundException();
            }
            return m;
        }

        @Override
        public List getSourceDescriptors() throws MetaMatrixComponentException {
            return new ArrayList<ExtensionModuleDescriptor>(this.extMap.values());
        }

        @Override
        public List getSourceDescriptors(String type, boolean includeDisabled) throws MetaMatrixComponentException {
            ArrayList<ExtensionModuleDescriptor> result = new ArrayList<ExtensionModuleDescriptor>();
            for (ExtensionModuleDescriptor desc : this.getSourceDescriptors()) {
                if (!desc.getType().equals(type) || !includeDisabled && !desc.isEnabled()) continue;
                result.add(new ExtensionModuleDescriptor(desc));
            }
            return result;
        }

        @Override
        public List getSourceNames() throws MetaMatrixComponentException {
            ArrayList<String> result = new ArrayList<String>();
            for (ExtensionModuleDescriptor desc : this.getSourceDescriptors()) {
                result.add(desc.getName());
            }
            return result;
        }

        @Override
        public boolean isNameInUse(String sourceName) throws MetaMatrixComponentException {
            return true;
        }

        @Override
        public boolean needsRefresh() throws MetaMatrixComponentException, UnsupportedOperationException {
            return false;
        }

        @Override
        public void removeSource(String principalName, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
            ExtensionModuleDescriptor m = this.extMap.remove(sourceName);
            File f = new File(this.extensionDir, sourceName);
            if (f.exists()) {
                f.delete();
            }
            if (m == null) {
                throw new ExtensionModuleNotFoundException();
            }
        }

        @Override
        public void setEnabled(String principalName, Collection sourceNames, boolean enabled) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        }

        @Override
        public void setSearchOrder(String principalName, List sourceNames) throws ExtensionModuleOrderingException, MetaMatrixComponentException {
        }

        @Override
        public ExtensionModuleDescriptor setSource(String principalName, String sourceName, byte[] source, long checksum) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
            ExtensionModuleDescriptor m = this.extMap.get(sourceName);
            File f = new File(this.extensionDir, sourceName);
            if (f.exists()) {
                f.delete();
            }
            FileUtil file = new FileUtil(new File(this.extensionDir, sourceName));
            file.writeBytes(source);
            if (m == null) {
                this.extMap.put(sourceName, new ExtensionModuleDescriptor(sourceName, this.getType(sourceName), 1, true, sourceName, principalName, "now", principalName, "now", checksum));
            }
            return m;
        }

        @Override
        public ExtensionModuleDescriptor setSourceDescription(String principalName, String sourceName, String description) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
            ExtensionModuleDescriptor m = this.extMap.get(sourceName);
            if (m == null) {
                throw new ExtensionModuleNotFoundException();
            }
            m.setDescription(description);
            return m;
        }

        @Override
        public ExtensionModuleDescriptor setSourceName(String principalName, String sourceName, String newName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
            ExtensionModuleDescriptor m;
            File f = new File(this.extensionDir, sourceName);
            if (f.exists()) {
                f.renameTo(new File(this.extensionDir, newName));
            }
            if ((m = this.extMap.remove(sourceName)) == null) {
                throw new ExtensionModuleNotFoundException();
            }
            m.setName(newName);
            m.setCreatedBy(principalName);
            this.extMap.put(newName, m);
            return m;
        }
    }
}

