/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.protocol.extensionjar;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.protocol.URLFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AllPermission;
import java.security.Permission;

public class ExtensionJarURLConnection
extends URLConnection {
    private ExtensionModuleManager manager;

    public ExtensionJarURLConnection(URL url, ExtensionModuleManager manager) throws MalformedURLException, IOException {
        super(url);
        this.manager = manager;
        this.setDefaultUseCaches(false);
    }

    @Override
    public Permission getPermission() throws IOException {
        return new AllPermission();
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.getURL().openConnection();
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return new BufferedInputStream(new ByteArrayInputStream(this.getBytes()));
    }

    private byte[] getBytes() throws IOException {
        try {
            return this.manager.getSource(URLFactory.getFileName(this.getURL().getFile()));
        }
        catch (ExtensionModuleNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        catch (MetaMatrixComponentException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int getContentLength() {
        try {
            return this.getBytes().length;
        }
        catch (IOException ioe) {
            return -1;
        }
    }
}

