/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.spi.jdbc.FileCache;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleUtil;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.common.log.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class JDBCExtensionModuleReader {
    private static final String CONTEXT = "JDBC_EXT_MODULE_TRANSACTION";
    private static FileCache fileCache = null;

    private static void initFileCache() {
        if (fileCache == null) {
            fileCache = new FileCache();
            String typesToCacheString = CurrentConfiguration.getInstance().getProperties().getProperty("metamatrix.server.extensionTypesToCache");
            if (typesToCacheString != null) {
                StringTokenizer tokenizer = new StringTokenizer(typesToCacheString, ",");
                while (tokenizer.hasMoreTokens()) {
                    String type = tokenizer.nextToken().trim();
                    fileCache.addTypeToCache(type);
                }
            }
        }
    }

    public static List getSourceNames(Connection jdbcConnection) throws MetaMatrixComponentException {
        PreparedStatement statement = null;
        ResultSet results = null;
        String sql = "SELECT FILE_NAME FROM CS_EXT_FILES ORDER BY SEARCH_POS";
        ArrayList<String> sourceNames = new ArrayList<String>();
        try {
            statement = jdbcConnection.prepareStatement(sql);
            if (!statement.execute()) {
                throw new MetaMatrixComponentException("ERR.014.004.0046", CommonPlugin.Util.getString("ERR.014.004.0046", new Object[]{sql}));
            }
            results = statement.getResultSet();
            while (results.next()) {
                sourceNames.add(results.getString("FILE_NAME"));
            }
        }
        catch (SQLException se) {
            try {
                throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0047", CommonPlugin.Util.getString("ERR.014.004.0047", new Object[]{sql}));
            }
            catch (Throwable throwable) {
                JDBCExtensionModuleReader.close(results);
                JDBCExtensionModuleReader.close(statement);
                throw throwable;
            }
        }
        JDBCExtensionModuleReader.close(results);
        JDBCExtensionModuleReader.close(statement);
        return sourceNames;
    }

    public static byte[] getSource(String sourceName, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException, SQLException {
        if (JDBCExtensionModuleUtil.isConfigurationModel(sourceName)) {
            return JDBCExtensionModuleReader.getConfigContent(sourceName, jdbcConnection);
        }
        return JDBCExtensionModuleReader.getFileContent(sourceName, jdbcConnection);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getConfigContent(String sourceName, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException, SQLException {
        String sql = null;
        PreparedStatement statement = null;
        ResultSet results = null;
        sql = "SELECT CONFIG_CONTENTS FROM CS_EXT_FILES WHERE FILE_NAME= ? ";
        JDBCPlatform platform = JDBCExtensionModuleReader.getPlatform(jdbcConnection);
        byte[] data = null;
        try {
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, sourceName);
            if (!statement.execute()) {
                throw new MetaMatrixComponentException("ERR.014.004.0046", CommonPlugin.Util.getString("ERR.014.004.0046", new Object[]{sql}));
            }
            results = statement.getResultSet();
            try {
                if (!results.next()) throw new ExtensionModuleNotFoundException(sourceName);
                data = platform.convertClobToByteArray(results, "CONFIG_CONTENTS");
            }
            catch (Throwable e) {
                throw new MetaMatrixComponentException(e.getMessage());
            }
        }
        catch (SQLException se) {
            try {
                throw se;
                catch (MetaMatrixComponentException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0047", CommonPlugin.Util.getString("ERR.014.004.0047", new Object[]{sql}));
                }
            }
            catch (Throwable throwable) {
                JDBCExtensionModuleReader.close(results);
                JDBCExtensionModuleReader.close(statement);
                throw throwable;
            }
        }
        JDBCExtensionModuleReader.close(results);
        JDBCExtensionModuleReader.close(statement);
        return data;
    }

    private static synchronized byte[] getFileContent(String sourceName, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException, SQLException {
        JDBCExtensionModuleReader.initFileCache();
        CheckSumAndType csat = JDBCExtensionModuleReader.loadChecksumAndType(sourceName, jdbcConnection);
        long checksum = csat.getChecksum();
        String type = csat.getType();
        long cachedChecksum = fileCache.getChecksum(sourceName);
        byte[] bytes = null;
        if (cachedChecksum == checksum) {
            bytes = fileCache.getBytes(sourceName);
        }
        if (bytes == null) {
            bytes = JDBCExtensionModuleReader.loadBytes(sourceName, jdbcConnection);
            fileCache.put(sourceName, checksum, bytes, type);
        }
        return bytes;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CheckSumAndType loadChecksumAndType(String sourceName, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException, SQLException {
        CheckSumAndType result = new CheckSumAndType();
        String sql = null;
        PreparedStatement statement = null;
        ResultSet results = null;
        sql = "SELECT CHKSUM, FILE_TYPE FROM CS_EXT_FILES WHERE FILE_NAME= ? ";
        try {
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, sourceName);
            if (!statement.execute()) {
                throw new MetaMatrixComponentException("ERR.014.004.0046", CommonPlugin.Util.getString("ERR.014.004.0046", new Object[]{sql}));
            }
            results = statement.getResultSet();
            if (!results.next()) throw new ExtensionModuleNotFoundException(sourceName);
            result.setChecksum(results.getLong("CHKSUM"));
            result.setType(results.getString("FILE_TYPE"));
        }
        catch (SQLException se) {
            try {
                throw se;
                catch (ExtensionModuleNotFoundException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0047", CommonPlugin.Util.getString("ERR.014.004.0047", new Object[]{sql}));
                }
            }
            catch (Throwable throwable) {
                JDBCExtensionModuleReader.close(results);
                JDBCExtensionModuleReader.close(statement);
                throw throwable;
            }
        }
        JDBCExtensionModuleReader.close(results);
        JDBCExtensionModuleReader.close(statement);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] loadBytes(String sourceName, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException, SQLException {
        String sql = null;
        PreparedStatement statement = null;
        ResultSet results = null;
        sql = "SELECT FILE_CONTENTS FROM CS_EXT_FILES WHERE FILE_NAME= ? ";
        Object dataObj = null;
        statement = jdbcConnection.prepareStatement(sql);
        statement.setString(1, sourceName);
        if (!statement.execute()) {
            throw new MetaMatrixComponentException("ERR.014.004.0046", CommonPlugin.Util.getString("ERR.014.004.0046", new Object[]{sql}));
        }
        results = statement.getResultSet();
        if (!results.next()) throw new ExtensionModuleNotFoundException(sourceName);
        dataObj = results.getObject("FILE_CONTENTS");
        JDBCExtensionModuleReader.close(results);
        JDBCExtensionModuleReader.close(statement);
        byte[] data = null;
        try {
            JDBCPlatform platform = JDBCPlatformFactory.getPlatform(jdbcConnection);
            return platform.convertToByteArray(dataObj);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0049", CommonPlugin.Util.getString("ERR.014.004.0049"));
        }
        catch (SQLException se) {
            try {
                throw se;
                catch (ExtensionModuleNotFoundException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0047", CommonPlugin.Util.getString("ERR.014.004.0047", new Object[]{sql}));
                }
            }
            catch (Throwable throwable) {
                JDBCExtensionModuleReader.close(results);
                JDBCExtensionModuleReader.close(statement);
                throw throwable;
            }
        }
    }

    public static ExtensionModuleDescriptor getSourceDescriptor(String sourceName, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        String sql;
        ResultSet results;
        PreparedStatement statement;
        block6: {
            statement = null;
            results = null;
            sql = "SELECT FILE_NAME, FILE_DESC, FILE_TYPE, SEARCH_POS, IS_ENABLED, CREATED_BY, CREATION_DATE, UPDATED_BY, UPDATE_DATE, CHKSUM  FROM CS_EXT_FILES  WHERE FILE_NAME = ? ";
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, sourceName);
            if (!statement.execute()) {
                throw new MetaMatrixComponentException("ERR.014.004.0046", CommonPlugin.Util.getString("ERR.014.004.0046", new Object[]{sql}));
            }
            results = statement.getResultSet();
            if (!results.next()) break block6;
            ExtensionModuleDescriptor extensionModuleDescriptor = JDBCExtensionModuleReader.buildExtensionDescriptor(results);
            JDBCExtensionModuleReader.close(results);
            JDBCExtensionModuleReader.close(statement);
            return extensionModuleDescriptor;
        }
        try {
            try {
                throw new ExtensionModuleNotFoundException(sourceName);
            }
            catch (SQLException se) {
                throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0047", CommonPlugin.Util.getString("ERR.014.004.0047", new Object[]{sql}));
            }
        }
        catch (Throwable throwable) {
            JDBCExtensionModuleReader.close(results);
            JDBCExtensionModuleReader.close(statement);
            throw throwable;
        }
    }

    public static List getSourceDescriptors(String type, boolean includeDisabled, Connection jdbcConnection) throws MetaMatrixComponentException {
        PreparedStatement statement = null;
        ResultSet results = null;
        String sql = null;
        boolean bytype = false;
        if (type == null || type.length() == 0) {
            sql = "SELECT FILE_NAME, FILE_DESC, FILE_TYPE, SEARCH_POS, IS_ENABLED, CREATED_BY, CREATION_DATE, UPDATED_BY, UPDATE_DATE, CHKSUM  FROM CS_EXT_FILES ";
        } else {
            bytype = true;
            sql = "SELECT FILE_NAME, FILE_DESC, FILE_TYPE, SEARCH_POS, IS_ENABLED, CREATED_BY, CREATION_DATE, UPDATED_BY, UPDATE_DATE, CHKSUM  FROM CS_EXT_FILES  WHERE FILE_TYPE = ? ";
        }
        ArrayList<ExtensionModuleDescriptor> descriptors = new ArrayList<ExtensionModuleDescriptor>();
        try {
            statement = jdbcConnection.prepareStatement(sql);
            if (bytype) {
                statement.setString(1, type);
            }
            if (!statement.execute()) {
                throw new MetaMatrixComponentException("ERR.014.004.0046", CommonPlugin.Util.getString("ERR.014.004.0046", new Object[]{sql}));
            }
            results = statement.getResultSet();
            while (results.next()) {
                ExtensionModuleDescriptor desc = JDBCExtensionModuleReader.buildExtensionDescriptor(results);
                if (includeDisabled) {
                    descriptors.add(desc);
                    continue;
                }
                if (!desc.isEnabled()) continue;
                descriptors.add(desc);
            }
        }
        catch (SQLException se) {
            try {
                throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0047", CommonPlugin.Util.getString("ERR.014.004.0047", new Object[]{sql}));
            }
            catch (Throwable throwable) {
                JDBCExtensionModuleReader.close(results);
                JDBCExtensionModuleReader.close(statement);
                throw throwable;
            }
        }
        JDBCExtensionModuleReader.close(results);
        JDBCExtensionModuleReader.close(statement);
        Collections.sort(descriptors);
        return descriptors;
    }

    public static int getExtensionModuleCount(Connection jdbcConnection) throws MetaMatrixComponentException {
        return JDBCExtensionModuleReader.executeIntFunctionSQL("SELECT  COUNT(*) FROM CS_EXT_FILES", jdbcConnection);
    }

    public static int executeIntFunctionSQL(String sql, Connection jdbcConnection) throws MetaMatrixComponentException {
        PreparedStatement statement = null;
        ResultSet results = null;
        int result = -1;
        try {
            statement = jdbcConnection.prepareStatement(sql);
            if (!statement.execute()) {
                throw new MetaMatrixComponentException("ERR.014.004.0046", CommonPlugin.Util.getString("ERR.014.004.0046", new Object[]{sql}));
            }
            results = statement.getResultSet();
            if (!results.next()) {
                throw new MetaMatrixComponentException("ERR.014.004.0050", CommonPlugin.Util.getString("ERR.014.004.0050", new Object[]{sql}));
            }
            int resultColumn = 1;
            result = results.getInt(resultColumn);
        }
        catch (SQLException se) {
            try {
                throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0046", CommonPlugin.Util.getString("ERR.014.004.0046", new Object[]{sql}));
            }
            catch (Throwable throwable) {
                JDBCExtensionModuleReader.close(results);
                JDBCExtensionModuleReader.close(statement);
                throw throwable;
            }
        }
        JDBCExtensionModuleReader.close(results);
        JDBCExtensionModuleReader.close(statement);
        return result;
    }

    public static boolean isNameInUse(String sourceName, Connection jdbcConnection) throws MetaMatrixComponentException {
        boolean bl;
        String sql;
        ResultSet results;
        PreparedStatement statement;
        block6: {
            statement = null;
            results = null;
            sql = "SELECT FILE_UID FROM CS_EXT_FILES WHERE FILE_NAME= ? ";
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, sourceName);
            if (!statement.execute()) {
                throw new MetaMatrixComponentException("ERR.014.004.0046", CommonPlugin.Util.getString("ERR.014.004.0046", new Object[]{sql}));
            }
            results = statement.getResultSet();
            if (!results.next()) break block6;
            boolean bl2 = true;
            JDBCExtensionModuleReader.close(results);
            JDBCExtensionModuleReader.close(statement);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException se) {
            try {
                throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0047", CommonPlugin.Util.getString("ERR.014.004.0047", new Object[]{sql}));
            }
            catch (Throwable throwable) {
                JDBCExtensionModuleReader.close(results);
                JDBCExtensionModuleReader.close(statement);
                throw throwable;
            }
        }
        JDBCExtensionModuleReader.close(results);
        JDBCExtensionModuleReader.close(statement);
        return bl;
    }

    private static void close(PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (SQLException e) {
                LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0048"));
            }
        }
    }

    private static void close(ResultSet resultset) {
        if (resultset != null) {
            try {
                resultset.close();
                resultset = null;
            }
            catch (SQLException e) {
                LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0048"));
            }
        }
    }

    private static JDBCPlatform getPlatform(Connection jdbcConnection) throws MetaMatrixComponentException {
        try {
            return JDBCPlatformFactory.getPlatform(jdbcConnection);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0067", CommonPlugin.Util.getString("ERR.014.004.0067"));
        }
    }

    public static ExtensionModuleDescriptor buildExtensionDescriptor(ResultSet resultSet) throws MetaMatrixComponentException {
        try {
            ExtensionModuleDescriptor module = new ExtensionModuleDescriptor(resultSet.getString("FILE_NAME"), resultSet.getString("FILE_TYPE"), resultSet.getInt("SEARCH_POS"), resultSet.getBoolean("IS_ENABLED"), resultSet.getString("FILE_DESC"), resultSet.getString("CREATED_BY"), resultSet.getString("CREATION_DATE"), resultSet.getString("UPDATED_BY"), resultSet.getString("UPDATE_DATE"), resultSet.getLong("CHKSUM"));
            return module;
        }
        catch (SQLException e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0044", CommonPlugin.Util.getString("ERR.014.004.0044"));
        }
    }

    private static class CheckSumAndType {
        private long checksum;
        private String type;

        private CheckSumAndType() {
        }

        public void setChecksum(long checksum) {
            this.checksum = checksum;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

