/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleReader;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleWriter;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.core.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.CRC32;

public final class JDBCExtensionModuleUtil {
    private static final String PRINCIPAL = "JDBCExtensionUtil";
    private static Set configurationNames = new HashSet();
    private Properties properties;

    public JDBCExtensionModuleUtil(Properties overrideResourceProps) {
        this.properties = overrideResourceProps;
        if (this.properties == null) {
            this.properties = new Properties();
        }
    }

    public void exportExtensionModule(OutputStream outputStream, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Connection connection = null;
        try {
            int bytesRead;
            connection = JDBCConnectionPoolHelper.getInstance().getConnection();
            byte[] data = JDBCExtensionModuleReader.getSource(sourceName, connection);
            if (data == null) {
                System.out.println(CommonPlugin.Util.getString("ERR.014.004.0068", new Object[]{sourceName}));
                throw new ExtensionModuleNotFoundException("ERR.014.004.0069", CommonPlugin.Util.getString("ERR.014.004.0069", new Object[]{sourceName}));
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            BufferedInputStream isContent = new BufferedInputStream(bais);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = ((InputStream)isContent).read(buff, 0, buff.length))) {
                outputStream.write(buff, 0, bytesRead);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (ExtensionModuleNotFoundException notFound) {
            throw notFound;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0070", CommonPlugin.Util.getString("ERR.014.004.0070", new Object[]{sourceName}));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e1) {}
        }
    }

    public void exportExtensionModule(String outputFileName, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Connection connection = null;
        try {
            connection = JDBCConnectionPoolHelper.getInstance().getConnection();
            byte[] data = JDBCExtensionModuleReader.getSource(sourceName, connection);
            if (data == null || data.length == 0) {
                throw new ExtensionModuleNotFoundException("ERR.014.004.0069", CommonPlugin.Util.getString("ERR.014.004.0069", new Object[]{sourceName}));
            }
            FileUtils.write((byte[])data, (String)outputFileName);
        }
        catch (ExtensionModuleNotFoundException notFound) {
            throw notFound;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0006", CommonPlugin.Util.getString("ERR.014.004.0006", new Object[]{sourceName, outputFileName}));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e1) {}
        }
    }

    public void importExtensionModule(String importFileName, String extName, String extType, String extDesc) throws ExtensionModuleNotFoundException, DuplicateExtensionModuleException, MetaMatrixComponentException {
        Connection connection = null;
        FileInputStream stream = null;
        try {
            byte[] data;
            connection = JDBCConnectionPoolHelper.getInstance().getConnection();
            boolean inuse = JDBCExtensionModuleReader.isNameInUse(extName, connection);
            File aFile = new File(importFileName);
            if (!aFile.exists()) {
                throw new MetaMatrixComponentException("ERR.014.004.0064", CommonPlugin.Util.getString("ERR.014.004.0064", new Object[]{importFileName}));
            }
            try {
                stream = new FileInputStream(aFile);
            }
            catch (FileNotFoundException e) {
                throw new MetaMatrixComponentException("ERR.014.004.0064", CommonPlugin.Util.getString("ERR.014.004.0064", new Object[]{importFileName}));
            }
            int size = (int)aFile.length();
            try {
                data = ByteArrayHelper.toByteArray((InputStream)stream, (int)(size + 1));
            }
            catch (IOException e1) {
                throw new MetaMatrixComponentException((Throwable)e1, "ERR.014.004.0070", CommonPlugin.Util.getString("ERR.014.004.0070", new Object[]{importFileName}));
            }
            if (inuse) {
                JDBCExtensionModuleWriter.setSource(PRINCIPAL, extName, data, this.getChecksum(data), connection);
            } else {
                JDBCExtensionModuleWriter.addSource(PRINCIPAL, extType, extName, data, this.getChecksum(data), extDesc, true, connection);
            }
        }
        catch (MetaMatrixComponentException mce) {
            throw mce;
        }
        catch (Exception e) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e3) {
                    // empty catch block
                }
            }
            throw new MetaMatrixComponentException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e1) {}
        }
        connection = null;
    }

    public static boolean isConfigurationModel(String sourceName) {
        return configurationNames.contains(sourceName);
    }

    static void addConfigurationModelName(String sourceName) {
        configurationNames.add(sourceName);
    }

    static void removeConfigurationModelName(String sourceName) {
        configurationNames.remove(sourceName);
    }

    public void importExtensionModule(String importFileName, String extName, String extType, String extDesc, String position) throws ExtensionModuleNotFoundException, DuplicateExtensionModuleException, MetaMatrixComponentException {
        this.importExtensionModule(importFileName, extName, extType, extDesc);
        this.positionExtensionModule(extName, position);
    }

    public void deleteExtensionModule(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        Connection connection = null;
        try {
            connection = JDBCConnectionPoolHelper.getInstance().getConnection();
            boolean inuse = JDBCExtensionModuleReader.isNameInUse(sourceName, connection);
            if (!inuse) {
                return;
            }
            JDBCExtensionModuleWriter.removeSource(PRINCIPAL, sourceName, connection);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0071", CommonPlugin.Util.getString("ERR.014.004.0071", new Object[]{sourceName}));
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e1) {}
        }
    }

    protected void positionExtensionModule(String extName, String position) throws ExtensionModuleNotFoundException, DuplicateExtensionModuleException, MetaMatrixComponentException {
        int pos = -1;
        if (position == null) {
            return;
        }
        try {
            pos = new Integer(position);
        }
        catch (Throwable t) {
            return;
        }
        Connection connection = null;
        try {
            connection = JDBCConnectionPoolHelper.getInstance().getConnection();
            LinkedList<String> orderList = new LinkedList<String>();
            List descriptors = JDBCExtensionModuleReader.getSourceDescriptors(null, true, connection);
            ExtensionModuleDescriptor desc2 = null;
            boolean inserted = false;
            for (ExtensionModuleDescriptor desc2 : descriptors) {
                if (desc2.getName().equals(extName)) continue;
                if (!inserted) {
                    if (desc2.getPosition() < pos) {
                        orderList.add(desc2.getName());
                        continue;
                    }
                    if (desc2.getPosition() < pos) continue;
                    orderList.add(extName);
                    orderList.add(desc2.getName());
                    inserted = true;
                    continue;
                }
                orderList.add(desc2.getName());
            }
            JDBCExtensionModuleWriter.setSearchOrder(PRINCIPAL, orderList, connection);
        }
        catch (MetaMatrixComponentException mce) {
            throw mce;
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e1) {}
        }
    }

    private long getChecksum(byte[] data) {
        CRC32 algorithm = new CRC32();
        algorithm.update(data, 0, data.length);
        return algorithm.getValue();
    }

    static {
        configurationNames.add("Next Startup");
        configurationNames.add("Startup");
    }
}

