/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleReader;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleUtil;
import com.metamatrix.common.id.dbid.DBIDGenerator;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.StringUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class JDBCExtensionModuleWriter {
    private static final String CONTEXT = "JDBC_EXT_MODULE_TRANSACTION";
    private static final int MAX_DESC_LEN = 4000;
    private static String IS_TRUE = "1";
    private static String IS_FALSE = "0";

    public static ExtensionModuleDescriptor addSource(String principalName, String type, String sourceName, byte[] data, long checksum, String description, boolean enabled, Connection jdbcConnection) throws DuplicateExtensionModuleException, MetaMatrixComponentException {
        String date = DateUtil.getCurrentDateAsString();
        return JDBCExtensionModuleWriter.addSource(principalName, date, principalName, date, type, sourceName, data, checksum, description, enabled, jdbcConnection);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExtensionModuleDescriptor addSource(String createdBy, String createdDate, String updatedBy, String updatedDate, String type, String sourceName, byte[] data, long checksum, String description, boolean enabled, Connection jdbcConnection) throws DuplicateExtensionModuleException, MetaMatrixComponentException {
        boolean firstException;
        boolean orignalAutocommit;
        int position;
        ExtensionModuleDescriptor descriptor;
        String sql;
        block25: {
            LogManager.logTrace((String)CONTEXT, (Object[])new Object[]{"adding extension module  " + sourceName + " containing # bytes: " + data.length});
            Statement statement = null;
            sql = null;
            descriptor = null;
            description = StringUtil.truncString((String)description, (int)4000);
            position = JDBCExtensionModuleWriter.getNextPosition(jdbcConnection);
            boolean isConfigModel = JDBCExtensionModuleUtil.isConfigurationModel(sourceName);
            orignalAutocommit = true;
            firstException = false;
            try {
                sql = isConfigModel ? "INSERT  INTO CS_EXT_FILES(FILE_UID,CHKSUM,FILE_NAME,SEARCH_POS,IS_ENABLED,FILE_DESC,CREATED_BY,CREATION_DATE,UPDATED_BY,UPDATE_DATE,FILE_TYPE) VALUES " : "INSERT  INTO CS_EXT_FILES(FILE_UID,CHKSUM,FILE_NAME,SEARCH_POS,IS_ENABLED,FILE_DESC,CREATED_BY,CREATION_DATE,UPDATED_BY,UPDATE_DATE,FILE_TYPE) VALUES ";
                long longUID = DBIDGenerator.getInstance().getID("CS_EXT_FILES");
                orignalAutocommit = jdbcConnection.getAutoCommit();
                jdbcConnection.setAutoCommit(false);
                sql = sql + "(?,?,?,?,?,?,?,?,?,?,?)";
                statement = jdbcConnection.prepareStatement(sql);
                statement.setLong(1, longUID);
                statement.setLong(2, checksum);
                statement.setString(3, sourceName);
                statement.setInt(4, position);
                statement.setString(5, enabled ? IS_TRUE : IS_FALSE);
                statement.setString(6, description);
                statement.setString(7, createdBy);
                statement.setString(8, createdDate);
                statement.setString(9, updatedBy);
                statement.setString(10, updatedDate);
                statement.setString(11, type);
                if (statement.executeUpdate() != 1) {
                    if (JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        throw new DuplicateExtensionModuleException(CommonPlugin.Util.getString("ERR.014.004.0053", new Object[]{sourceName}));
                    }
                    throw new MetaMatrixComponentException("ERR.014.004.0054", CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
                }
                if (isConfigModel) {
                    JDBCExtensionModuleWriter.updateConfig(updatedBy, sourceName, data, checksum, jdbcConnection, "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, CONFIG_CONTENTS= ?  WHERE FILE_NAME= ? ");
                } else {
                    JDBCExtensionModuleWriter.updateFile(updatedBy, sourceName, data, checksum, jdbcConnection, "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, FILE_CONTENTS= empty_blob()  WHERE FILE_NAME= ? ");
                }
                jdbcConnection.commit();
                if (statement == null) break block25;
            }
            catch (SQLException se) {
                try {
                    firstException = true;
                    try {
                        jdbcConnection.rollback();
                    }
                    catch (SQLException re) {
                        // empty catch block
                    }
                    if (JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        throw new DuplicateExtensionModuleException(sourceName);
                    }
                    throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0054", CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
                    catch (DuplicateExtensionModuleException e) {
                        firstException = true;
                        throw e;
                    }
                    catch (MetaMatrixComponentException e) {
                        firstException = true;
                        throw e;
                    }
                    catch (Exception e) {
                        firstException = true;
                        throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0054", CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
                    }
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                            statement = null;
                        }
                        catch (SQLException e) {
                            LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0048"));
                        }
                    }
                    try {
                        jdbcConnection.setAutoCommit(orignalAutocommit);
                        throw throwable;
                    }
                    catch (SQLException e) {
                        if (!firstException) {
                            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0054", CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
                        }
                        LogManager.logDetail((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
                    }
                    throw throwable;
                }
            }
            try {
                statement.close();
                statement = null;
            }
            catch (SQLException e) {
                LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0048"));
            }
        }
        try {
            jdbcConnection.setAutoCommit(orignalAutocommit);
        }
        catch (SQLException e) {
            if (!firstException) {
                throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0054", CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
            }
            LogManager.logDetail((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0054", new Object[]{sourceName, sql}));
        }
        descriptor = new ExtensionModuleDescriptor(sourceName, type, position, enabled, description, createdBy, createdDate, updatedBy, updatedDate, checksum);
        LogManager.logTrace((String)CONTEXT, (Object[])new Object[]{"success! " + sourceName});
        return descriptor;
    }

    public static void setSource(String principalName, String sourceName, byte[] data, long checksum, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        if (JDBCExtensionModuleUtil.isConfigurationModel(sourceName)) {
            JDBCExtensionModuleWriter.updateConfig(principalName, sourceName, data, checksum, jdbcConnection, "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, CONFIG_CONTENTS= ?  WHERE FILE_NAME= ? ");
        } else {
            JDBCExtensionModuleWriter.updateFile(principalName, sourceName, data, checksum, jdbcConnection, "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, FILE_CONTENTS= empty_blob()  WHERE FILE_NAME= ? ");
        }
    }

    private static void updateConfig(String principalName, String sourceName, byte[] data, long checksum, Connection jdbcConnection, String sql) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        block35: {
            LogManager.logTrace((String)CONTEXT, (Object[])new Object[]{"setting extension module file " + sourceName + " containing # bytes: " + data.length});
            JDBCPlatform platform = JDBCExtensionModuleWriter.getPlatform(jdbcConnection);
            Statement statement = null;
            boolean original_autocommit = true;
            try {
                original_autocommit = jdbcConnection.getAutoCommit();
                if (platform.usesStreamsForClobBinding()) {
                    jdbcConnection.setAutoCommit(false);
                    sql = "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, CONFIG_CONTENTS= empty_clob()  WHERE FILE_NAME= ? ";
                    statement = jdbcConnection.prepareStatement(sql);
                    statement.setString(1, principalName);
                    statement.setString(2, DateUtil.getCurrentDateAsString());
                    statement.setLong(3, checksum);
                    statement.setString(4, sourceName);
                    if (statement.executeUpdate() != 1) {
                        if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                            throw new ExtensionModuleNotFoundException(CommonPlugin.Util.getString("ERR.014.004.0059", new Object[]{sourceName}));
                        }
                        throw new MetaMatrixComponentException("ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", new Object[]{sql}));
                    }
                    statement.close();
                    sql = "SELECT CONFIG_CONTENTS FROM CS_EXT_FILES WHERE FILE_NAME= ? ";
                    sql = sql + " FOR UPDATE";
                    statement = jdbcConnection.prepareStatement(sql);
                    statement.setString(1, sourceName);
                    if (!statement.execute()) {
                        throw new MetaMatrixComponentException("ERR.014.004.0072", CommonPlugin.Util.getString("ERR.014.004.0072", new Object[]{sourceName, sql}));
                    }
                    ResultSet results = statement.getResultSet();
                    try {
                        if (results.next()) {
                            platform.setClob(results, data, "CONFIG_CONTENTS");
                            jdbcConnection.commit();
                            break block35;
                        }
                        throw new MetaMatrixComponentException("ERR.014.004.0064", CommonPlugin.Util.getString("ERR.014.004.0064", new Object[]{sourceName}));
                    }
                    catch (SQLException se) {
                        try {
                            jdbcConnection.rollback();
                        }
                        catch (SQLException sr) {
                            // empty catch block
                        }
                        throw se;
                    }
                    finally {
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (SQLException e) {
                                LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0073"));
                            }
                        }
                        try {
                            jdbcConnection.setAutoCommit(original_autocommit);
                        }
                        catch (SQLException sr) {}
                    }
                }
                statement = jdbcConnection.prepareStatement(sql);
                statement.setString(1, principalName);
                statement.setString(2, DateUtil.getCurrentDateAsString());
                statement.setLong(3, checksum);
                platform.setClob((PreparedStatement)statement, data, 4);
                statement.setString(5, sourceName);
                int r = statement.executeUpdate();
                if (r != 1) {
                    if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        throw new ExtensionModuleNotFoundException(CommonPlugin.Util.getString("ERR.014.004.0059", new Object[]{sourceName}));
                    }
                    throw new MetaMatrixComponentException("ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", new Object[]{sql}));
                }
            }
            catch (SQLException se) {
                if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                    throw new ExtensionModuleNotFoundException(sourceName);
                }
                throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", new Object[]{sql}));
            }
            catch (IOException e) {
                throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", new Object[]{sql}));
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e) {
                        LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0048"));
                    }
                }
            }
        }
    }

    private static void updateFile(String principalName, String sourceName, byte[] data, long checksum, Connection jdbcConnection, String sql) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        block35: {
            LogManager.logTrace((String)CONTEXT, (Object[])new Object[]{"setting extension module file " + sourceName + " containing # bytes: " + data.length});
            JDBCPlatform platform = JDBCExtensionModuleWriter.getPlatform(jdbcConnection);
            Statement statement = null;
            ResultSet results = null;
            boolean original_autocommit = true;
            try {
                original_autocommit = jdbcConnection.getAutoCommit();
                if (platform.usesStreamsForClobBinding()) {
                    jdbcConnection.setAutoCommit(false);
                    statement = jdbcConnection.prepareStatement(sql);
                    statement.setString(1, principalName);
                    statement.setString(2, DateUtil.getCurrentDateAsString());
                    statement.setLong(3, checksum);
                    statement.setString(4, sourceName);
                    if (statement.executeUpdate() != 1) {
                        if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                            throw new ExtensionModuleNotFoundException(CommonPlugin.Util.getString("ERR.014.004.0059", new Object[]{sourceName}));
                        }
                        throw new MetaMatrixComponentException("ERR.014.004.0060", CommonPlugin.Util.getString("ERR.014.004.0060", new Object[]{sourceName, sql}));
                    }
                    LogManager.logTrace((String)CONTEXT, (Object[])new Object[]{"SUCCESS-reset Blob: " + sql});
                    statement.close();
                    sql = "SELECT FILE_CONTENTS FROM CS_EXT_FILES WHERE FILE_NAME= ? ";
                    sql = sql + " FOR UPDATE";
                    statement = jdbcConnection.prepareStatement(sql);
                    statement.setString(1, sourceName);
                    if (!statement.execute()) {
                        throw new MetaMatrixComponentException("ERR.014.004.0062", CommonPlugin.Util.getString("ERR.014.004.0062", new Object[]{sourceName, sql}));
                    }
                    try {
                        results = statement.getResultSet();
                        if (results.next()) {
                            platform.setBlob(results, data, "FILE_CONTENTS");
                            jdbcConnection.commit();
                            break block35;
                        }
                        throw new MetaMatrixComponentException("ERR.014.004.0064", CommonPlugin.Util.getString("ERR.014.004.0064", new Object[]{sourceName}));
                    }
                    catch (SQLException se) {
                        try {
                            jdbcConnection.rollback();
                        }
                        catch (SQLException sr) {
                            // empty catch block
                        }
                        throw se;
                    }
                    finally {
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (SQLException e) {
                                LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0073"));
                            }
                        }
                        try {
                            jdbcConnection.setAutoCommit(original_autocommit);
                        }
                        catch (SQLException sr) {}
                    }
                }
                sql = "UPDATE CS_EXT_FILES  SET UPDATED_BY= ?, UPDATE_DATE= ?, CHKSUM= ?, FILE_CONTENTS= ?  WHERE FILE_NAME= ? ";
                statement = jdbcConnection.prepareStatement(sql);
                statement.setString(1, principalName);
                statement.setString(2, DateUtil.getCurrentDateAsString());
                statement.setLong(3, checksum);
                platform.setBlob((PreparedStatement)statement, data, 4);
                statement.setString(5, sourceName);
                if (statement.executeUpdate() != 1) {
                    if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                        throw new ExtensionModuleNotFoundException(CommonPlugin.Util.getString("ERR.014.004.0059", new Object[]{sourceName}));
                    }
                    throw new MetaMatrixComponentException("ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", new Object[]{sql}));
                }
            }
            catch (SQLException se) {
                if (!JDBCExtensionModuleReader.isNameInUse(sourceName, jdbcConnection)) {
                    throw new ExtensionModuleNotFoundException(sourceName);
                }
                throw new MetaMatrixComponentException((Throwable)se, "ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", new Object[]{sql}));
            }
            catch (IOException e) {
                throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0065", CommonPlugin.Util.getString("ERR.014.004.0065", new Object[]{sql}));
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e) {
                        LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0048"));
                    }
                }
                JDBCExtensionModuleWriter.close(results);
            }
        }
    }

    public static ExtensionModuleDescriptor setSourceName(String principalName, String sourceName, String newName, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        try {
            String sql = "UPDATE CS_EXT_FILES  SET FILE_NAME= ?, UPDATED_BY= ?, UPDATE_DATE= ?  WHERE FILE_NAME= ? ";
            JDBCExtensionModuleWriter.updateModule(sourceName, newName, sql, principalName, jdbcConnection);
            return JDBCExtensionModuleReader.getSourceDescriptor(sourceName, jdbcConnection);
        }
        catch (SQLException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public static ExtensionModuleDescriptor setSourceDescription(String principalName, String sourceName, String description, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        try {
            String sql = "UPDATE CS_EXT_FILES  SET FILE_DESC= ?, UPDATED_BY= ?, UPDATE_DATE= ?  WHERE FILE_NAME= ? ";
            JDBCExtensionModuleWriter.updateModule(sourceName, description, sql, principalName, jdbcConnection);
            return JDBCExtensionModuleReader.getSourceDescriptor(sourceName, jdbcConnection);
        }
        catch (SQLException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public static void setSearchOrder(String principalName, List sourceNames, Connection jdbcConnection) throws ExtensionModuleOrderingException, MetaMatrixComponentException {
        int rowCount = JDBCExtensionModuleReader.getExtensionModuleCount(jdbcConnection);
        if (sourceNames.size() != rowCount) {
            throw new ExtensionModuleOrderingException("ERR.014.004.0066", CommonPlugin.Util.getString("ERR.014.004.0066", sourceNames));
        }
        String aSourceName = null;
        Integer aPosition = null;
        String currentDate = DateUtil.getCurrentDateAsString();
        String sql = "UPDATE CS_EXT_FILES  SET SEARCH_POS= ?, UPDATED_BY= ?, UPDATE_DATE= ?  WHERE FILE_NAME= ? ";
        PreparedStatement statement = null;
        try {
            statement = jdbcConnection.prepareStatement(sql);
            ListIterator iter = sourceNames.listIterator();
            while (iter.hasNext()) {
                aPosition = new Integer(iter.nextIndex());
                aSourceName = (String)iter.next();
                statement.setInt(1, aPosition);
                statement.setString(2, principalName);
                statement.setString(3, currentDate);
                statement.setString(4, aSourceName);
                statement.execute();
                statement.clearParameters();
            }
        }
        catch (SQLException e) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public static void setEnabled(String principalName, Collection sourceNames, boolean enabled, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        String aSourceName2 = null;
        String currentDate = DateUtil.getCurrentDateAsString();
        String sql = "UPDATE CS_EXT_FILES  SET SEARCH_POS= ?, UPDATED_BY= ?, UPDATE_DATE= ?  WHERE FILE_NAME= ? ";
        PreparedStatement statement = null;
        try {
            statement = jdbcConnection.prepareStatement(sql);
            for (String aSourceName2 : sourceNames) {
                statement.setString(1, enabled ? IS_TRUE : IS_FALSE);
                statement.setString(2, principalName);
                statement.setString(3, currentDate);
                statement.setString(4, aSourceName2);
                statement.execute();
                statement.clearParameters();
            }
        }
        catch (SQLException e) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateModule(String filenname, String value, String sql, String callerPrincipalName, Connection jdbcConnection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, value);
            statement.setString(2, callerPrincipalName);
            statement.setString(3, DateUtil.getCurrentDateAsString());
            statement.setString(4, filenname);
            statement.execute();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException e) {
                    LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0048"));
                }
            }
        }
    }

    private static JDBCPlatform getPlatform(Connection jdbcConnection) throws MetaMatrixComponentException {
        try {
            return JDBCPlatformFactory.getPlatform(jdbcConnection);
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.014.004.0067", CommonPlugin.Util.getString("ERR.014.004.0067"));
        }
    }

    public static void removeSource(String principalName, String sourceName, Connection jdbcConnection) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        PreparedStatement statement = null;
        try {
            statement = jdbcConnection.prepareStatement("DELETE  FROM CS_EXT_FILES WHERE FILE_NAME=?");
            statement.setString(1, sourceName);
            statement.execute();
        }
        catch (SQLException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException e) {
                    LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0048"));
                }
            }
        }
    }

    static int getNextPosition(Connection jdbcConnection) throws MetaMatrixComponentException {
        int nextPos = JDBCExtensionModuleReader.executeIntFunctionSQL("SELECT  MAX(SEARCH_POS) FROM CS_EXT_FILES", jdbcConnection);
        return ++nextPos;
    }

    private static void close(ResultSet resultset) {
        if (resultset != null) {
            try {
                resultset.close();
                resultset = null;
            }
            catch (SQLException e) {
                LogManager.logWarning((String)CONTEXT, (Throwable)e, (String)CommonPlugin.Util.getString("ERR.014.004.0048"));
            }
        }
    }
}

