/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.id.dbid;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.id.dbid.DBIDController;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.common.id.dbid.spi.InMemoryIDController;
import com.metamatrix.common.id.dbid.spi.jdbc.PersistentIDController;
import com.metamatrix.core.MetaMatrixRuntimeException;

public class DBIDGenerator {
    public static final String VM_ID = "VM";
    public static final String SERVICE_ID = "Service";
    private static DBIDGenerator generator = new DBIDGenerator();
    private DBIDController controller;

    private DBIDGenerator() {
        this.setUseMemoryIDGeneration(false);
    }

    public long getID(String context, boolean enableRollOver) throws DBIDGeneratorException {
        try {
            return this.getUniqueID(context, enableRollOver);
        }
        catch (Exception e) {
            throw new DBIDGeneratorException(e, "Error creating id for " + context + " context.");
        }
    }

    public long getID(String context) throws DBIDGeneratorException {
        try {
            return this.getUniqueID(context, true);
        }
        catch (Exception e) {
            throw new DBIDGeneratorException(e, "ERR.003.013.0011", CommonPlugin.Util.getString("ERR.003.013.0011", new Object[]{context}));
        }
    }

    public void setCacheBlockSize(String context, long cache) throws DBIDGeneratorException {
        try {
            this.setContextBlockSize(context, cache);
        }
        catch (Exception e) {
            throw new DBIDGeneratorException(e, "ERR.003.013.0012", CommonPlugin.Util.getString("ERR.003.013.0012", new Object[]{context}));
        }
    }

    public void setUseMemoryIDGeneration() {
        this.controller = new InMemoryIDController();
    }

    public void setUseMemoryIDGeneration(boolean useInMemory) {
        if (useInMemory) {
            this.controller = new InMemoryIDController();
        } else {
            try {
                this.controller = new PersistentIDController();
            }
            catch (ManagedConnectionException e) {
                throw new MetaMatrixRuntimeException((Throwable)((Object)e));
            }
        }
    }

    public void shutDown() {
        if (this.controller != null) {
            this.controller.shutDown();
        }
    }

    public static DBIDGenerator getInstance() {
        return generator;
    }

    private synchronized long getUniqueID(String context, boolean enableRollOver) throws DBIDGeneratorException {
        return this.controller.getUniqueID(context, enableRollOver);
    }

    private void setContextBlockSize(String context, long size) {
        this.controller.setContextBlockSize(context, size);
    }
}

