/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.id.dbid.spi;

import com.metamatrix.common.id.dbid.DBIDController;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.common.id.dbid.ReservedIDBlock;
import java.util.HashMap;
import java.util.Map;

public class InMemoryIDController
implements DBIDController {
    private Map lastIDs = new HashMap();
    private static final long DEFAULT_ID_BLOCK_SIZE = 1000L;
    private static Map idBlockMap = new HashMap();
    private static Map blockSizeMap = new HashMap();

    public ReservedIDBlock createIDBlock(long blockSize, String context) throws DBIDGeneratorException {
        ReservedIDBlock block;
        Object obj = this.lastIDs.get(context);
        if (obj == null) {
            block = new ReservedIDBlock(context, 1L, blockSize, Long.MAX_VALUE);
        } else {
            ReservedIDBlock lastblock = (ReservedIDBlock)obj;
            long start = lastblock.getLast() + 1L;
            block = new ReservedIDBlock(context, start, start + blockSize, Long.MAX_VALUE);
        }
        this.lastIDs.put(context, block);
        return block;
    }

    @Override
    public long getUniqueID(String context, boolean enableRollOver) throws DBIDGeneratorException {
        return this.getUniqueID(context);
    }

    @Override
    public long getUniqueID(String context) throws DBIDGeneratorException {
        ReservedIDBlock idBlock = (ReservedIDBlock)idBlockMap.get(context);
        if (idBlock == null || idBlock.isDepleted()) {
            Long bs = (Long)blockSizeMap.get(context);
            long bSize = 1000L;
            if (bs != null) {
                bSize = bs;
            }
            idBlock = this.createIDBlock(bSize, context);
            idBlockMap.put(context, idBlock);
        }
        return idBlock.getNextID();
    }

    @Override
    public void setContextBlockSize(String context, long size) {
        blockSizeMap.put(context, new Long(size));
    }

    @Override
    public void shutDown() {
    }
}

