/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.id.dbid.spi.jdbc;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.connection.BaseTransaction;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.jdbc.JDBCMgdResourceConnection;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.common.id.dbid.ReservedIDBlock;
import com.metamatrix.common.id.dbid.spi.DBIDSourceTransaction;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.common.log.LogManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBIDResourceTransaction
extends BaseTransaction
implements DBIDSourceTransaction {
    private Connection jdbcConnection;
    private JDBCPlatform platform = null;
    private static long columnMax = 999999999L;
    private static final String NINE = "9";
    private static final int INSERT_RETRIES = 5;

    public DBIDResourceTransaction(ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
        super(connection, readonly);
        try {
            JDBCMgdResourceConnection jdbcManagedConnection = (JDBCMgdResourceConnection)connection;
            this.jdbcConnection = jdbcManagedConnection.getConnection();
            this.platform = JDBCPlatformFactory.getPlatform(this.jdbcConnection);
        }
        catch (Exception e) {
            throw new ManagedConnectionException(e, "ERR.003.013.0016", CommonPlugin.Util.getString("ERR.003.013.0016"));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReservedIDBlock createIDBlock(long blockSize, String context, boolean wrapNumber) throws Exception {
        Statement updateStatement;
        Statement insertStatement;
        long endValue;
        long startValue;
        block43: {
            long idValue = -1L;
            startValue = -1L;
            endValue = -1L;
            long lastValue = -1L;
            String sqlSelect = "SELECT NEXTID FROM IDTABLE WHERE IDCONTEXT= ?";
            String sqlUpdate = "UPDATE IDTABLE SET NEXTID= ? WHERE IDCONTEXT= ? AND NEXTID= ?";
            String sqlInsert = "INSERT  INTO IDTABLE (IDCONTEXT, NEXTID) VALUES ( ?, ? )";
            Statement selectStatement = null;
            insertStatement = null;
            updateStatement = null;
            int retries = 0;
            try {
                if (columnMax == -1L) {
                    this.determineColumnMax();
                }
                boolean updateFailed = true;
                while (updateFailed) {
                    try {
                        if (selectStatement != null) {
                            selectStatement.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (insertStatement != null) {
                            insertStatement.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (updateStatement != null) {
                            updateStatement.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    selectStatement = this.jdbcConnection.prepareStatement(sqlSelect);
                    selectStatement.setString(1, context);
                    ResultSet results = selectStatement.executeQuery();
                    if (results.next()) {
                        startValue = results.getLong(1);
                    } else {
                        LogManager.logInfo((String)"DBIDGEN", (String)CommonPlugin.Util.getString("MSG.003.013.0002", new Object[]{context, String.valueOf(1000L)}));
                        startValue = 1000L;
                        try {
                            insertStatement = this.jdbcConnection.prepareStatement(sqlInsert);
                            insertStatement.setString(1, context);
                            insertStatement.setLong(2, startValue);
                            int nr = insertStatement.executeUpdate();
                            if (nr != 1) {
                                String msg = CommonPlugin.Util.getString("ERR.003.013.0017", new Object[]{context, "IDTABLE"});
                                LogManager.logCritical((String)"DBIDGEN", (String)msg);
                                throw new DBIDGeneratorException(msg);
                            }
                        }
                        catch (SQLException sqle) {
                            if (++retries < 5) continue;
                            String msg = CommonPlugin.Util.getString("ERR.003.013.0018", new Object[]{context, "IDTABLE"});
                            LogManager.logCritical((String)"DBIDGEN", (String)msg);
                            throw new DBIDGeneratorException(sqle, msg);
                        }
                    }
                    lastValue = startValue;
                    if (wrapNumber) {
                        startValue = 1000L;
                        idValue = 1000L + blockSize;
                        endValue = idValue - 1L;
                    } else if (startValue + blockSize > columnMax) {
                        endValue = idValue = columnMax;
                    } else {
                        idValue = startValue + blockSize;
                        endValue = idValue - 1L;
                    }
                    updateStatement = this.jdbcConnection.prepareStatement(sqlUpdate);
                    updateStatement.setLong(1, idValue);
                    updateStatement.setString(2, context);
                    updateStatement.setLong(3, lastValue);
                    int nrows = updateStatement.executeUpdate();
                    if (nrows == 1) {
                        updateFailed = false;
                        break;
                    }
                    if (nrows != 0) {
                        String msg = CommonPlugin.Util.getString("ERR.003.013.0019", new Object[]{context, "IDTABLE"});
                        LogManager.logCritical((String)"DBIDGEN", (String)msg);
                        throw new DBIDGeneratorException(msg);
                    }
                    LogManager.logWarning((String)"DBIDGEN", (String)CommonPlugin.Util.getString("ERR.003.013.0020", new Object[]{context}));
                }
                if (selectStatement == null) break block43;
            }
            catch (DBIDGeneratorException dbe) {
                try {
                    throw dbe;
                    catch (SQLException se) {
                        LogManager.logCritical((String)"DBIDGEN", (String)CommonPlugin.Util.getString("ERR.003.013.0021", new Object[]{context}));
                        throw new DBIDGeneratorException(se, CommonPlugin.Util.getString("ERR.003.013.0021", new Object[]{context}));
                    }
                    catch (Exception e) {
                        LogManager.logCritical((String)"DBIDGEN", (String)CommonPlugin.Util.getString("ERR.003.013.0022", new Object[]{context}));
                        throw new DBIDGeneratorException(e, "ERR.003.013.0022", CommonPlugin.Util.getString("ERR.003.013.0022", new Object[]{context}));
                    }
                }
                catch (Throwable throwable) {
                    if (selectStatement != null) {
                        try {
                            selectStatement.close();
                        }
                        catch (SQLException e2) {
                            LogManager.logWarning((String)"DBIDGEN", (Throwable)e2, (String)CommonPlugin.Util.getString("ERR.003.013.0023", new Object[]{context}));
                        }
                    }
                    if (insertStatement != null) {
                        try {
                            insertStatement.close();
                        }
                        catch (SQLException e2) {
                            LogManager.logWarning((String)"DBIDGEN", (Throwable)e2, (String)CommonPlugin.Util.getString("ERR.003.013.0023", new Object[]{context}));
                        }
                    }
                    if (updateStatement == null) throw throwable;
                    try {
                        updateStatement.close();
                        throw throwable;
                    }
                    catch (SQLException e2) {
                        LogManager.logWarning((String)"DBIDGEN", (Throwable)e2, (String)CommonPlugin.Util.getString("ERR.003.013.0023", new Object[]{context}));
                    }
                    throw throwable;
                }
            }
            try {
                selectStatement.close();
            }
            catch (SQLException e2) {
                LogManager.logWarning((String)"DBIDGEN", (Throwable)e2, (String)CommonPlugin.Util.getString("ERR.003.013.0023", new Object[]{context}));
            }
        }
        if (insertStatement != null) {
            try {
                insertStatement.close();
            }
            catch (SQLException e2) {
                LogManager.logWarning((String)"DBIDGEN", (Throwable)e2, (String)CommonPlugin.Util.getString("ERR.003.013.0023", new Object[]{context}));
            }
        }
        if (updateStatement == null) return new ReservedIDBlock(context, startValue, endValue, columnMax);
        try {
            updateStatement.close();
            return new ReservedIDBlock(context, startValue, endValue, columnMax);
        }
        catch (SQLException e2) {
            LogManager.logWarning((String)"DBIDGEN", (Throwable)e2, (String)CommonPlugin.Util.getString("ERR.003.013.0023", new Object[]{context}));
        }
        return new ReservedIDBlock(context, startValue, endValue, columnMax);
    }

    private void determineColumnMax() throws DBIDGeneratorException, SQLException {
        if (columnMax > -1L) {
            return;
        }
        int s = this.platform.getDatabaseColumnSize("IDTABLE", "NEXTID", this.jdbcConnection);
        if (s <= 0) {
            LogManager.logCritical((String)"DBIDGEN", (String)CommonPlugin.Util.getString("ERR.003.013.0024", new Object[]{"IDTABLE", "NEXTID"}));
            throw new DBIDGeneratorException("ERR.003.013.0024", CommonPlugin.Util.getString("ERR.003.013.0021", new Object[]{"IDTABLE", "NEXTID"}));
        }
        if (s > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < s; ++i) {
                sb.append(NINE);
            }
            columnMax = Long.parseLong(sb.toString());
            return;
        }
        columnMax = -1L;
    }
}

