/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.id.dbid.spi.jdbc;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.TransactionMgr;
import com.metamatrix.common.id.dbid.DBIDController;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.common.id.dbid.ReservedIDBlock;
import com.metamatrix.common.id.dbid.spi.jdbc.DBIDResourceTransaction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PersistentIDController
implements DBIDController {
    private static TransactionMgr transMgr;
    private static Map idBlockMap;
    private static Map blockSizeMap;
    public static final String VM_ID = "VM";
    public static final String SERVICE_ID = "Service";
    private static final long VM_ID_BLOCK_SIZE = 1L;
    private static final long SERVICE_ID_BLOCK_SIZE = 10L;
    private static final long DEFAULT_ID_BLOCK_SIZE = 100L;
    private static final String FACTORY = "com.metamatrix.common.id.dbid.spi.jdbc.DBIDResourceTransactionFactory";
    private static final String PRINCIPAL = "DBID_GENERATOR";

    public PersistentIDController() throws ManagedConnectionException {
        Properties props = new Properties();
        props.setProperty("metamatrix.common.connection.transaction.factory", FACTORY);
        transMgr = new TransactionMgr(props, PRINCIPAL);
        blockSizeMap.put(VM_ID, new Long(1L));
        blockSizeMap.put(SERVICE_ID, new Long(10L));
    }

    private ReservedIDBlock createIDBlock(long blockSize, String context, boolean wrap) throws DBIDGeneratorException {
        ReservedIDBlock block = null;
        DBIDResourceTransaction transaction = null;
        try {
            transaction = (DBIDResourceTransaction)transMgr.getWriteTransaction();
            block = transaction.createIDBlock(blockSize, context, wrap);
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (Exception sqle) {
                // empty catch block
            }
            throw new DBIDGeneratorException(e, "ERR.003.013.0014", CommonPlugin.Util.getString("ERR.003.013.0014", new Object[]{String.valueOf(blockSize), context}));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        return block;
    }

    @Override
    public void setContextBlockSize(String context, long size) {
        blockSizeMap.put(context, new Long(size));
    }

    @Override
    public long getUniqueID(String context) throws DBIDGeneratorException {
        return this.getUniqueID(context, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getUniqueID(String context, boolean enableRollOver) throws DBIDGeneratorException {
        ReservedIDBlock idBlock = (ReservedIDBlock)idBlockMap.get(context);
        if (idBlock == null) {
            long bSize = this.getBlockSize(context);
            idBlock = this.createIDBlock(bSize, context, false);
            idBlock.setIsWrappable(enableRollOver);
            idBlockMap.put(context, idBlock);
            return idBlock.getNextID();
        } else {
            if (!idBlock.isDepleted()) return idBlock.getNextID();
            long bSize = this.getBlockSize(context);
            if (idBlock.isAtMaximum()) {
                if (!idBlock.isWrappable()) throw new DBIDGeneratorException("ERR.003.013.0015", CommonPlugin.Util.getString("ERR.003.013.0015", new Object[]{context, String.valueOf(idBlock.getMax())}));
                idBlock = this.createIDBlock(bSize, context, true);
            } else {
                idBlock = this.createIDBlock(bSize, context, false);
            }
            idBlock.setIsWrappable(enableRollOver);
            idBlockMap.put(context, idBlock);
        }
        return idBlock.getNextID();
    }

    private long getBlockSize(String context) {
        Long bs = (Long)blockSizeMap.get(context);
        long bSize = 100L;
        if (bs != null) {
            bSize = bs;
        }
        return bSize;
    }

    @Override
    public void shutDown() {
    }

    static {
        idBlockMap = new HashMap();
        blockSizeMap = new HashMap();
    }
}

