/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCURL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Map;

public class JDBCPlatformFactory {
    private static final String DEFAULT_PLATFORM = "default";
    private static Map classMap;
    private static Map platformCache;

    public static JDBCPlatform getPlatform(Connection jdbcConnection) throws MetaMatrixException {
        try {
            DatabaseMetaData metadata = jdbcConnection.getMetaData();
            String productName = metadata.getDatabaseProductName();
            String driverName = metadata.getDriverName();
            JDBCPlatform p = JDBCPlatformFactory.getPlatform(metadata.getURL(), driverName, productName);
            if (p != null) {
                p.setConnection(jdbcConnection);
            }
            return p;
        }
        catch (Exception sqle) {
            throw new MetaMatrixException((Throwable)sqle, "ERR.003.015.0003", CommonPlugin.Util.getString("ERR.003.015.0003"));
        }
    }

    public static JDBCPlatform getPlatform(String url, String driverName) throws MetaMatrixException {
        String productName = JDBCPlatformFactory.getSupportedByProtocol(url);
        if (productName == null) {
            return null;
        }
        return JDBCPlatformFactory.getPlatform(url, driverName, productName);
    }

    static JDBCPlatform getPlatform(String url, String driverName, String productName) throws MetaMatrixException {
        try {
            boolean isSecure = false;
            JDBCURL jdbcurl = new JDBCURL(url);
            String dbplatform = JDBCPlatformFactory.getSupportedByProductName(productName);
            String supported = JDBCPlatformFactory.getSupportedByProtocol(jdbcurl.getProtocol());
            if (supported == null) {
                supported = dbplatform;
            }
            if (supported == null) {
                supported = DEFAULT_PLATFORM;
            }
            String platformClass = JDBCPlatformFactory.getPlatformClass(supported);
            String key = driverName + " - " + jdbcurl.getProtocol();
            JDBCPlatform p = JDBCPlatformFactory.createPlatform(dbplatform, platformClass, key, isSecure);
            return p;
        }
        catch (Exception sqle) {
            throw new MetaMatrixException((Throwable)sqle, "ERR.003.015.0003", CommonPlugin.Util.getString("ERR.003.015.0003"));
        }
    }

    private static JDBCPlatform createPlatform(String productName, String platformClass, String key, boolean isSecure) throws MetaMatrixException {
        try {
            JDBCPlatform p = JDBCPlatformFactory.getAvailablePlatform(platformClass, key);
            if (p != null) {
                return p;
            }
            Object o = Class.forName(platformClass).newInstance();
            if (!(o instanceof JDBCPlatform)) {
                throw new MetaMatrixException("ERR.003.015.0005", CommonPlugin.Util.getString("ERR.003.015.0005"));
            }
            p = (JDBCPlatform)o;
            if (isSecure) {
                p.setIsSecure(isSecure);
            }
            p.setPlatformName(productName);
            p.initializePlatform();
            JDBCPlatformFactory.addAvailablePlatform(platformClass, key, p);
            return p;
        }
        catch (Exception cnfe) {
            throw new MetaMatrixException((Throwable)cnfe, "ERR.003.015.0003", CommonPlugin.Util.getString("ERR.003.015.0003"));
        }
    }

    private static JDBCPlatform getAvailablePlatform(String platform, String key) {
        JDBCPlatform p = null;
        HashMap platformInstances = null;
        if (platformCache.containsKey(platform)) {
            platformInstances = (HashMap)platformCache.get(platform);
            if (platformInstances.containsKey(key)) {
                p = (JDBCPlatform)platformInstances.get(key);
            }
        } else {
            platformInstances = new HashMap(10);
            platformCache.put(platform, platformInstances);
        }
        return p;
    }

    private static void addAvailablePlatform(String platform, String key, JDBCPlatform jdbc) {
        Map platformInstances = (Map)platformCache.get(platform);
        platformInstances.put(key, jdbc);
    }

    static String getSupportedByProtocol(String value) {
        String lower = value.toLowerCase();
        if (lower.indexOf("metamatrix") >= 0) {
            return "metamatrix";
        }
        if (lower.indexOf("mmx:oracle") >= 0) {
            return "mmx:oracle";
        }
        if (lower.indexOf("mssql") >= 0 || lower.indexOf("sqlserver") >= 0) {
            return "microsoft";
        }
        if (lower.indexOf("db2") >= 0) {
            return "db2";
        }
        if (lower.indexOf("oracle") >= 0) {
            return "oracle";
        }
        if (lower.indexOf("sybase") >= 0) {
            return "sybase";
        }
        if (lower.indexOf("informix-sqli") >= 0) {
            return "informix";
        }
        if (lower.indexOf("derby") >= 0) {
            return "derby";
        }
        if (lower.indexOf("mysql") >= 0) {
            return "mysql";
        }
        if (lower.indexOf("postgres") >= 0) {
            return "postgres";
        }
        return null;
    }

    static String getSupportedByProductName(String value) {
        String lower = value.toLowerCase();
        if (lower.indexOf("microsoft") >= 0) {
            return "microsoft";
        }
        if (lower.indexOf("db2") >= 0) {
            return "db2";
        }
        if (lower.indexOf("oracle") >= 0) {
            return "oracle";
        }
        if (lower.indexOf("sybase") >= 0) {
            return "sybase";
        }
        if (lower.indexOf("informix") >= 0) {
            return "informix";
        }
        if (lower.indexOf("metamatrix") >= 0) {
            return "metamatrix";
        }
        if (lower.indexOf("derby") >= 0) {
            return "derby";
        }
        if (lower.indexOf("postgres") >= 0) {
            return "postgres";
        }
        if (lower.indexOf("mysql") >= 0) {
            return "mysql";
        }
        return DEFAULT_PLATFORM;
    }

    static String getPlatformClass(String supported) {
        String platformClass = (String)classMap.get(supported);
        if (platformClass == null) {
            platformClass = (String)classMap.get(DEFAULT_PLATFORM);
        }
        return platformClass;
    }

    static {
        platformCache = new HashMap(10);
        classMap = new HashMap(10);
        classMap.put("db2", "com.metamatrix.common.jdbc.db.DB2Platform");
        classMap.put("microsoft", "com.metamatrix.common.jdbc.db.MSSQLPlatform");
        classMap.put("oracle", "com.metamatrix.common.jdbc.db.OraclePlatform");
        classMap.put("sybase", "com.metamatrix.common.jdbc.db.SybasePlatform");
        classMap.put("informix", "com.metamatrix.common.jdbc.db.InformixPlatform");
        classMap.put("metamatrix", "com.metamatrix.common.jdbc.db.MetaMatrixPlatform");
        classMap.put("mmx:oracle", "com.metamatrix.common.jdbc.db.MMOraclePlatform");
        classMap.put("mysql", "com.metamatrix.common.jdbc.db.MySQLPlatform");
        classMap.put("postgres", "com.metamatrix.common.jdbc.db.PostgresPlatform");
        classMap.put(DEFAULT_PLATFORM, "com.metamatrix.common.jdbc.JDBCPlatform");
        classMap.put("derby", "com.metamatrix.common.jdbc.db.DerbyPlatform");
    }

    protected static interface PlatformClass {
        public static final String MSSQL = "com.metamatrix.common.jdbc.db.MSSQLPlatform";
        public static final String DB2 = "com.metamatrix.common.jdbc.db.DB2Platform";
        public static final String ORACLE = "com.metamatrix.common.jdbc.db.OraclePlatform";
        public static final String SYBASE = "com.metamatrix.common.jdbc.db.SybasePlatform";
        public static final String INFORMIX = "com.metamatrix.common.jdbc.db.InformixPlatform";
        public static final String METAMATRIX = "com.metamatrix.common.jdbc.db.MetaMatrixPlatform";
        public static final String DEFAULT = "com.metamatrix.common.jdbc.JDBCPlatform";
        public static final String MMORACLE = "com.metamatrix.common.jdbc.db.MMOraclePlatform";
        public static final String DERBY = "com.metamatrix.common.jdbc.db.DerbyPlatform";
        public static final String MYSQL = "com.metamatrix.common.jdbc.db.MySQLPlatform";
        public static final String POSTGRES = "com.metamatrix.common.jdbc.db.PostgresPlatform";
    }

    protected static interface Protocol {
        public static final String MSSQL = "mssql";
        public static final String SQLSERVER = "sqlserver";
        public static final String ORACLE = "oracle";
        public static final String DB2 = "db2";
        public static final String SYBASE = "sybase";
        public static final String INFORMIX = "informix-sqli";
        public static final String METAMATRIX = "metamatrix";
        public static final String MM_ORACLE = "mmx:oracle";
        public static final String DERBY = "derby";
        public static final String MYSQL = "mysql";
        public static final String POSTGRES = "postgres";
    }

    public static interface Supported {
        public static final String ORACLE = "oracle";
        public static final String SYBASE = "sybase";
        public static final String DB2 = "db2";
        public static final String MSSQL = "microsoft";
        public static final String INFORMIX = "informix";
        public static final String METAMATRIX = "metamatrix";
        public static final String MM_ORACLE = "mmx:oracle";
        public static final String MYSQL = "mysql";
        public static final String POSTGRES = "postgres";
        public static final String DEFAULT = "default";
        public static final String DERBY = "derby";
    }
}

