/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.db;

import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.syntax.ExpressionOperator;
import com.metamatrix.common.jdbc.syntax.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class DB2Platform
extends JDBCPlatform {
    @Override
    public boolean isDB2() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed(Connection connection) {
        if (!super.isClosed(connection)) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                statement.executeQuery("Select 'x' from sysibm.systables where 1 = 2");
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                boolean bl = true;
                return bl;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return true;
    }

    @Override
    protected Map buildFieldTypes() {
        HashMap<Class, FieldType> fieldTypeMapping = new HashMap<Class, FieldType>();
        fieldTypeMapping.put(Boolean.class, new FieldType("SMALLINT DEFAULT 0", false));
        fieldTypeMapping.put(Integer.class, new FieldType("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldType("INTEGER", false));
        fieldTypeMapping.put(Float.class, new FieldType("FLOAT", false));
        fieldTypeMapping.put(Double.class, new FieldType("FLOAT", false));
        fieldTypeMapping.put(Short.class, new FieldType("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldType("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldType("DECIMAL", 15));
        fieldTypeMapping.put(BigDecimal.class, new FieldType("DECIMAL", 15).setLimits(15, 0, 15));
        fieldTypeMapping.put(String.class, new FieldType("VARCHAR", 20));
        fieldTypeMapping.put(Character.class, new FieldType("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldType("BLOB", 64000));
        fieldTypeMapping.put(Character[].class, new FieldType("CLOB", 64000));
        fieldTypeMapping.put(Date.class, new FieldType("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldType("TIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldType("TIMESTAMP", false));
        return fieldTypeMapping;
    }

    @Override
    protected Map buildPlatformOperators() {
        Map operators = super.buildPlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction("toUpperCase", "UCASE"));
        return operators;
    }

    @Override
    public Map maximumNumericValues() {
        HashMap<Class, Number> values = new HashMap<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MAX_VALUE));
        values.put(Long.class, new Long(Integer.MAX_VALUE));
        values.put(Float.class, new Float(Float.MAX_VALUE));
        values.put(Double.class, new Double(3.4028234663852886E38));
        values.put(Short.class, new Short(Short.MAX_VALUE));
        values.put(Byte.class, new Byte(127));
        values.put(BigInteger.class, new BigInteger("999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("0.999999999999999"));
        return values;
    }

    @Override
    public Map minimumNumericValues() {
        HashMap<Class, Number> values = new HashMap<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MIN_VALUE));
        values.put(Long.class, new Long(Integer.MIN_VALUE));
        values.put(Float.class, new Float(Float.MIN_VALUE));
        values.put(Double.class, new Double(1.4E-45f));
        values.put(Short.class, new Short(Short.MIN_VALUE));
        values.put(Byte.class, new Byte(-128));
        values.put(BigInteger.class, new BigInteger("-999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("-0.999999999999999"));
        return values;
    }
}

