/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.db;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.jdbc.db.OraclePlatform;
import com.metamatrix.common.types.TransformationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MMOracleSecurePlatform
extends OraclePlatform {
    public MMOracleSecurePlatform() {
        this.usesStreamsForBlobBinding = false;
        this.usesStreamsForClobBinding = false;
    }

    @Override
    public byte[] convertClobToByteArray(ResultSet results, String columnName) throws TransformationException {
        try {
            String sdata = results.getString(columnName);
            if (sdata == null) {
                return null;
            }
            char[] cdata = sdata.toCharArray();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int l = cdata.length;
            for (int i = 0; i < l; ++i) {
                byte[] b = new byte[]{(byte)(cdata[i] & 0xFF)};
                output.write(b, 0, 1);
            }
            byte[] data = output.toByteArray();
            return data;
        }
        catch (SQLException sqe) {
            throw new TransformationException((Exception)sqe, "ERR.003.015.0002", CommonPlugin.Util.getString("ERR.003.015.0002", new Object[]{columnName}));
        }
    }

    @Override
    public void setBlob(PreparedStatement statement, byte[] data, int column) throws SQLException, IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        statement.setBinaryStream(column, (InputStream)bis, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(Object sqlObject, InputStream is, String columnName) throws SQLException, IOException {
        PreparedStatement statement = (PreparedStatement)sqlObject;
        byte[] buff = new byte[4096];
        int size = 0;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            while ((size = is.read(buff)) != -1) {
                output.write(buff, 0, size);
            }
        }
        finally {
            output.close();
        }
        byte[] data = output.toByteArray();
        statement.setBytes(4, data);
    }
}

