/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.db;

import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.syntax.ExpressionOperator;
import com.metamatrix.common.jdbc.syntax.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class MSSQLPlatform
extends JDBCPlatform {
    @Override
    public boolean isMSSQL() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public int getMaxFieldNameSize() {
        return 22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed(Connection connection) {
        if (!super.isClosed(connection)) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                statement.executeQuery("Select 'x'");
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                boolean bl = true;
                return bl;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return true;
    }

    @Override
    protected Map buildFieldTypes() {
        HashMap<Class, FieldType> fieldTypeMapping = new HashMap<Class, FieldType>();
        fieldTypeMapping.put(Boolean.class, new FieldType("BIT default 0", false));
        fieldTypeMapping.put(Integer.class, new FieldType("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldType("NUMERIC", 19));
        fieldTypeMapping.put(Float.class, new FieldType("FLOAT(16)", false));
        fieldTypeMapping.put(Double.class, new FieldType("FLOAT(32)", false));
        fieldTypeMapping.put(Short.class, new FieldType("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldType("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldType("NUMERIC", 28));
        fieldTypeMapping.put(BigDecimal.class, new FieldType("NUMERIC", 28).setLimits(28, -19, 19));
        fieldTypeMapping.put(String.class, new FieldType("VARCHAR", 20));
        fieldTypeMapping.put(Character.class, new FieldType("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldType("IMAGE", false));
        fieldTypeMapping.put(Character[].class, new FieldType("TEXT", false));
        fieldTypeMapping.put(Date.class, new FieldType("DATETIME", false));
        fieldTypeMapping.put(Time.class, new FieldType("DATETIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldType("DATETIME", false));
        return fieldTypeMapping;
    }

    @Override
    protected Map buildPlatformOperators() {
        Map operators = super.buildPlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction("toUpperCase", "UPPER"));
        return operators;
    }

    @Override
    public Map maximumNumericValues() {
        HashMap<Class, Number> values = new HashMap<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MAX_VALUE));
        values.put(Long.class, new Long(Long.MAX_VALUE));
        values.put(Double.class, new Double(0.0));
        values.put(Short.class, new Short(Short.MAX_VALUE));
        values.put(Byte.class, new Byte(127));
        values.put(Float.class, new Float(0.0f));
        values.put(BigInteger.class, new BigInteger("9999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("999999999.9999999999999999999"));
        return values;
    }

    @Override
    public Map minimumNumericValues() {
        HashMap<Class, Number> values = new HashMap<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MIN_VALUE));
        values.put(Long.class, new Long(Long.MIN_VALUE));
        values.put(Double.class, new Double(-9.0));
        values.put(Short.class, new Short(Short.MIN_VALUE));
        values.put(Byte.class, new Byte(-128));
        values.put(Float.class, new Float(-9.0f));
        values.put(BigInteger.class, new BigInteger("-9999999999999999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("-999999999.9999999999999999999"));
        return values;
    }
}

