/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.db;

import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.metadata.Column;
import com.metamatrix.common.jdbc.metadata.Table;
import com.metamatrix.common.jdbc.syntax.ExpressionOperator;
import com.metamatrix.common.jdbc.syntax.FieldType;
import com.metamatrix.core.util.ReflectionHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OraclePlatform
extends JDBCPlatform {
    private static final String EMPTY_BLOB = "empty_blob()";
    private static final String EMPTY_CLOB = "empty_clob()";

    public OraclePlatform() {
        this.usesStreamsForBlobBinding = true;
        this.usesStreamsForClobBinding = true;
    }

    @Override
    public boolean isOracle() {
        return true;
    }

    @Override
    public int getMaxFieldNameSize() {
        return 37;
    }

    @Override
    protected Map buildFieldTypes() {
        HashMap<Class, FieldType> fieldTypeMapping = new HashMap<Class, FieldType>();
        fieldTypeMapping.put(Boolean.class, new FieldType("NUMBER(1) default 0", false));
        fieldTypeMapping.put(Integer.class, new FieldType("NUMBER", 10));
        fieldTypeMapping.put(Long.class, new FieldType("NUMBER", 19));
        fieldTypeMapping.put(Float.class, new FieldType("NUMBER", false));
        fieldTypeMapping.put(Double.class, new FieldType("NUMBER", false));
        fieldTypeMapping.put(Short.class, new FieldType("NUMBER", 5));
        fieldTypeMapping.put(Byte.class, new FieldType("NUMBER", 3));
        fieldTypeMapping.put(BigInteger.class, new FieldType("NUMBER", 38));
        fieldTypeMapping.put(BigDecimal.class, new FieldType("NUMBER", 38).setLimits(38, -38, 38));
        fieldTypeMapping.put(String.class, new FieldType("VARCHAR2", 20));
        fieldTypeMapping.put(Character.class, new FieldType("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldType("LONG RAW"));
        fieldTypeMapping.put(Character[].class, new FieldType("LONG"));
        fieldTypeMapping.put(Date.class, new FieldType("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldType("DATE", false));
        fieldTypeMapping.put(Timestamp.class, new FieldType("DATE", false));
        return fieldTypeMapping;
    }

    @Override
    protected Map buildPlatformOperators() {
        Map operators = super.buildPlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction("toUpperCase", "UPPER"));
        return operators;
    }

    @Override
    public Map maximumNumericValues() {
        HashMap<Class, Number> values = new HashMap<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MAX_VALUE));
        values.put(Long.class, new Long(Long.MAX_VALUE));
        values.put(Double.class, new Double(9.9999E125));
        values.put(Short.class, new Short(Short.MAX_VALUE));
        values.put(Byte.class, new Byte(127));
        values.put(Float.class, new Float(Float.MAX_VALUE));
        values.put(BigInteger.class, new BigInteger("0"));
        values.put(BigDecimal.class, new BigDecimal(new BigInteger("0"), 38));
        return values;
    }

    @Override
    public Map minimumNumericValues() {
        HashMap<Class, Number> values = new HashMap<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MIN_VALUE));
        values.put(Long.class, new Long(Long.MIN_VALUE));
        values.put(Double.class, new Double(-1.0E-129));
        values.put(Short.class, new Short(Short.MIN_VALUE));
        values.put(Byte.class, new Byte(-128));
        values.put(Float.class, new Float(Float.MIN_VALUE));
        values.put(BigInteger.class, new BigInteger("0"));
        values.put(BigDecimal.class, new BigDecimal(new BigInteger("0"), 38));
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed(Connection connection) {
        if (!super.isClosed(connection)) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                statement.executeQuery("Select 'x' from DUAL");
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                boolean bl = true;
                return bl;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return true;
    }

    @Override
    public int setBlob(ResultSet results, byte[] data, String columnName) throws SQLException, IOException {
        Blob blob = results.getBlob(columnName);
        OutputStream l_blobOutputStream = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream is = new BufferedInputStream(bais);
        try {
            ReflectionHelper helper = new ReflectionHelper(blob.getClass());
            Object[] args = new Object[]{};
            Method m = helper.findBestMethodOnTarget("getBinaryOutputStream", args);
            l_blobOutputStream = (OutputStream)m.invoke((Object)blob, args);
            byte[] l_buffer = new byte[10240];
            int cnt = ((InputStream)is).available();
            int l_nread = 0;
            while ((l_nread = ((InputStream)is).read(l_buffer)) != -1) {
                l_blobOutputStream.write(l_buffer, 0, l_nread);
            }
            int n = cnt;
            return n;
        }
        catch (Exception nsme) {
            throw new IOException(nsme.getMessage());
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
                is = null;
            }
            if (l_blobOutputStream != null) {
                l_blobOutputStream.close();
                l_blobOutputStream = null;
            }
        }
    }

    @Override
    public String createInsertStatement(Table tableMetadata) {
        ArrayList columns = new ArrayList(tableMetadata.getColumns());
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(tableMetadata.getFullName());
        sql.append(" (");
        String columnString = this.buildCommaSeperatedColumns(columns);
        int size = columns.size();
        sql.append(columnString);
        sql.append(")");
        sql.append(" VALUES ");
        sql.append("(");
        for (int k = 1; k <= size; ++k) {
            if (((Column)columns.get(k - 1)).getDataType() == 2004 || ((Column)columns.get(k - 1)).getDataType() == 1111) {
                sql.append(EMPTY_BLOB);
            } else if (((Column)columns.get(k - 1)).getDataType() == 2005) {
                sql.append(EMPTY_CLOB);
            } else {
                sql.append("?");
            }
            if (k >= size) continue;
            sql.append(", ");
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public boolean isDefault() {
        return false;
    }
}

