/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.metadata;

import com.metamatrix.common.jdbc.metadata.ColumnSet;
import com.metamatrix.common.jdbc.metadata.IndexType;
import com.metamatrix.core.util.ArgCheck;
import java.io.PrintStream;

public class Index
extends ColumnSet {
    private String tableName;
    private boolean unique;
    private boolean approximation;
    private IndexType type;
    private int cardinality;
    private int pages;
    private String filterCondition;
    private String qualifier;

    public Index() {
    }

    public Index(String name) {
        super(name);
    }

    public Index(String catalogName, String schemaName, String tableName, String name) {
        super(catalogName, schemaName, name);
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public IndexType getType() {
        return this.type;
    }

    public void setType(IndexType type) {
        this.type = type;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public boolean generateName() {
        String prefix = "INDX_";
        if (this.getColumns().isEmpty() && this.tableName != null) {
            prefix = prefix + this.tableName;
        }
        return super.generateUniqueName(prefix);
    }

    @Override
    public void print(PrintStream stream) {
        this.print(stream, "  ");
    }

    @Override
    public void print(PrintStream stream, String lead) {
        if (stream == null) {
            ArgCheck.isNotNull((Object)stream, (String)"The stream reference may not be null");
        }
        stream.println(lead + this.getName() + (this.isMarked() ? " <marked>" : "") + " (" + this.getColumnNames() + ")");
    }

    public boolean getApproximation() {
        return this.approximation;
    }

    public void setApproximation(boolean approximation) {
        this.approximation = approximation;
    }
}

