/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.metadata;

import com.metamatrix.common.jdbc.metadata.JDBCObject;
import com.metamatrix.core.util.ArgCheck;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public abstract class JDBCNamespace
extends JDBCObject {
    private List contents = new LinkedList();

    protected JDBCNamespace() {
    }

    protected JDBCNamespace(String name) {
        super(name);
    }

    public List getContents() {
        return this.contents;
    }

    protected void addContent(JDBCObject object) {
        if (!this.contents.contains(object)) {
            this.contents.add(object);
            object.setOwner(this);
        }
    }

    protected boolean removeContent(JDBCObject object) {
        ArgCheck.isTrue((object.getOwner() == this ? 1 : 0) != 0, (String)"The specified object is not contained by this object");
        object.setOwner(null);
        return this.contents.remove(object);
    }

    protected boolean hasContent(JDBCObject object) {
        return this.contents.contains(object);
    }

    protected JDBCObject lookupContent(String name, Class type) {
        return JDBCObject.lookupJDBCObject(this.contents, name, type);
    }

    @Override
    public void print(PrintStream stream) {
        this.print(stream, "  ");
    }

    @Override
    public void print(PrintStream stream, String lead) {
        super.print(stream, lead);
        JDBCObject child2 = null;
        for (JDBCObject child2 : this.contents) {
            child2.print(stream, lead + "  ");
        }
    }
}

