/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.DbLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.log.LogMessage;
import java.util.Properties;

public class DbLogListener
implements LogListener {
    private DbLogWriter writer = null;
    private boolean enabled = true;

    public DbLogListener(Properties prop, boolean enable) {
        if (prop == null) {
            String msg = CommonPlugin.Util.getString("DbLogListener.The_Properties_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        this.writer = new DbLogWriter(prop);
        this.writer.initialize();
        this.enabled = enable;
    }

    public void logMessage(LogMessage msg) {
        if (this.enabled) {
            this.writer.logMessage(msg);
        }
    }

    public void shutdown() {
        this.writer.shutdown();
    }

    public void enableDBLogging(boolean enable) {
        this.enabled = enable;
    }
}

