/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.log.LogMessage;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;

public class DbLogWriter {
    static final String LOGGING = "LOGGING";
    static final String PROPERTY_PREFIX = "metamatrix.log.";
    public static final String DATABASE_PROPERTY_NAME = "metamatrix.log.jdbcDatabase";
    public static final String PROTOCOL_PROPERTY_NAME = "metamatrix.log.jdbcProtocol";
    public static final String DRIVER_PROPERTY_NAME = "metamatrix.log.jdbcDriver";
    public static final String PRINCIPAL_PROPERTY_NAME = "metamatrix.log.jdbcUsername";
    public static final String PASSWORD_PROPERTY_NAME = "metamatrix.log.jdbcPassword";
    public static final String TABLE_PROPERTY_NAME = "metamatrix.log.jdbcTable";
    public static final String MAX_MESSAGE_LENGTH_PROPERTY_NAME = "metamatrix.log.jdbcMaxMsgLength";
    public static final String MAX_GENERAL_LENGTH_PROPERTY_NAME = "metamatrix.log.jdbcMaxContextLength";
    public static final String MAX_EXCEPTION_LENGTH_PROPERTY_NAME = "metamatrix.log.jdbcMaxExceptionLength";
    public static final String DEFAULT_TABLE_NAME = "LOGENTRIES";
    public static final int DEFAULT_MAX_GENERAL_LENGTH = 64;
    public static final int DEFAULT_MAX_EXCEPTION_LENGTH = 4000;
    public static final int DEFAULT_MAX_MSG_LENGTH = 2000;
    private static final String NULL = "Null";
    public static final String PLUGIN_PREFIX = "com.metamatrix.";
    private static final int WRITE_RETRIES = 5;
    private static final int RESUME_LOGGING_AFTER_TIME = 300000;
    private boolean isLogSuspended = false;
    private long resumeTime = -1L;
    private short sequenceNumber;
    private long lastSequenceStart;
    private int maxMsgLength = 2000;
    private int maxGeneralLength = 64;
    private int maxExceptionLength = 4000;
    private Properties connProps;
    private StringBuffer insertStr;
    private boolean shutdown = false;
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String LEFT_PAREN = " (";
    private static final String COMMA = ",";
    private static final String VALUES = ") VALUES (?,?,?,?,?,?,?,?,?)";

    public DbLogWriter(Properties properties) {
        this.connProps = properties;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
    }

    public String getTableName(Properties props) {
        String tableName = props.getProperty(TABLE_PROPERTY_NAME, DEFAULT_TABLE_NAME);
        return tableName;
    }

    public void initialize() {
        int max;
        this.sequenceNumber = 0;
        this.lastSequenceStart = 0L;
        try {
            max = Integer.parseInt(this.connProps.getProperty(MAX_MESSAGE_LENGTH_PROPERTY_NAME));
            if (max > 0) {
                this.maxMsgLength = max;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            max = Integer.parseInt(this.connProps.getProperty(MAX_GENERAL_LENGTH_PROPERTY_NAME));
            if (max > 0) {
                this.maxGeneralLength = max;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int max2 = Integer.parseInt(this.connProps.getProperty(MAX_EXCEPTION_LENGTH_PROPERTY_NAME));
            if (max2 > 0) {
                this.maxExceptionLength = max2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.insertStr = new StringBuffer(INSERT_INTO);
        this.insertStr.append(this.getTableName(this.connProps));
        this.insertStr.append(LEFT_PAREN);
        this.insertStr.append("TIMESTAMP");
        this.insertStr.append(COMMA);
        this.insertStr.append("VMSEQNUM");
        this.insertStr.append(COMMA);
        this.insertStr.append("CONTEXT");
        this.insertStr.append(COMMA);
        this.insertStr.append("MSGLEVEL");
        this.insertStr.append(COMMA);
        this.insertStr.append("MESSAGE");
        this.insertStr.append(COMMA);
        this.insertStr.append("HOSTNAME");
        this.insertStr.append(COMMA);
        this.insertStr.append("VMID");
        this.insertStr.append(COMMA);
        this.insertStr.append("THREADNAME");
        this.insertStr.append(COMMA);
        this.insertStr.append("\"EXCEPTION\"");
        this.insertStr.append(VALUES);
    }

    public synchronized void logMessage(LogMessage msg) {
        this.write(msg);
    }

    private void write(LogMessage message) {
        int retrycnt = 0;
        if (this.isLogSuspended && System.currentTimeMillis() > this.resumeTime) {
            this.resumeLogging();
        }
        while (!this.isLogSuspended && !this.shutdown) {
            try {
                this.printMsg(message);
                return;
            }
            catch (Exception ex) {
                if (retrycnt >= 5) {
                    this.suspendLogging();
                } else {
                    this.resumeLogging();
                }
                ++retrycnt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMsg(LogMessage message) throws SQLException {
        if (this.shutdown) {
            return;
        }
        long msgTimeStamp = message.getTimestamp();
        if (this.lastSequenceStart != msgTimeStamp) {
            this.lastSequenceStart = msgTimeStamp;
            this.sequenceNumber = 0;
        }
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = JDBCConnectionPoolHelper.getInstance().getConnection();
            stmt = connection.prepareStatement(this.insertStr.toString());
            stmt.setString(1, DateUtil.getDateAsString((Date)new Timestamp(msgTimeStamp)));
            stmt.setShort(2, this.sequenceNumber);
            stmt.setString(3, StringUtil.truncString((String)message.getContext(), (int)this.maxGeneralLength));
            stmt.setInt(4, message.getLevel());
            stmt.setString(5, StringUtil.truncString((String)message.getText(), (int)this.maxMsgLength));
            stmt.setString(6, StringUtil.truncString((String)VMNaming.getConfigName(), (int)this.maxGeneralLength));
            stmt.setString(7, StringUtil.truncString((String)VMNaming.getProcessName(), (int)this.maxGeneralLength));
            stmt.setString(8, StringUtil.truncString((String)message.getThreadName(), (int)this.maxGeneralLength));
            if (message.getException() != null) {
                String eMsg = message.getException().getMessage();
                eMsg = eMsg == null ? NULL : StringUtil.truncString((String)eMsg, (int)this.maxExceptionLength);
                stmt.setString(9, eMsg);
            } else {
                stmt.setString(9, NULL);
            }
            stmt.executeUpdate();
        }
        finally {
            this.sequenceNumber = (short)(this.sequenceNumber + 1);
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                System.err.println(CommonPlugin.Util.getString("ERR.003.014.0027") + ex.getMessage());
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException ex) {
                System.err.println(CommonPlugin.Util.getString("ERR.003.014.0027") + ex.getMessage());
            }
        }
    }

    private void suspendLogging() {
        this.isLogSuspended = true;
        this.resumeTime = System.currentTimeMillis() + 300000L;
        Date rd = new Date(this.resumeTime);
        String stringDate = DateUtil.getDateAsString((Date)rd);
        System.err.println(CommonPlugin.Util.getString("DBLogWriter.Database_Logging_has_been_suspended", new Object[]{stringDate}));
    }

    private void resumeLogging() {
        this.isLogSuspended = false;
        this.resumeTime = -1L;
        Date rd = new Date(System.currentTimeMillis());
        String stringDate = DateUtil.getDateAsString((Date)rd);
        System.err.println(CommonPlugin.Util.getString("DBLogWriter.Database_Logging_has_been_resumed", new Object[]{stringDate}));
    }

    public static final class ColumnName {
        public static final String TIMESTAMP = "TIMESTAMP";
        public static final String SEQUENCE_NUMBER = "VMSEQNUM";
        public static final String CONTEXT = "CONTEXT";
        public static final String LEVEL = "MSGLEVEL";
        public static final String EXCEPTION = "EXCEPTION";
        public static final String MESSAGE = "MESSAGE";
        public static final String HOST = "HOSTNAME";
        public static final String VM = "VMID";
        public static final String THREAD = "THREADNAME";
    }
}

