/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.CorePlugin;

public final class I18nLogManager {
    private static I18nLogManager INSTANCE = new I18nLogManager();
    private static final String NULL_MSG_TEXT = "Null";

    private I18nLogManager() {
    }

    public static void logError(String context, String msgID, Throwable e) {
        if (e != null) {
            INSTANCE.logMessage(2, msgID, context, e);
        }
    }

    public static void logError(String context, String msgID, Throwable e, Object[] msgParts) {
        if (e != null) {
            INSTANCE.logMessage(2, msgID, context, e, msgParts);
        }
    }

    public static void logError(String context, String msgID, Throwable e, Object msgPart) {
        if (e != null) {
            INSTANCE.logMessage(2, msgID, context, e, new Object[]{msgPart});
        }
    }

    public static void logInfo(String context, String msgID, Object[] msgParts) {
        if (msgParts != null) {
            INSTANCE.logMessage(4, msgID, context, msgParts);
        }
    }

    private void logMessage(int level, String msgID, String context, Object[] msgParts) {
        if (!LogManager.isMessageToBeRecorded((String)context, (int)level)) {
            return;
        }
        LogManager.log((int)level, (String)context, (String)this.geti18nMsg(msgID, msgParts));
    }

    private String geti18nMsg(String msgID, Object[] msgParts) {
        if (msgID != null) {
            if (msgParts == null) {
                return CorePlugin.Util.getString(msgID);
            }
            return CorePlugin.Util.getString(msgID, msgParts);
        }
        StringBuffer text = null;
        if (msgParts != null) {
            text = new StringBuffer();
            for (int i = 0; i < msgParts.length; ++i) {
                Object omsg;
                if (i > 0) {
                    text.append(" ");
                }
                if ((omsg = msgParts[i]) == null) continue;
                text.append(omsg.toString());
            }
        }
        if (text == null) {
            return NULL_MSG_TEXT;
        }
        return text.toString();
    }

    private void logMessage(int level, String msgID, String context, Throwable e) {
        if (!LogManager.isMessageToBeRecorded((String)context, (int)level)) {
            return;
        }
        LogManager.log((int)level, (String)context, (Throwable)e, (String)this.geti18nMsg(msgID, null));
    }

    private void logMessage(int level, String msgID, String context, Throwable e, Object[] msgParts) {
        if (!LogManager.isMessageToBeRecorded((String)context, (int)level)) {
            return;
        }
        LogManager.log((int)level, (String)context, (Throwable)e, (String)this.geti18nMsg(msgID, msgParts));
    }
}

