/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log.reader;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.log.reader.LogEntry;
import com.metamatrix.common.log.reader.LogEntryPropertyNames;
import com.metamatrix.common.log.reader.LogReader;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.DateUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DBLogReader
implements LogReader {
    static final String PROPERTY_PREFIX = "metamatrix.log.";
    public static final String TABLE_PROPERTY_NAME = "metamatrix.log.jdbcTable";
    public static final String DEFAULT_TABLE_NAME = "LOGENTRIES";
    private Properties properties;
    protected String tableName;

    public DBLogReader() throws MetaMatrixException {
        this.init();
    }

    public void init() throws MetaMatrixException {
        Properties globalProperties = CurrentConfiguration.getInstance().getProperties();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)globalProperties);
        this.properties = PropertiesUtils.clone((Properties)props, (Properties)System.getProperties(), (boolean)true, (boolean)false);
        this.tableName = this.properties.getProperty(TABLE_PROPERTY_NAME, DEFAULT_TABLE_NAME);
    }

    protected Connection getConnection() throws ManagedConnectionException {
        try {
            Connection connection = JDBCConnectionPoolHelper.getInstance().getConnection();
            return connection;
        }
        catch (Exception e) {
            throw new ManagedConnectionException(e, "ERR.003.014.0009", CommonPlugin.Util.getString("ERR.003.014.0009"));
        }
    }

    protected void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getLogEntries(Date startTime, Date endTime, List levels, List contexts, int maxRows) throws MetaMatrixComponentException {
        Connection connection = null;
        Statement statement = null;
        String sqlString = null;
        try {
            connection = this.getConnection();
            sqlString = this.createSQL(startTime, endTime, levels, contexts, maxRows);
            statement = connection.createStatement();
            statement.execute(sqlString);
            ResultSet result = statement.getResultSet();
            List list = this.convertResults(result, maxRows);
            this.close(statement);
            this.close(connection);
            return list;
        }
        catch (ManagedConnectionException e) {
            try {
                throw new MetaMatrixComponentException((Throwable)((Object)e), "ERR.003.014.0032", CommonPlugin.Util.getString("ERR.003.014.0032", new Object[]{sqlString}));
                catch (SQLException e2) {
                    throw new MetaMatrixComponentException((Throwable)e2, "ERR.003.014.0032", CommonPlugin.Util.getString("ERR.003.014.0032", new Object[]{sqlString}));
                }
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(connection);
                throw throwable;
            }
        }
    }

    private String createSQL(Date startTime, Date endTime, List levels, List contexts, int maxRows) {
        StringBuffer sql = new StringBuffer("select ");
        List columnNames = LogEntryPropertyNames.COLUMN_NAMES;
        Iterator iter = columnNames.iterator();
        while (iter.hasNext()) {
            String colName = (String)iter.next();
            if (colName.equals("EXCEPTION")) {
                sql.append('\"' + colName + '\"');
            } else {
                sql.append(colName);
            }
            if (!iter.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(" from ");
        sql.append(this.tableName);
        sql.append(" where ");
        sql.append(this.createTimeSql(startTime, endTime));
        sql.append(" and ");
        sql.append(this.createLevelSql(levels));
        String contextSql = this.createContextSql(contexts);
        if (contextSql != null) {
            sql.append(" and ");
            sql.append(contextSql);
        }
        sql.append(" order by ");
        sql.append("TIMESTAMP");
        sql.append(" desc, ");
        sql.append("MSGLEVEL");
        return sql.toString();
    }

    private String createTimeSql(Date startTime, Date endTime) {
        StringBuffer sql = new StringBuffer("(");
        sql.append("TIMESTAMP");
        sql.append(" >= ");
        sql.append("'").append(DateUtil.getDateAsString((Date)startTime)).append("'");
        if (endTime != null) {
            sql.append(" and ");
            sql.append("TIMESTAMP");
            sql.append(" <= ");
            sql.append("'").append(DateUtil.getDateAsString((Date)endTime)).append("'");
        }
        sql.append(")");
        return sql.toString();
    }

    private String createLevelSql(List levels) {
        StringBuffer sql = new StringBuffer("(");
        Iterator iter = levels.iterator();
        while (iter.hasNext()) {
            Integer level = (Integer)iter.next();
            sql.append("MSGLEVEL");
            sql.append(" = ");
            sql.append(level);
            if (!iter.hasNext()) continue;
            sql.append(" or ");
        }
        sql.append(")");
        return sql.toString();
    }

    private String createContextSql(List selectedContexts) {
        if (selectedContexts == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer("(");
        Iterator iter = selectedContexts.iterator();
        while (iter.hasNext()) {
            String context = (String)iter.next();
            sql.append("CONTEXT");
            sql.append("='");
            sql.append(context);
            sql.append("'");
            if (!iter.hasNext()) continue;
            sql.append(" or ");
        }
        sql.append(")");
        return sql.toString();
    }

    private List convertResults(ResultSet results, int maxRows) throws SQLException {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (int nrows = 0; results.next() && nrows < maxRows; ++nrows) {
            LogEntry entry = new LogEntry();
            entry.setContext(results.getString("CONTEXT"));
            entry.setException(results.getString("EXCEPTION"));
            entry.setHostName(results.getString("HOSTNAME"));
            entry.setLevel(results.getInt("MSGLEVEL"));
            entry.setProcessName(results.getString("VMID"));
            entry.setThreadName(results.getString("THREADNAME"));
            try {
                entry.setDate(DateUtil.convertStringToDate((String)results.getString("TIMESTAMP")));
            }
            catch (ParseException e) {
                // empty catch block
            }
            String message = results.getString("MESSAGE");
            if (message.trim().equalsIgnoreCase("null")) {
                message = "<null>";
            }
            entry.setMessage(message);
            entries.add(entry);
        }
        return entries;
    }
}

