/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.messaging;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.messaging.NoOpMessageBus;
import com.metamatrix.common.messaging.jgroups.JGroupsMessageBus;
import com.metamatrix.core.event.AsynchEventBroker;
import com.metamatrix.core.event.EventBroker;
import com.metamatrix.core.event.EventBrokerException;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.event.EventSourceException;
import com.metamatrix.server.ChannelProvider;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Properties;
import org.jgroups.ChannelException;

@Singleton
public class VMMessageBus
implements MessageBus {
    private Object messageBus;
    private Object lock = new Object();
    private boolean closed = true;
    private EventBroker eventBroker = new AsynchEventBroker("VMMessageBus");

    @Inject
    public VMMessageBus(ChannelProvider channelProvider, @Named(value="ClusterName") String clusterName) throws MetaMatrixComponentException {
        Properties env = null;
        String mbType = System.getProperty("metamatrix.message.bus.type");
        if (mbType == null || mbType.trim().length() == 0) {
            env = CurrentConfiguration.getInstance().getProperties();
            mbType = env.getProperty("metamatrix.message.bus.type");
        }
        if (mbType != null && mbType.equals("noop.message.bus")) {
            this.messageBus = new NoOpMessageBus();
        } else {
            try {
                this.messageBus = new JGroupsMessageBus(channelProvider, this.eventBroker, clusterName);
            }
            catch (ChannelException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
        }
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Class eventClass, EventObjectListener listener) throws MessagingException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            try {
                this.eventBroker.addListener(eventClass, listener);
            }
            catch (EventSourceException e) {
                throw new MessagingException(e, "ERR.003.017.0013", CommonPlugin.Util.getString("ERR.003.017.0013"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws MessagingException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            ((MessageBus)this.messageBus).shutdown();
            try {
                this.eventBroker.shutdown();
            }
            catch (EventBrokerException e) {
                throw new MessagingException(e, "ERR.003.017.0014", CommonPlugin.Util.getString("ERR.003.017.0014"));
            }
            this.messageBus = null;
            this.eventBroker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Class eventClass, EventObjectListener listener) throws MessagingException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            try {
                this.eventBroker.removeListener(eventClass, listener);
            }
            catch (EventSourceException e) {
                throw new MessagingException(e, "ERR.003.017.0015", CommonPlugin.Util.getString("ERR.003.017.0015"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(EventObjectListener listener) throws MessagingException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            try {
                this.eventBroker.removeListener(listener);
            }
            catch (EventSourceException e) {
                throw new MessagingException(e, "ERR.003.017.0015", CommonPlugin.Util.getString("ERR.003.017.0015"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(EventObject obj) throws MessagingException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            ((MessageBus)this.messageBus).processEvent(obj);
            this.eventBroker.processEvent(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable export(Object object, Class[] targetClasses) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.closed) {
                return null;
            }
            return ((MessageBus)this.messageBus).export(object, targetClasses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getRPCProxy(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.closed) {
                return null;
            }
            return ((MessageBus)this.messageBus).getRPCProxy(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unExport(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.closed) {
                return;
            }
            ((MessageBus)this.messageBus).unExport(object);
        }
    }
}

