/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.messaging.jgroups;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.RemoteMessagingException;
import com.metamatrix.common.messaging.jgroups.RPCStruct;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.service.api.exception.ServiceNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;

public class RemoteProxy {
    private Map<UUID, RPCStruct> rpcStructs;

    public RemoteProxy(Map<UUID, RPCStruct> remoteObjects) {
        this.rpcStructs = remoteObjects;
    }

    public Object invokeRemoteMethod(UUID classId, String methodName, Class[] parameterTypes, Object[] args) throws Throwable {
        RPCStruct struct = this.rpcStructs.get(classId);
        try {
            if (struct != null) {
                try {
                    Method m = struct.actualObj.getClass().getMethod(methodName, parameterTypes);
                    return m.invoke(struct.actualObj, args);
                }
                catch (NoSuchMethodException e) {
                    throw new RemoteMessagingException(e);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            throw new ServiceNotFoundException();
        }
        catch (Throwable t) {
            LogManager.logWarning((String)"PROXY", (Throwable)t, (String)PlatformPlugin.Util.getString("RemoteProxy.localCallFailed", new Object[]{methodName, classId}));
            throw t;
        }
    }

    public static Method getInvokeMethod() {
        try {
            return RemoteProxy.class.getMethod("invokeRemoteMethod", UUID.class, String.class, Class[].class, Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }
}

