/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.net;

import com.metamatrix.common.comm.platform.socket.SocketUtil;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.Assertion;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class ServerSocketConfiguration {
    private static final String SSL_ENABLED = "metamatrix.encryption.secure.sockets";
    private static final String KEYSTORE_FILENAME = "com.metamatrix.ssl.keystore.filename";
    private static final String KEYSTORE_PASSWORD = "com.metamatrix.ssl.keystore.Password";
    private static final String KEYSTORE_TYPE = "com.metamatrix.ssl.keystoretype";
    private static final String SSL_PROTOCOL = "com.metamatrix.ssl.protocol";
    private static final String KEY_MANAGER_ALGORITHM = "com.metamatrix.ssl.keymanagementalgorithm";
    private static final String TRUSTSTORE_FILENAME = "com.metamatrix.ssl.truststore.filename";
    private static final String TRUSTSTORE_PASSWORD = "com.metamatrix.ssl.truststore.Password";
    private static final String AUTHENTICATION_MODE = "com.metamatrix.ssl.authenticationMode";
    public static final String ONEWAY = "1-way";
    public static final String TWOWAY = "2-way";
    public static final String ANONYMOUS = "anonymous";
    public static final String DEFAULT_SSL_PROTOCOL = "SSLv3";
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String UNENCRYPTED_CIPHER_SUITE = "SSL_RSA_WITH_NULL_SHA";
    private boolean ssl_enabled;
    private String sslProtocol = "SSLv3";
    private String keyManagerFactoryAlgorithm;
    private String keyStoreType = "JKS";
    private String keyStoreFileName;
    private String keyStorePassword = "";
    private String trustStoreFileName;
    private String trustStorePassword = "";
    private String authenticationMode = "1-way";
    boolean client_encryption_enabled = false;

    public static boolean isSSLEnabled() {
        return CryptoUtil.isEncryptionEnabled() && PropertiesUtils.getBooleanProperty((Properties)CurrentConfiguration.getInstance().getProperties(), (String)SSL_ENABLED, (boolean)false);
    }

    public void init() throws ConfigurationException {
        Properties p = CurrentConfiguration.getInstance().getProperties();
        p = PropertiesUtils.clone((Properties)CurrentConfiguration.getInstance().getResourceProperties("SSL"), (Properties)p, (boolean)true);
        this.init(p);
    }

    public void init(Properties props) {
        this.ssl_enabled = PropertiesUtils.getBooleanProperty((Properties)props, (String)SSL_ENABLED, (boolean)false);
        this.client_encryption_enabled = PropertiesUtils.getBooleanProperty((Properties)props, (String)"metamatrix.encryption.client.encryption", (boolean)true);
        this.keyStoreFileName = props.getProperty(KEYSTORE_FILENAME);
        try {
            this.keyStorePassword = CryptoUtil.stringDecrypt((String)props.getProperty(KEYSTORE_PASSWORD, ""));
        }
        catch (CryptoException err) {
            throw new MetaMatrixRuntimeException((Throwable)err);
        }
        this.keyStoreType = props.getProperty(KEYSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
        this.keyManagerFactoryAlgorithm = props.getProperty(KEY_MANAGER_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
        this.authenticationMode = props.getProperty(AUTHENTICATION_MODE);
        this.trustStoreFileName = props.getProperty(TRUSTSTORE_FILENAME);
        try {
            this.trustStorePassword = CryptoUtil.stringDecrypt((String)props.getProperty(TRUSTSTORE_PASSWORD, ""));
        }
        catch (CryptoException err) {
            throw new MetaMatrixRuntimeException((Throwable)err);
        }
        this.sslProtocol = props.getProperty(SSL_PROTOCOL, DEFAULT_SSL_PROTOCOL);
    }

    public SSLEngine getServerSSLEngine() throws IOException, GeneralSecurityException {
        if (!this.isServerSSLEnabled()) {
            return null;
        }
        SSLContext context = null;
        context = ANONYMOUS.equals(this.authenticationMode) ? SocketUtil.getAnonSSLContext() : SocketUtil.getSSLContext((String)this.keyStoreFileName, (String)this.keyStorePassword, (String)this.trustStoreFileName, (String)this.trustStorePassword, (String)this.keyManagerFactoryAlgorithm, (String)this.keyStoreType, (String)this.sslProtocol);
        SSLEngine result = context.createSSLEngine();
        result.setUseClientMode(false);
        if (ANONYMOUS.equals(this.authenticationMode)) {
            Assertion.assertTrue((boolean)Arrays.asList(result.getSupportedCipherSuites()).contains("TLS_DH_anon_WITH_AES_128_CBC_SHA"));
            result.setEnabledCipherSuites(new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"});
        }
        result.setNeedClientAuth(TWOWAY.equals(this.authenticationMode));
        return result;
    }

    public boolean isServerSSLEnabled() {
        return this.ssl_enabled && CryptoUtil.isEncryptionEnabled();
    }

    public boolean isClientEncryptionEnabled() {
        return CryptoUtil.isEncryptionEnabled() && this.client_encryption_enabled;
    }
}

