/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime;

import com.metamatrix.api.exception.ComponentCommunicationException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractVDBDeleteUtility {
    public void deleteVDBMarkedForDelete(VirtualDatabaseID vdbID) throws VirtualDatabaseException, MetaMatrixComponentException {
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"deleteVDBMarkedForDelete(): checking " + vdbID + " to see if marked for deletion."});
        Collection vdbs = RuntimeMetadataCatalog.getInstance().getDeletedVirtualDatabaseIDs();
        if (vdbs.size() == 0 || !vdbs.contains(vdbID)) {
            return;
        }
        if (this.checkSessions(vdbID)) {
            LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"deleteVDBMarkedForDelete(): deleting " + vdbID + " - no sessions logged in."});
            this.deleteAuthorizationPoliciesForVDB(vdbID.getName(), vdbID.getVersion());
            RuntimeMetadataCatalog.getInstance().deleteVirtualDatabase(vdbID);
            LogManager.logInfo((String)"RUNTIME_METADATA", (String)RuntimeMetadataPlugin.Util.getString("VDBDeleteUtility.1", new Object[]{vdbID}));
        } else {
            LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"deleteVDBMarkedForDelete(): NOT deleting " + vdbID + " - has sessions logged in."});
        }
    }

    public void deleteVDBsMarkedForDelete(MetaMatrixSessionID id) throws MetaMatrixProcessingException, MetaMatrixComponentException {
        Collection vdbs = RuntimeMetadataCatalog.getInstance().getDeletedVirtualDatabaseIDs();
        if (vdbs.size() == 0) {
            return;
        }
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"deleteVDBsMarkedForDelete(" + id + "): checking " + vdbs.size() + " VDBs marked for deletion."});
        for (VirtualDatabaseID vdbID : vdbs) {
            if (!this.checkSessions(vdbID, id)) continue;
            LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"deleteVDBsMarkedForDelete(" + id + "): deleting " + vdbID + " - no sessions logged in."});
            this.deleteAuthorizationPoliciesForVDB(vdbID.getName(), vdbID.getVersion());
            RuntimeMetadataCatalog.getInstance().deleteVirtualDatabase(vdbID);
            LogManager.logInfo((String)"RUNTIME_METADATA", (String)RuntimeMetadataPlugin.Util.getString("VDBDeleteUtility.1", new Object[]{vdbID}));
        }
    }

    protected Collection getSessionsLoggedInToVDB(String VDBName, String VDBVersion) throws MetaMatrixComponentException {
        Collection sessionIDs = Collections.EMPTY_LIST;
        try {
            sessionIDs = this.getSessionServiceProxy().getSessionsLoggedInToVDB(VDBName, VDBVersion);
        }
        catch (SessionServiceException e) {
            throw new ComponentCommunicationException((Throwable)e, "ERR.008.001.0028", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0028"));
        }
        catch (ServiceException e) {
            throw new ComponentCommunicationException((Throwable)((Object)e), "ERR.008.001.0028", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0028"));
        }
        return sessionIDs;
    }

    private SessionServiceInterface getSessionServiceProxy() throws ServiceException {
        SessionServiceInterface sessionServiceProxy = PlatformProxyHelper.getSessionServiceProxy("ROUND_ROBIN_LOCAL");
        return sessionServiceProxy;
    }

    public abstract void deleteAuthorizationPoliciesForVDB(String var1, String var2) throws MetaMatrixComponentException;

    public abstract boolean checkSessions(VirtualDatabaseID var1, MetaMatrixSessionID var2) throws MetaMatrixComponentException;

    public abstract boolean checkSessions(VirtualDatabaseID var1) throws MetaMatrixComponentException;
}

