/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime;

import com.metamatrix.cache.Cache;
import com.metamatrix.cache.CacheConfiguration;
import com.metamatrix.cache.CacheFactory;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.TransactionMgr;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.dqp.service.metadata.QueryMetadataCache;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.MetadataSourceAPI;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseMetadata;
import com.metamatrix.metadata.runtime.event.RuntimeMetadataEvent;
import com.metamatrix.metadata.runtime.event.RuntimeMetadataListener;
import com.metamatrix.metadata.runtime.exception.InvalidStateException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseDoesNotExistException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseMetadata;
import com.metamatrix.metadata.runtime.model.MetadataCache;
import com.metamatrix.metadata.runtime.model.UpdateController;
import com.metamatrix.metadata.runtime.spi.MetaBaseConnector;
import com.metamatrix.metadata.runtime.spi.jdbc.JDBCConnectorFactory;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RuntimeMetadataCatalog {
    private static RuntimeMetadataCatalog instance = new RuntimeMetadataCatalog();
    private Cache vdbModelsCache = null;
    private UpdateController controller = null;
    private Cache vdbMetadataCache = null;
    private TransactionMgr transMgr = null;
    private Properties allProps;
    private MessageBus messageBus;
    private boolean persist = true;
    private MetadataCache systemModels = null;
    private QueryMetadataCache cache;

    public static RuntimeMetadataCatalog getInstance() {
        return instance;
    }

    public EventObjectListener registerRuntimeMetadataListener(RuntimeMetadataListener listener) throws VirtualDatabaseException {
        try {
            VDBListener elistener = new VDBListener(listener);
            this.messageBus.addListener(RuntimeMetadataEvent.class, elistener);
            return elistener;
        }
        catch (Exception e) {
            String msg = RuntimeMetadataPlugin.Util.getString("RuntimeMetadataCatalog.Error_adding_listener");
            throw new VirtualDatabaseException(e, msg);
        }
    }

    public void removeRuntimeMetadataListener(EventObjectListener listener) throws VirtualDatabaseException {
        try {
            this.messageBus.removeListener(RuntimeMetadataEvent.class, listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public VirtualDatabase createVirtualDatabase(VDBArchive vdbArchive, String userName) throws VirtualDatabaseException {
        VirtualDatabase vdb = this.getUpdateController().createVirtualDatabase(vdbArchive, userName);
        this.fireEvent(vdb.getVirtualDatabaseID(), 5);
        return vdb;
    }

    public VirtualDatabaseMetadata getVirtualDatabaseMetadata(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        return this.getVirtualDatabaseMetadata(vdbID, true);
    }

    private VirtualDatabaseMetadata getVirtualDatabaseMetadata(VirtualDatabaseID vdbID, boolean includeMetadata) throws VirtualDatabaseException {
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"Creating new BasicVirtualDatabaseMetadata instance for VDB ID \"" + vdbID + ")\""});
        BasicVirtualDatabaseMetadata vDBMetadata = new BasicVirtualDatabaseMetadata(this.loadVDB(vdbID, includeMetadata), vdbID);
        return vDBMetadata;
    }

    public VirtualDatabaseID getActiveVirtualDatabaseID(String vdbName, String vdbVersion) throws VirtualDatabaseDoesNotExistException, VirtualDatabaseException {
        if (vdbName == null) {
            throw new IllegalArgumentException(RuntimeMetadataPlugin.Util.getString("ERR.008.001.0001"));
        }
        MetaBaseConnector conn = null;
        VirtualDatabaseID vdbID = null;
        try {
            conn = this.getReadTransaction();
            vdbID = conn.getActiveVirtualDatabaseID(vdbName, vdbVersion);
        }
        catch (ManagedConnectionException e) {
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.001.0002", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0002", new Object[]{vdbName}));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    LogManager.logDetail((String)"RUNTIME_METADATA", (Throwable)e2, (String)RuntimeMetadataPlugin.Util.getString("ERR.008.000.0001"));
                }
            }
        }
        if (vdbID == null) {
            throw new VirtualDatabaseDoesNotExistException("ERR.008.001.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0003", new Object[]{vdbName, vdbVersion}));
        }
        return vdbID;
    }

    public VirtualDatabaseID getVirtualDatabaseID(String vdbName, String vdbVersion) throws VirtualDatabaseDoesNotExistException, VirtualDatabaseException {
        if (vdbName == null) {
            throw new IllegalArgumentException(RuntimeMetadataPlugin.Util.getString("ERR.008.001.0001"));
        }
        MetaBaseConnector conn = null;
        VirtualDatabaseID vdbID = null;
        try {
            conn = this.getReadTransaction();
            vdbID = conn.getVirtualDatabaseID(vdbName, vdbVersion);
        }
        catch (ManagedConnectionException e) {
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.001.0002", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0002", new Object[]{vdbName}));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    LogManager.logDetail((String)"RUNTIME_METADATA", (Throwable)e2, (String)RuntimeMetadataPlugin.Util.getString("ERR.008.000.0001"));
                }
            }
        }
        if (vdbID == null) {
            throw new VirtualDatabaseDoesNotExistException("ERR.008.001.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0003", new Object[]{vdbName, vdbVersion == null ? "NoVersion" : vdbVersion}));
        }
        return vdbID;
    }

    public void setVDBStatus(VirtualDatabaseID virtualDBID, short status, String userName) throws VirtualDatabaseException {
        if (!this.persist) {
            return;
        }
        try {
            this.getUpdateController().setVBDStatus(virtualDBID, status, userName);
            switch (status) {
                case 1: 
                case 2: {
                    this.removeFromMetadataCache(virtualDBID);
                    this.fireEvent(virtualDBID, 4);
                }
            }
        }
        catch (InvalidStateException ie) {
            throw new VirtualDatabaseException((Exception)((Object)ie), "ERR.008.001.0004", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0004", new Object[]{virtualDBID.getName()}));
        }
    }

    public Collection getVirtualDatabases() throws VirtualDatabaseException {
        Collection vdbs;
        MetaBaseConnector conn = null;
        try {
            conn = this.getReadTransaction();
            vdbs = conn.getVirtualDatabases();
        }
        catch (ManagedConnectionException e) {
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.001.0005", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0005"));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    LogManager.logDetail((String)"RUNTIME_METADATA", (Throwable)e2, (String)RuntimeMetadataPlugin.Util.getString("ERR.008.000.0001"));
                }
            }
        }
        return vdbs;
    }

    public byte[] getVDBArchive(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        byte[] archive = null;
        VirtualDatabase vdb = this.getVirtualDatabase(vdbID);
        archive = this.getUpdateController().getVDBArchive(vdb.getFileName());
        return archive;
    }

    public byte[] getSystemVDBArchive() throws VirtualDatabaseException {
        return this.getUpdateController().getVDBArchive("System.vdb");
    }

    public VirtualDatabase getVirtualDatabase(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        VirtualDatabase vdb;
        MetaBaseConnector conn = null;
        try {
            conn = this.getReadTransaction();
            vdb = conn.getVirtualDatabase(vdbID);
        }
        catch (ManagedConnectionException e) {
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.001.0006", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0006", new Object[]{vdbID.getName()}));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    LogManager.logDetail((String)"RUNTIME_METADATA", (Throwable)e2, (String)RuntimeMetadataPlugin.Util.getString("ERR.008.000.0001"));
                }
            }
        }
        return vdb;
    }

    public Collection getDeletedVirtualDatabaseIDs() throws VirtualDatabaseException {
        Collection vdbs;
        MetaBaseConnector conn = null;
        try {
            conn = this.getReadTransaction();
            vdbs = conn.getDeletedVirtualDatabaseIDs();
        }
        catch (ManagedConnectionException e) {
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.001.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0007"));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    LogManager.logDetail((String)"RUNTIME_METADATA", (Throwable)e2, (String)RuntimeMetadataPlugin.Util.getString("ERR.008.000.0001"));
                }
            }
        }
        return vdbs;
    }

    public void deleteVirtualDatabase(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        if (this.persist) {
            this.getUpdateController().deleteVirtualDatabase(vdbID);
            this.fireEvent(vdbID, 2);
        }
        this.removeFromCache(vdbID);
    }

    public static void refreshProperties() throws VirtualDatabaseException {
    }

    public Collection getModels(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        Map modelMap = this.getModelMap(vdbID);
        ArrayList models = new ArrayList(modelMap.size());
        models.addAll(modelMap.values());
        return models;
    }

    public List getMutiSourcedModels(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        ArrayList<String> models = null;
        Map modelMap = this.getModelMap(vdbID);
        if (modelMap != null && modelMap.size() > 0) {
            models = new ArrayList<String>(modelMap.size());
            for (Object o : modelMap.keySet()) {
                Model m = (Model)modelMap.get(o);
                if (!m.isMultiSourceBindingEnabled()) continue;
                models.add(m.getFullName());
            }
        }
        if (models == null) {
            return Collections.EMPTY_LIST;
        }
        return models;
    }

    private Map getModelMap(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        HashMap<String, Model> modelMap = null;
        MetaBaseConnector conn = null;
        Object v = this.vdbModelsCache.get((Object)vdbID);
        if (v != null) {
            LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"VDB " + vdbID + " is in cache"});
            modelMap = (HashMap<String, Model>)v;
            return modelMap;
        }
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"VDB " + vdbID + " is NOT in cache"});
        try {
            conn = this.getReadTransaction();
            Collection models = conn.getModels(vdbID);
            modelMap = new HashMap<String, Model>(models.size());
            for (Model m : models) {
                modelMap.put(m.getName(), m);
            }
            this.vdbModelsCache.put((Object)vdbID, modelMap);
        }
        catch (ManagedConnectionException e) {
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.001.0009", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0009", new Object[]{vdbID.getName()}));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    LogManager.logDetail((String)"RUNTIME_METADATA", (Throwable)e2, (String)RuntimeMetadataPlugin.Util.getString("ERR.008.000.0001"));
                }
            }
        }
        return modelMap;
    }

    public boolean isVisible(String resourcePath, VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        VirtualDatabaseMetadata vdbm = this.getVirtualDatabaseMetadata(vdbID, false);
        return vdbm.isVisible(resourcePath);
    }

    public Model getModel(String modelName, VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        Map modelMap = this.getModelMap(vdbID);
        if (modelMap.containsKey(modelName)) {
            Model m = (Model)modelMap.get(modelName);
            return m;
        }
        VirtualDatabaseMetadata vdbm = this.getVirtualDatabaseMetadata(vdbID, false);
        if (vdbm != null) {
            return vdbm.getModel(modelName);
        }
        return null;
    }

    public void setConnectorBindingNames(VirtualDatabaseID vdbID, Map modelAndCBNames, String userName) throws VirtualDatabaseException {
        Collection models = this.getModels(vdbID);
        HashMap cNamesByIDs = new HashMap();
        Iterator iter = modelAndCBNames.keySet().iterator();
        ModelID mID = null;
        try {
            while (iter.hasNext()) {
                String mName = (String)iter.next();
                if (modelAndCBNames.get(mName) == null) continue;
                Iterator mIter = models.iterator();
                while (mIter.hasNext() && !(mID = (ModelID)((Model)mIter.next()).getID()).getFullName().equalsIgnoreCase(mName)) {
                }
                if (mID == null) {
                    throw new VirtualDatabaseException("ERR.008.001.0010", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0010", new Object[]{mName, vdbID.getName()}));
                }
                List bindings = (List)modelAndCBNames.get(mName);
                for (String bRouting : bindings) {
                    if (CurrentConfiguration.getInstance().getConfiguration().getConnectorBindingByRoutingID(bRouting) != null) continue;
                    throw new VirtualDatabaseException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataCatalog.No_connector_binding_found", new Object[]{mName, bRouting}));
                }
                cNamesByIDs.put(mID, modelAndCBNames.get(mName));
            }
        }
        catch (ConfigurationException ce) {
            throw new VirtualDatabaseException((Exception)((Object)ce));
        }
        this.getUpdateController().setConnectorBindingNames(vdbID, cNamesByIDs, userName);
        this.refreshCache(vdbID);
        this.fireEvent(vdbID, 1);
    }

    public void updateVirtualDatabase(VirtualDatabase vdb, String userName) throws VirtualDatabaseException {
        this.getUpdateController().updateVirtualDatabase(vdb, userName);
    }

    public void init(Properties runtimeProperties, MessageBus messageBus, CacheFactory factory) throws VirtualDatabaseException, MessagingException {
        this.allProps = this.getProperties(runtimeProperties);
        LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{RuntimeMetadataPlugin.Util.getString("MSG.008.000.0001")});
        this.transMgr = RuntimeMetadataCatalog.getTransactionMgr(this.allProps);
        LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{RuntimeMetadataPlugin.Util.getString("MSG.008.001.0001")});
        this.messageBus = messageBus;
        VDBListener l = new VDBListener();
        messageBus.addListener(RuntimeMetadataEvent.class, l);
        LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{RuntimeMetadataPlugin.Util.getString("MSG.008.001.0002")});
        CacheConfiguration config = new CacheConfiguration(CacheConfiguration.Policy.MRU, 0, 0);
        this.vdbMetadataCache = factory.get(Cache.Type.VDBMETADATA, config);
        this.vdbModelsCache = factory.get(Cache.Type.VDBMODELS, config);
        this.controller = new UpdateController(this.transMgr);
        this.loadSystemMetadataCache();
        LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{RuntimeMetadataPlugin.Util.getString("MSG.008.001.0003")});
    }

    public QueryMetadataInterface getQueryMetadata(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        QueryMetadataInterface qmi = this.getQueryMetadataCache().lookupMetadata(vdbID.getName(), vdbID.getVersion());
        if (qmi == null) {
            try {
                return this.getQueryMetadataCache().lookupMetadata(vdbID.getName(), vdbID.getVersion(), this.getVDBArchive(vdbID));
            }
            catch (Exception e) {
                throw new VirtualDatabaseException(e);
            }
        }
        return qmi;
    }

    public synchronized QueryMetadataCache getQueryMetadataCache() throws VirtualDatabaseException {
        try {
            if (this.cache == null) {
                this.cache = new QueryMetadataCache(this.getSystemVDBArchive());
            }
            return this.cache;
        }
        catch (Exception e) {
            throw new VirtualDatabaseException(e);
        }
    }

    private synchronized void refreshCache(VirtualDatabaseID vdbID) {
        try {
            this.removeFromCache(vdbID);
            this.getModels(vdbID);
            this.getQueryMetadata(vdbID);
        }
        catch (VirtualDatabaseException e) {
            LogManager.logError((String)"RUNTIME_METADATA", (String)RuntimeMetadataPlugin.Util.getString("ERR.008.001.0009", new Object[]{e, new Object[]{vdbID.getName()}}));
        }
    }

    private synchronized void removeFromCache(VirtualDatabaseID vdbID) {
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"VDB " + vdbID + " is being removed from cache"});
        try {
            this.getQueryMetadataCache().removeFromCache(vdbID.getName(), vdbID.getVersion());
        }
        catch (VirtualDatabaseException e) {
            LogManager.logError((String)"RUNTIME_METADATA", (Throwable)e, (String)RuntimeMetadataPlugin.Util.getString("Error trying to get QueryMetadataCache"));
        }
        this.removeFromMetadataCache(vdbID);
    }

    private synchronized void removeFromMetadataCache(VirtualDatabaseID vdbID) {
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"VDB " + vdbID + " is being removed from cache"});
        this.vdbMetadataCache.remove((Object)vdbID);
        this.vdbModelsCache.remove((Object)vdbID);
    }

    public synchronized void clearCache() throws VirtualDatabaseException {
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"VDB cache is being cleared"});
        this.vdbMetadataCache.clear();
        this.vdbModelsCache.clear();
        this.getQueryMetadataCache().clearCache();
    }

    private Properties getProperties(Properties runtimeProps) {
        Properties prop = new Properties();
        String value = runtimeProps.getProperty("metamatrix.metadata.runtime.persist");
        if (value != null) {
            this.persist = Boolean.valueOf(value);
        }
        if (value == null || this.persist) {
            prop.setProperty("metamatrix.common.connection.transaction.factory", JDBCConnectorFactory.class.getName());
        }
        prop.putAll((Map<?, ?>)runtimeProps);
        value = prop.getProperty("metamatrix.metadata.runtime.connection.Factory");
        if (value != null) {
            prop.setProperty("metamatrix.common.connection.transaction.factory", value);
        }
        return prop;
    }

    private static TransactionMgr getTransactionMgr(Properties props) throws VirtualDatabaseException {
        TransactionMgr aTransMgr = null;
        try {
            aTransMgr = new TransactionMgr(props, "RuntimeMetadata");
        }
        catch (ManagedConnectionException e) {
            throw new VirtualDatabaseException("ERR.008.001.0017", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0017"));
        }
        return aTransMgr;
    }

    protected void setTransactionManager(TransactionMgr transactionMgr) {
        this.transMgr = transactionMgr;
    }

    private UpdateController getUpdateController() {
        return this.controller;
    }

    private void fireEvent(VirtualDatabaseID vdbID, int type) {
        if (this.messageBus != null) {
            try {
                this.messageBus.processEvent(new RuntimeMetadataEvent(new RuntimeMetadataSource(), vdbID, type));
            }
            catch (Exception e) {
                LogManager.logError((String)"RUNTIME_METADATA", (Throwable)e, (String)RuntimeMetadataPlugin.Util.getString("ERR.008.000.0002"));
            }
        }
    }

    private MetaBaseConnector getReadTransaction() throws ManagedConnectionException {
        return (MetaBaseConnector)this.transMgr.getReadTransaction();
    }

    private MetadataSourceAPI loadVDB(VirtualDatabaseID vdbID, boolean includeMetadata) throws VirtualDatabaseException {
        MetadataCache mc = null;
        Object v = this.vdbMetadataCache.get((Object)vdbID);
        if (v != null) {
            mc = (MetadataCache)v;
            if (includeMetadata && !mc.isModelDetailsLoaded()) {
                mc.loadModelDetails();
            }
        } else {
            VirtualDatabase vdb = this.getVirtualDatabase(vdbID);
            Collection models = this.getModels(vdbID);
            byte[] vdbcontents = this.getVDBArchive(vdbID);
            mc = new MetadataCache();
            mc.init(vdb, models, includeMetadata, vdbcontents, this.systemModels.getModelMap());
            this.vdbMetadataCache.put((Object)vdbID, (Object)mc);
            LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"Creating MetadataCache for " + vdbID});
        }
        return mc;
    }

    private void loadSystemMetadataCache() throws VirtualDatabaseException {
        byte[] systemvdb = this.getSystemVDBArchive();
        MetadataCache mc = new MetadataCache();
        mc.initSystemVDB("System.vdb", "1", systemvdb);
        this.systemModels = mc;
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"Creating MetadataCache for systemVDB"});
    }

    private void processEvent(RuntimeMetadataEvent event) {
        if (event.getSource() == null) {
            if (event.refreshModels()) {
                VirtualDatabaseID vdbID = event.getVirtualDatabaseID();
                this.refreshCache(vdbID);
            } else if (event.deleteVDB()) {
                this.removeFromCache(event.getVirtualDatabaseID());
            } else if (event.clearCacheForVDB()) {
                this.removeFromMetadataCache(event.getVirtualDatabaseID());
            }
        }
    }

    private RuntimeMetadataCatalog() {
    }

    private static class RuntimeMetadataSource
    implements Serializable {
        private RuntimeMetadataSource() {
        }
    }

    private class VDBListener
    implements EventObjectListener {
        private final RuntimeMetadataListener vdblistener;

        public VDBListener(RuntimeMetadataListener listener) {
            this.vdblistener = listener;
        }

        public VDBListener() {
            this.vdblistener = null;
        }

        public void processEvent(EventObject obj) {
            if (obj instanceof RuntimeMetadataEvent) {
                if (this.vdblistener != null) {
                    this.vdblistener.processEvent((RuntimeMetadataEvent)obj);
                } else {
                    RuntimeMetadataCatalog.this.processEvent((RuntimeMetadataEvent)obj);
                }
            }
        }
    }
}

