/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.metadata.runtime.AbstractVDBDeleteUtility;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.platform.security.api.AuthorizationObjectEditor;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import java.util.Collection;

public class RuntimeVDBDeleteUtility
extends AbstractVDBDeleteUtility {
    private static final SessionToken fakeToken = new SessionToken();

    @Override
    public boolean checkSessions(VirtualDatabaseID vdbID, MetaMatrixSessionID sessionID) throws MetaMatrixComponentException {
        Collection sessionIDs = this.getSessionsLoggedInToVDB(vdbID.getName(), vdbID.getVersion());
        return sessionIDs.isEmpty() || sessionIDs.size() == 1 && sessionIDs.contains(sessionID);
    }

    @Override
    public boolean checkSessions(VirtualDatabaseID vdbID) throws MetaMatrixComponentException {
        Collection sessionIDs = this.getSessionsLoggedInToVDB(vdbID.getName(), vdbID.getVersion());
        return sessionIDs.isEmpty();
    }

    @Override
    public void deleteAuthorizationPoliciesForVDB(String VDBName, String VDBVersion) throws MetaMatrixComponentException {
        AuthorizationServiceInterface authProxy = this.getAuthorizationServiceProxy();
        AuthorizationRealm realm = new AuthorizationRealm(VDBName, VDBVersion);
        Collection policyIDs = null;
        try {
            policyIDs = authProxy.getPolicyIDsInRealm(fakeToken, realm);
        }
        catch (AuthorizationException e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.008.001.0029", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0029"));
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.008.001.0029", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0029"));
        }
        AuthorizationObjectEditor aoe = new AuthorizationObjectEditor();
        boolean hasRemoveActions = false;
        for (AuthorizationPolicyID aPolicyID : policyIDs) {
            aoe.remove(aPolicyID);
            hasRemoveActions = true;
        }
        if (!hasRemoveActions) {
            return;
        }
        try {
            authProxy.executeTransaction(fakeToken, aoe.getDestination().popActions());
            LogManager.logInfo((String)"RUNTIME_METADATA", (String)RuntimeMetadataPlugin.Util.getString("VDBDeleteUtility.2", new Object[]{VDBName, VDBVersion}));
        }
        catch (InvalidSessionException e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.008.001.0030", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0030", new Object[]{new Integer(policyIDs.size()), VDBName, VDBVersion}));
        }
        catch (AuthorizationException e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.008.001.0030", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0030", new Object[]{new Integer(policyIDs.size()), VDBName, VDBVersion}));
        }
        catch (Exception e) {
            throw new MetaMatrixComponentException((Throwable)e, "ERR.008.001.0030", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0030", new Object[]{new Integer(policyIDs.size()), VDBName, VDBVersion}));
        }
    }

    private AuthorizationServiceInterface getAuthorizationServiceProxy() throws ServiceException {
        return PlatformProxyHelper.getAuthorizationServiceProxy("ROUND_ROBIN_LOCAL");
    }
}

