/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.connection.TransactionMgr;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.metadata.runtime.AbstractVDBDeleteUtility;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.authorization.spi.AuthorizationSourceTransaction;
import java.util.Properties;

public class StartupVDBDeleteUtility
extends AbstractVDBDeleteUtility {
    @Override
    public boolean checkSessions(VirtualDatabaseID vdbID, MetaMatrixSessionID sessionID) throws MetaMatrixComponentException {
        return true;
    }

    @Override
    public boolean checkSessions(VirtualDatabaseID vdbID) throws MetaMatrixComponentException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAuthorizationPoliciesForVDB(String VDBName, String VDBVersion) throws MetaMatrixComponentException {
        Properties transactionProps = CurrentConfiguration.getInstance().getProperties();
        if (transactionProps.getProperty("security.authorization.connection.Factory") == null) {
            transactionProps.setProperty("security.authorization.connection.Factory", "com.metamatrix.platform.security.authorization.spi.jdbc.JDBCAuthorizationTransactionFactory");
        }
        transactionProps.setProperty("metamatrix.common.connection.transaction.factory", transactionProps.getProperty("security.authorization.connection.Factory"));
        AuthorizationSourceTransaction transaction = null;
        try {
            TransactionMgr transMgr = new TransactionMgr(transactionProps, "MetaMatrixController");
            transaction = (AuthorizationSourceTransaction)transMgr.getWriteTransaction();
            AuthorizationRealm realm = new AuthorizationRealm(VDBName, VDBVersion);
            transaction.removePrincipalsAndPoliciesForRealm(realm);
            transaction.commit();
        }
        catch (Exception e) {
            I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.001.0029", (Throwable)e, new Object[]{VDBName, VDBVersion});
            try {
                transaction.rollback();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Exception ex) {}
            }
            transaction = null;
        }
    }
}

