/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.tree.basic.BasicTreeNode;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.metadata.runtime.DataNodeCompare;
import com.metamatrix.metadata.runtime.ModelNodeComparator;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.Element;
import com.metamatrix.metadata.runtime.api.Group;
import com.metamatrix.metadata.runtime.api.GroupID;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.Procedure;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseMetadata;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.platform.admin.api.PermissionDataNodeDefinition;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeDefinitionImpl;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeImpl;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VDBTreeUtility {
    private VDBTreeUtility() {
    }

    public static final void buildDataNodeTree(BasicTreeNode fakeRoot, ObjectIDFactory idFactory, VirtualDatabaseMetadata vDBMetadata) throws VirtualDatabaseException {
        ArrayList models = new ArrayList(vDBMetadata.getDisplayableModels());
        AuthorizationActions modelAllowedActions = StandardAuthorizationActions.NONE;
        DataNodeCompare groupComparator = null;
        ModelNodeComparator modelComparator = null;
        if (models.size() > 0) {
            groupComparator = new DataNodeCompare();
            modelComparator = new ModelNodeComparator();
            Collections.sort(models, modelComparator);
        }
        for (Model model : models) {
            if (model == null) {
                String msg = RuntimeMetadataPlugin.Util.getString("ERR.008.001.0031", new Object[]{vDBMetadata.getVirtualDatabaseID()});
                VirtualDatabaseException e = new VirtualDatabaseException("ERR.008.001.0031", msg);
                LogManager.logError((String)"RUNTIME_METADATA", (Throwable)e, (String)msg);
                continue;
            }
            if (!model.isVisible()) continue;
            String resourceName = model.getFullName();
            AuthorizationActions allowedActions = StandardAuthorizationActions.NONE;
            ModelID modelID = (ModelID)model.getID();
            String name = model.getName();
            ObjectID id = idFactory.create();
            PermissionDataNodeDefinitionImpl nodeDef = new PermissionDataNodeDefinitionImpl(resourceName, name, 1);
            PermissionDataNodeImpl modelNode = new PermissionDataNodeImpl(fakeRoot, allowedActions, (PermissionDataNodeDefinition)nodeDef, model.isPhysical(), id);
            PermissionDataNodeImpl parentNode = null;
            HashMap catMap = new HashMap();
            Collection groups = null;
            groups = vDBMetadata.getGroupsInModel(modelID);
            ArrayList theGroups = new ArrayList(groups);
            Collections.sort(theGroups, groupComparator);
            String parentDocPath = null;
            List categories = null;
            for (Group group : theGroups) {
                if (group == null) {
                    LogManager.logError((String)"RUNTIME_METADATA", (String)RuntimeMetadataPlugin.Util.getString("ERR.008.001.0032", new Object[]{vDBMetadata.getVirtualDatabaseID(), model.getFullName()}));
                    continue;
                }
                categories = VDBTreeUtility.getCategories(modelID, (GroupID)group.getID());
                parentNode = VDBTreeUtility.buildCategoryNodes(catMap, categories, modelID.getFullName(), modelNode, idFactory);
                resourceName = group.getFullName();
                if (parentDocPath != null && resourceName.startsWith(parentDocPath)) continue;
                name = group.getName();
                boolean groupSupportsUpdate = group.supportsUpdate();
                id = idFactory.create();
                int type = group.isVirtualDocument() ? 6 : 3;
                nodeDef = new PermissionDataNodeDefinitionImpl(resourceName, name, type);
                allowedActions = groupSupportsUpdate && type != 6 ? StandardAuthorizationActions.ALL : StandardAuthorizationActions.DATA_READ;
                modelAllowedActions = StandardAuthorizationActions.getORedActions((AuthorizationActions)modelAllowedActions, (AuthorizationActions)allowedActions);
                PermissionDataNodeImpl groupNode = new PermissionDataNodeImpl((BasicTreeNode)parentNode, allowedActions, (PermissionDataNodeDefinition)nodeDef, group.isPhysical(), id);
                if (type == 6) {
                    parentDocPath = resourceName;
                    continue;
                }
                parentDocPath = null;
                List elements = null;
                elements = vDBMetadata.getElementsInGroup((GroupID)group.getID());
                if (elements == null) continue;
                for (Element element : elements) {
                    resourceName = element.getFullName();
                    name = element.getName();
                    id = idFactory.create();
                    nodeDef = new PermissionDataNodeDefinitionImpl(resourceName, name, 4);
                    allowedActions = groupSupportsUpdate && element.supportsUpdate() ? StandardAuthorizationActions.getAuthorizationActions((int)7) : StandardAuthorizationActions.DATA_READ;
                    modelAllowedActions = StandardAuthorizationActions.getORedActions((AuthorizationActions)modelAllowedActions, (AuthorizationActions)allowedActions);
                    new PermissionDataNodeImpl((BasicTreeNode)groupNode, allowedActions, (PermissionDataNodeDefinition)nodeDef, element.isPhysical(), id);
                }
            }
            Collection procedures = Collections.EMPTY_LIST;
            procedures = vDBMetadata.getProcedures(modelID);
            for (Procedure procedure : procedures) {
                resourceName = procedure.getFullName();
                StringBuffer sb = new StringBuffer();
                List nameComponents = procedure.getID().getNameComponents();
                for (int i = 1; i < nameComponents.size(); ++i) {
                    sb.append(nameComponents.get(i));
                    if (i >= nameComponents.size() - 1) continue;
                    sb.append(".");
                }
                name = procedure.getName();
                id = idFactory.create();
                nodeDef = new PermissionDataNodeDefinitionImpl(resourceName, sb.toString(), 5);
                allowedActions = StandardAuthorizationActions.DATA_READ;
                modelAllowedActions = StandardAuthorizationActions.getORedActions((AuthorizationActions)modelAllowedActions, (AuthorizationActions)allowedActions);
                new PermissionDataNodeImpl((BasicTreeNode)modelNode, allowedActions, (PermissionDataNodeDefinition)nodeDef, false, id);
            }
            modelNode.setAllowedActions(modelAllowedActions);
            modelAllowedActions = StandardAuthorizationActions.NONE;
        }
    }

    private static List getCategories(ModelID modelID, GroupID groupID) {
        int mcnt = modelID.getNameComponents().size();
        int gcnt = groupID.getNameComponents().size();
        if (gcnt > mcnt + 1) {
            List n = groupID.getNameComponents();
            ArrayList categories = new ArrayList(n.size());
            for (int i = mcnt; i < gcnt - 1; ++i) {
                categories.add(n.get(i));
            }
            return categories;
        }
        return Collections.EMPTY_LIST;
    }

    private static PermissionDataNodeImpl buildCategoryNodes(Map catMap, List categories, String parentName, PermissionDataNodeImpl parentNode, ObjectIDFactory idFactory) {
        AuthorizationActions allowedActions = StandardAuthorizationActions.NONE;
        PermissionDataNodeDefinitionImpl catnodeDef = null;
        PermissionDataNodeImpl catNode = null;
        String catName = null;
        if (categories != null && categories.size() > 0) {
            StringBuffer catNameBuf = new StringBuffer(parentName);
            for (String category : categories) {
                catNameBuf.append(".");
                catNameBuf.append(category);
                catName = catNameBuf.toString();
                if (catMap.containsKey(catName)) {
                    parentNode = (PermissionDataNodeImpl)catMap.get(catName);
                    continue;
                }
                catnodeDef = new PermissionDataNodeDefinitionImpl(catName, category, 2);
                catNode = new PermissionDataNodeImpl((BasicTreeNode)parentNode, allowedActions, (PermissionDataNodeDefinition)catnodeDef, false, idFactory.create());
                catMap.put(catName, catNode);
                parentNode = catNode;
            }
        }
        return parentNode;
    }
}

