/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.connector.metadata.IndexFile;
import com.metamatrix.connector.metadata.MultiObjectSource;
import com.metamatrix.connector.metadata.PropertyFileObjectSource;
import com.metamatrix.connector.metadata.internal.IObjectQuery;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.connector.metadata.internal.MetadataException;
import com.metamatrix.connector.metadata.internal.ObjectQueryProcessor;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.ElementID;
import com.metamatrix.metadata.runtime.api.GroupID;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.api.MetadataSourceAPI;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseDoesNotExistException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicElement;
import com.metamatrix.metadata.runtime.model.BasicElementID;
import com.metamatrix.metadata.runtime.model.BasicGroup;
import com.metamatrix.metadata.runtime.model.BasicGroupID;
import com.metamatrix.metadata.runtime.model.BasicModel;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.model.BasicProcedure;
import com.metamatrix.metadata.runtime.model.BasicProcedureID;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabase;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetadataCache
implements MetadataSourceAPI,
Serializable {
    private static final String GROUPS_NAME_IN_SOURCE = "TABLES.INDEX";
    private static final String[] GROUP_COLUMNS = new String[]{"UUID", "Name", "FullName", "TableType", "isPhysical", "supportsUpdate", "ModelName", "isSystem"};
    private static final String PROCEDURES_NAME_IN_SOURCE = "PROCEDURES.INDEX#E";
    private static final String[] PROCEDURE_COLUMNS = new String[]{"FullName"};
    private static final String COLUMNS_NAME_IN_SOURCE = "COLUMNS.INDEX";
    private static final String[] ELEMENT_COLUMNS = new String[]{"UUID", "FullName", "isUpdatable", "ParentFullName"};
    private VirtualDatabase vdb = null;
    private Map modelsFromDB = new HashMap();
    private Map resourceMap = null;
    private Map models = null;
    private Map groupToModelMap = new HashMap();
    private Map groupMap = new HashMap();
    private Map procToModelMap = null;
    private Map columnsToGroupMap = null;
    private boolean includeMetadata = false;

    public boolean isModelDetailsLoaded() {
        return this.includeMetadata;
    }

    public void initSystemVDB(String vdbName, String vdbVersion, byte[] systemvdb) throws VirtualDatabaseException {
        Map sys = new HashMap();
        this.includeMetadata = false;
        BasicVirtualDatabaseID vdbid = new BasicVirtualDatabaseID(vdbName, vdbVersion);
        BasicVirtualDatabase bvdb = new BasicVirtualDatabase(vdbid);
        bvdb.setFileName("System.vdb");
        this.vdb = bvdb;
        sys = this.loadModelsUsingVDBContext(this.vdb.getVirtualDatabaseID(), systemvdb);
        this.models = new HashMap(sys.size());
        this.models.putAll(sys);
        LogManager.logInfo((String)"com.metamatrix.metadata.runtime", (String)RuntimeMetadataPlugin.Util.getString("RuntimeMetadataCatalog.System_cache_initialized"));
    }

    public void init(String vdbName, String vdbVersion, String vdbFileName, byte[] vdbcontents) throws Exception {
        BasicVirtualDatabaseID vdbid = new BasicVirtualDatabaseID(vdbName, vdbVersion);
        BasicVirtualDatabase bvdb = new BasicVirtualDatabase(vdbid);
        bvdb.setFileName(vdbFileName);
        this.vdb = bvdb;
        this.init((VirtualDatabase)bvdb, Collections.EMPTY_LIST, false, vdbcontents, new HashMap(1));
    }

    public void init(VirtualDatabase vdb, Collection modelList, boolean loadMetadata, byte[] vdbcontents, Map systemModels) throws VirtualDatabaseException {
        ArgCheck.isNotNull((Object)vdb, (String)"VDB must be specified.");
        if (modelList == null) {
            modelList = Collections.EMPTY_LIST;
        }
        ArgCheck.isNotNull((Object)vdbcontents, (String)("VDB contents for " + vdb.getFullName() + " must be specified."));
        this.vdb = vdb;
        for (Model m : modelList) {
            this.modelsFromDB.put(m.getName(), m);
        }
        this.models = new HashMap();
        Map mVB = this.loadModelsUsingVDBContext(vdb.getVirtualDatabaseID(), vdbcontents);
        this.models.putAll(mVB);
        this.models.putAll(systemModels);
        if (loadMetadata) {
            this.includeMetadata = true;
            try {
                RuntimeMetadataCatalog.getInstance().getQueryMetadataCache().lookupMetadata(vdb.getVirtualDatabaseID().getFullName(), vdb.getVirtualDatabaseID().getVersion(), vdbcontents);
            }
            catch (MetaMatrixComponentException e) {
                throw new VirtualDatabaseException((Exception)((Object)e));
            }
            this.loadMetadata();
        }
        LogManager.logInfo((String)"com.metamatrix.metadata.runtime", (String)RuntimeMetadataPlugin.Util.getString("RuntimeMetadataCatalog.VDB_cache_initialized", new Object[]{vdb.getName()}));
    }

    public void loadModelDetails() throws VirtualDatabaseException {
        this.includeMetadata = true;
        this.loadMetadata();
    }

    private void loadMetadata() throws VirtualDatabaseException {
        this.groupToModelMap = new HashMap();
        this.groupMap = new HashMap();
        this.procToModelMap = new HashMap();
        this.columnsToGroupMap = new HashMap();
        try {
            this.buildGroupObjects((Iterator)this.getObjectQueryProcessor().process((IObjectQuery)new MetadataQuery(GROUP_COLUMNS, GROUPS_NAME_IN_SOURCE)));
            this.buildColumnObjects((Iterator)this.getObjectQueryProcessor().process((IObjectQuery)new MetadataQuery(ELEMENT_COLUMNS, COLUMNS_NAME_IN_SOURCE)));
            this.buildProcedureObjects((Iterator)this.getObjectQueryProcessor().process((IObjectQuery)new MetadataQuery(PROCEDURE_COLUMNS, PROCEDURES_NAME_IN_SOURCE)));
        }
        catch (MetadataException e) {
            throw new VirtualDatabaseException((Exception)((Object)e));
        }
    }

    protected ObjectQueryProcessor getObjectQueryProcessor() throws VirtualDatabaseException {
        VirtualDatabaseID vdbID = this.vdb.getVirtualDatabaseID();
        IndexSelector selector = RuntimeMetadataCatalog.getInstance().getQueryMetadataCache().getCompositeSelector(vdbID.getName(), vdbID.getVersion());
        IndexFile indexFile = new IndexFile(selector, vdbID.getName(), vdbID.getVersion(), null);
        MultiObjectSource multiObjectSource = new MultiObjectSource((IObjectSource)indexFile, ".properties", (IObjectSource)new PropertyFileObjectSource());
        return new ObjectQueryProcessor((IObjectSource)multiObjectSource);
    }

    private Map loadModelsUsingVDBContext(VirtualDatabaseID vdbID, byte[] vdbcontents) throws VirtualDatabaseException {
        HashMap<MetadataID, BasicModel> modelMap = new HashMap<MetadataID, BasicModel>();
        VDBArchive vdbArchive = null;
        try {
            BasicModel model;
            vdbArchive = new VDBArchive((InputStream)new ByteArrayInputStream(vdbcontents));
            if (vdbArchive.getVDBValidityErrors() != null) {
                throw new VirtualDatabaseException("3", RuntimeMetadataPlugin.Util.getString("MetadataCache.VDB_is_at_a_nondeployable_severity_state", new Object[]{vdbArchive.getName(), "ERROR"}));
            }
            Collection modelInfos = vdbArchive.getConfigurationDef().getModels();
            HashMap<String, BasicModel> resourceToModel = new HashMap<String, BasicModel>(modelInfos.size());
            for (BasicModelInfo modelInfo : modelInfos) {
                int modelType = modelInfo.getModelType();
                switch (modelType) {
                    case 0: 
                    case 1: 
                    case 10: {
                        if (this.modelsFromDB.containsKey(modelInfo.getName())) {
                            BasicModel dbmodel = (BasicModel)this.modelsFromDB.get(modelInfo.getName());
                            model = this.createBasicModel((BasicVirtualDatabaseID)vdbID, (ModelInfo)modelInfo, dbmodel);
                            resourceToModel.put(modelInfo.getPath(), model);
                            break;
                        }
                        model = this.createBasicModel((BasicVirtualDatabaseID)vdbID, (ModelInfo)modelInfo);
                        break;
                    }
                    default: {
                        model = this.createBasicModel((BasicVirtualDatabaseID)vdbID, (ModelInfo)modelInfo);
                    }
                }
                modelMap.put(model.getID(), model);
            }
            Set entriesInVDB = vdbArchive.getEntries();
            this.resourceMap = new HashMap(entriesInVDB.size());
            for (String entry : entriesInVDB) {
                boolean isVisible = false;
                model = (BasicModel)resourceToModel.get(entry);
                isVisible = model != null ? model.isVisible() : vdbArchive.isVisible(entry);
                String path = entry.startsWith("/") ? entry : "/" + entry;
                this.resourceMap.put(path, new Resource(path, isVisible));
            }
        }
        catch (VirtualDatabaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VirtualDatabaseException(e);
        }
        finally {
            if (vdbArchive != null) {
                vdbArchive.close();
            }
        }
        return modelMap;
    }

    public VirtualDatabase getVirtualDatabase() throws VirtualDatabaseException {
        return this.vdb;
    }

    public VirtualDatabaseID getVirtualDatabaseID() throws VirtualDatabaseDoesNotExistException, VirtualDatabaseException {
        return this.vdb.getVirtualDatabaseID();
    }

    public Collection getAllModels() throws VirtualDatabaseException {
        if (this.models != null) {
            ArrayList m = new ArrayList();
            m.addAll(this.models.values());
            return m;
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getDisplayableModels() throws VirtualDatabaseException {
        ArrayList<Object> result = new ArrayList<Object>(this.models.size());
        block3: for (ModelID id : this.models.keySet()) {
            Model m = (Model)this.models.get(id);
            switch (m.getModelType()) {
                case 0: 
                case 1: 
                case 10: {
                    if (this.modelsFromDB.containsKey(m.getName())) {
                        BasicModel dbModel = (BasicModel)this.modelsFromDB.get(m.getName());
                        if (!dbModel.isVisible()) continue block3;
                        result.add(dbModel);
                        break;
                    }
                    if (!m.isVisible()) break;
                    result.add(m);
                }
            }
        }
        return result;
    }

    public boolean isVisible(String resourcePath) {
        if (this.resourceMap == null) {
            return false;
        }
        Resource r = (Resource)this.resourceMap.get(resourcePath);
        if (r != null) {
            return r.isVisible();
        }
        return false;
    }

    public Map getModelMap() throws VirtualDatabaseException {
        HashMap modelMap = new HashMap(this.models.size());
        modelMap.putAll(this.models);
        return modelMap;
    }

    public Model getModel(ModelID modelID) throws VirtualDatabaseException {
        return (Model)this.models.get(modelID);
    }

    public Collection getModelsForVisibility(boolean isVisible) throws VirtualDatabaseException {
        ArrayList<Model> result = new ArrayList<Model>(this.models.size());
        for (Model m : this.models.keySet()) {
            if (m.isVisible() != isVisible) continue;
            result.add(m);
        }
        return result;
    }

    public Collection getGroupsInModel(ModelID modelID) throws VirtualDatabaseException {
        return this.getGroups(modelID);
    }

    public List getGroups(ModelID modelID) throws VirtualDatabaseException {
        if (this.groupToModelMap.containsKey(modelID)) {
            return (List)this.groupToModelMap.get(modelID);
        }
        return Collections.EMPTY_LIST;
    }

    public List getElementsInGroup(GroupID groupID) throws VirtualDatabaseException {
        return this.getColumns(groupID);
    }

    public List getColumns(GroupID groupID) throws VirtualDatabaseException {
        if (this.columnsToGroupMap.containsKey(groupID.getFullName())) {
            return (List)this.columnsToGroupMap.get(groupID.getFullName());
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getProceduresInModel(ModelID modelID) throws VirtualDatabaseException {
        return this.getProcedures(modelID);
    }

    public List getProcedures(ModelID modelID) throws VirtualDatabaseException {
        if (this.procToModelMap.containsKey(modelID)) {
            return (List)this.procToModelMap.get(modelID);
        }
        return Collections.EMPTY_LIST;
    }

    protected void buildGroupObjects(Iterator it) {
        boolean isPhysical = false;
        boolean supportsUpdates = false;
        String fullname = null;
        List groups = null;
        block3: while (it.hasNext()) {
            List cols = (List)it.next();
            fullname = (String)cols.get(2);
            Integer type = (Integer)cols.get(3);
            switch (type.shortValue()) {
                case 0: 
                case 1: 
                case 2: 
                case 5: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            isPhysical = (Boolean)cols.get(4);
            supportsUpdates = type.shortValue() == 5 || (Boolean)cols.get(5) != false;
            BasicGroupID gID = new BasicGroupID(fullname);
            BasicGroup group = new BasicGroup(gID, (BasicVirtualDatabaseID)this.vdb.getVirtualDatabaseID());
            group.setSupportsUpdate(supportsUpdates);
            group.setIsPhysical(isPhysical);
            group.setTableType(type.shortValue());
            groups = this.getGroupsInMap(gID.getModelID());
            groups.add(group);
            this.groupMap.put(gID.getFullName(), group);
        }
    }

    private List getGroupsInMap(ModelID modelID) {
        if (this.groupToModelMap.containsKey(modelID)) {
            return (List)this.groupToModelMap.get(modelID);
        }
        ArrayList groups = new ArrayList();
        this.groupToModelMap.put(modelID, groups);
        return groups;
    }

    private void buildColumnObjects(Iterator it) {
        String name = null;
        List columns = null;
        while (it.hasNext()) {
            List cols = (List)it.next();
            name = (String)cols.get(1);
            boolean supportsUpdates = (Boolean)cols.get(2);
            String parentPath = (String)cols.get(3);
            if (parentPath == null || parentPath.trim().length() <= 0 || !this.groupMap.containsKey(parentPath)) continue;
            BasicElementID elementID = new BasicElementID(name);
            elementID.setGroupFullName(parentPath);
            BasicElement element = new BasicElement((ElementID)elementID, (BasicVirtualDatabaseID)this.vdb.getVirtualDatabaseID());
            element.setSupportsUpdate(supportsUpdates);
            columns = this.getColumnsInMap(elementID.getParentFullName());
            columns.add(element);
        }
    }

    private List getColumnsInMap(String groupName) {
        if (this.columnsToGroupMap.containsKey(groupName)) {
            return (List)this.columnsToGroupMap.get(groupName);
        }
        ArrayList columns = new ArrayList();
        this.columnsToGroupMap.put(groupName, columns);
        return columns;
    }

    private void buildProcedureObjects(Iterator it) {
        String name = null;
        List procedures = null;
        while (it.hasNext()) {
            List cols = (List)it.next();
            name = (String)cols.get(0);
            BasicProcedureID procID = new BasicProcedureID(name);
            BasicProcedure procedure = new BasicProcedure(procID, (BasicVirtualDatabaseID)this.vdb.getVirtualDatabaseID());
            procedures = this.getProceduresInMap(procID.getModelID());
            procedures.add(procedure);
        }
    }

    private List getProceduresInMap(ModelID modelID) {
        if (this.procToModelMap.containsKey(modelID)) {
            return (List)this.procToModelMap.get(modelID);
        }
        ArrayList procs = new ArrayList();
        this.procToModelMap.put(modelID, procs);
        return procs;
    }

    BasicModel createBasicModel(BasicVirtualDatabaseID virtualDBID, ModelInfo modelInfo) {
        BasicModel result = new BasicModel(MetadataCache.createID(modelInfo), virtualDBID);
        result.setModelType(modelInfo.getModelType());
        result.setModelURI(modelInfo.getModelURI());
        result.setIsVisible(modelInfo.isVisible());
        String uuid = modelInfo.getUUID() == null ? "NoUUID" : modelInfo.getUUID();
        result.setGUID(uuid);
        result.setVersionDate(new Date());
        result.setVersionedBy("");
        return result;
    }

    BasicModel createBasicModel(BasicVirtualDatabaseID virtualDBID, ModelInfo modelInfo, BasicModel basicModel) {
        BasicModel result = new BasicModel(MetadataCache.createID(modelInfo), virtualDBID);
        result.setModelType(modelInfo.getModelType());
        result.setModelURI(modelInfo.getModelURI());
        result.setConnectorBindingNames((Collection)basicModel.getConnectorBindingNames());
        result.enableMutliSourceBindings(basicModel.isMultiSourceBindingEnabled());
        result.setDescription(basicModel.getDescription());
        result.setIsVisible(basicModel.isVisible());
        String uuid = modelInfo.getUUID() == null ? "NoUUID" : modelInfo.getUUID();
        result.setGUID(uuid);
        result.setVersionDate(basicModel.getDateVersioned());
        result.setVersionedBy(basicModel.getVersionedBy());
        return result;
    }

    private static BasicModelID createID(ModelInfo modelInfo) {
        String v = modelInfo.getVersion() == null ? "0" : modelInfo.getVersion();
        BasicModelID modelID = new BasicModelID(modelInfo.getName(), v);
        String uuid = modelInfo.getUUID() == null ? "NoUUID" : modelInfo.getUUID();
        modelID.setUuid(uuid);
        return modelID;
    }

    private class Resource
    implements Serializable {
        private String path = null;
        private boolean isVisible = false;

        public Resource(String resourcePath, boolean visible) {
            this.path = resourcePath;
            this.isVisible = visible;
        }

        public String getResourcePath() {
            return this.path;
        }

        public boolean isVisible() {
            return this.isVisible;
        }
    }

    private static class MetadataQuery
    implements IObjectQuery,
    Serializable {
        private String[] columnNames;
        private String tableNameInSource;
        private Map criteria = new HashMap();

        public MetadataQuery(String[] columnNames, String tableNameInSource) {
            this.columnNames = columnNames;
            this.tableNameInSource = tableNameInSource;
        }

        public void checkCaseType(int i, Object value) {
        }

        public void checkType(int i, Object value) {
        }

        public Integer getCaseType(int i) {
            return NO_CASE;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public Map getCriteria() throws MetadataException {
            return this.criteria;
        }

        public String getTableNameInSource() throws MetadataException {
            return this.tableNameInSource;
        }
    }
}

