/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.TransactionMgr;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.InvalidExtensionModuleTypeException;
import com.metamatrix.common.id.dbid.DBIDGenerator;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.InvalidStateException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicModel;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabase;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import com.metamatrix.metadata.runtime.spi.MetaBaseConnector;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdateController {
    public static final String FIRST_VERSION = "1";
    private TransactionMgr transMgr;

    public UpdateController(TransactionMgr transactionMgr) {
        this.transMgr = transactionMgr;
    }

    public synchronized void setVBDStatus(VirtualDatabaseID virtualID, short status, String userName) throws InvalidStateException, VirtualDatabaseException {
        this.setVDBStatus(virtualID, status, userName, false);
    }

    private void setVDBStatus(VirtualDatabaseID virtualID, short status, String userName, boolean checkCompletion) throws InvalidStateException, VirtualDatabaseException {
        MetaBaseConnector conn = null;
        try {
            conn = this.getReadTransaction();
            VirtualDatabase vdb = conn.getVirtualDatabase(virtualID);
            if (vdb.getStatus() == 1 && status != 4 && checkCompletion) {
                throw new InvalidStateException("ERR.008.005.0070", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0070"));
            }
        }
        catch (ManagedConnectionException e) {
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.005.0071", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0071"));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0001", e2);
                }
            }
        }
        try {
            conn = this.getWriteTransaction();
            conn.setStatus(virtualID, status, userName);
            conn.commit();
        }
        catch (ManagedConnectionException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0006", e2);
            }
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.005.0071", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0071"));
        }
        catch (VirtualDatabaseException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0006", e2);
            }
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e3) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0001", e3);
                }
            }
        }
    }

    public synchronized void deleteVirtualDatabase(VirtualDatabaseID vdbID) throws InvalidStateException, VirtualDatabaseException {
        MetaBaseConnector conn = null;
        VirtualDatabase vdb = null;
        try {
            conn = this.getWriteTransaction();
            vdb = conn.getVirtualDatabase(vdbID);
            Collection vdbs = conn.getDeletedVirtualDatabaseIDs();
            if (!vdbs.contains(vdbID)) {
                throw new InvalidStateException("ERR.008.005.0074", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0074", new Object[]{vdbID}));
            }
            conn.deleteVirtualDatabase(vdbID);
            conn.commit();
        }
        catch (ManagedConnectionException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0006", e2);
            }
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.005.0075", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0075"));
        }
        catch (VirtualDatabaseException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0006", e2);
            }
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e3) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0001", e3);
                }
            }
        }
        if (vdb != null) {
            ExtensionModuleManager extension = ExtensionModuleManager.getInstance();
            try {
                extension.removeSource("RuntimeMetadata", vdb.getFileName());
            }
            catch (MetaMatrixComponentException e1) {
                throw new VirtualDatabaseException((Exception)((Object)e1));
            }
            catch (ExtensionModuleNotFoundException e) {
                throw new VirtualDatabaseException((Exception)((Object)e));
            }
        }
    }

    public void setConnectorBindingNames(VirtualDatabaseID vdbID, Map modelAndCBNames, String userName) throws VirtualDatabaseException {
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"Setting connector binding names for", vdbID});
        MetaBaseConnector conn = null;
        boolean isCompleteSet = true;
        Collection models = RuntimeMetadataCatalog.getInstance().getModels(vdbID);
        Set modelIDs = modelAndCBNames.keySet();
        Collection cbNames = modelAndCBNames.values();
        for (List mmuuid : cbNames) {
            if (mmuuid.size() != 0) continue;
            isCompleteSet = false;
        }
        for (Model model : models) {
            ModelID modelID;
            if (!model.isPhysical() || !model.requireConnectorBinding() || modelIDs.contains(modelID = (ModelID)model.getID())) continue;
            isCompleteSet = false;
            modelAndCBNames.put(modelID, null);
        }
        try {
            conn = this.getWriteTransaction();
            conn.setConnectorBindingNames(vdbID, models, modelAndCBNames);
            conn.commit();
            if (isCompleteSet) {
                this.setVDBStatus(vdbID, (short)2, userName, false);
            } else {
                this.setVDBStatus(vdbID, (short)1, userName, false);
            }
        }
        catch (ManagedConnectionException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0006", e2);
            }
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.005.0078", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0078"));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0001", e2);
                }
            }
        }
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"End setting connector binding names for", vdbID});
    }

    public void updateVirtualDatabase(VirtualDatabase vdb, String userName) throws VirtualDatabaseException {
        MetaBaseConnector conn = null;
        try {
            conn = this.getReadTransaction();
            conn.updateVirtualDatabase(vdb, userName);
            conn.commit();
        }
        catch (ManagedConnectionException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0006", e2);
            }
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.005.0079", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0079"));
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0001", e2);
                }
            }
        }
    }

    protected MetaBaseConnector getReadTransaction() throws ManagedConnectionException {
        return (MetaBaseConnector)this.transMgr.getReadTransaction();
    }

    protected MetaBaseConnector getWriteTransaction() throws ManagedConnectionException {
        return (MetaBaseConnector)this.transMgr.getWriteTransaction();
    }

    protected BasicVirtualDatabase buildVirtualDatabaseObject(VDBArchive vdbArchive, String userName, boolean inMemory) throws VirtualDatabaseException {
        String createdBy = userName;
        Date creationDate = new Date();
        String vdbVersion = FIRST_VERSION;
        BasicVDBDefn vdbInfo = vdbArchive.getConfigurationDef();
        BasicVirtualDatabaseID vdbID = null;
        try {
            vdbID = (BasicVirtualDatabaseID)this.getReadTransaction().getVirtualDatabaseID(vdbInfo.getName(), null);
            if (vdbID != null) {
                vdbVersion = Integer.toString(Integer.parseInt(vdbID.getVersion()) + 1);
                VirtualDatabase latestVdb = RuntimeMetadataCatalog.getInstance().getVirtualDatabase((VirtualDatabaseID)vdbID);
                createdBy = latestVdb.getCreatedBy();
                creationDate = latestVdb.getCreationDate();
            }
        }
        catch (Throwable e4) {
            // empty catch block
        }
        vdbID = new BasicVirtualDatabaseID(vdbInfo.getName(), vdbVersion);
        String fileName = vdbInfo.getName().trim() + "_" + vdbVersion.trim() + ".vdb";
        ExtensionModuleManager extension = ExtensionModuleManager.getInstance();
        try {
            if (extension.isSourceInUse(fileName)) {
                throw new VirtualDatabaseException(RuntimeMetadataPlugin.Util.getString("UpdateController.VDB_File_already_exist_in_extension_modules_25", new Object[]{fileName}));
            }
        }
        catch (MetaMatrixComponentException e1) {
            throw new VirtualDatabaseException((Exception)((Object)e1));
        }
        long id = this.createVirtualDatabaseID();
        String vdbUUID = vdbInfo.getUUID();
        String description = vdbInfo.getDescription();
        vdbID.setUID(id);
        BasicVirtualDatabase vdb = new BasicVirtualDatabase(vdbID);
        vdb.setDescription(description);
        vdb.setGUID(vdbUUID);
        vdb.setStatus((short)1);
        vdb.setVersionBy(userName);
        vdb.setVersionDate(new Date());
        vdb.setCreatedBy(createdBy);
        vdb.setCreationDate(creationDate);
        vdb.setUpdatedBy(userName);
        vdb.setUpdateDate(new Date());
        vdb.setFileName(fileName);
        vdb.setHasWSDLDefined(vdbInfo.hasWSDLDefined());
        return vdb;
    }

    protected long createVirtualDatabaseID() throws VirtualDatabaseException {
        long id = 0L;
        try {
            id = DBIDGenerator.getInstance().getID("VirtualDatabases");
        }
        catch (DBIDGeneratorException e) {
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.000.0004", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0004"));
        }
        return id;
    }

    public VirtualDatabase createVirtualDatabase(VDBArchive vdbArchive, String userName) throws VirtualDatabaseException {
        BasicVirtualDatabase vdb = this.buildVirtualDatabaseObject(vdbArchive, userName, false);
        BasicVirtualDatabaseID vdbID = (BasicVirtualDatabaseID)vdb.getVirtualDatabaseID();
        BasicVDBDefn vdbInfo = vdbArchive.getConfigurationDef();
        HashSet<BasicModel> vdbModels = new HashSet<BasicModel>();
        for (ModelInfo mInfo : vdbInfo.getModels()) {
            BasicModelID modelID = new BasicModelID(mInfo.getName(), mInfo.getVersion(), this.getNextModelUid());
            Date versionDate = mInfo.getDateVersioned() != null ? mInfo.getDateVersioned() : new Date();
            modelID.setVersionDate(DateUtil.getDateAsString((Date)versionDate));
            modelID.setUuid(mInfo.getUUID());
            BasicModel model = new BasicModel(modelID, vdbID, mInfo);
            vdbModels.add(model);
            vdb.addModelID((ModelID)modelID);
        }
        HashSet<BasicVirtualDatabase> vdbs = new HashSet<BasicVirtualDatabase>(1);
        vdbs.add(vdb);
        MetaBaseConnector conn = null;
        try {
            conn = this.getWriteTransaction();
            conn.insertVirtualDatabase((VirtualDatabase)vdb);
            conn.insertModels(vdbModels, (VirtualDatabaseID)vdbID);
            conn.commit();
        }
        catch (ManagedConnectionException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0006", e2);
            }
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.005.0068", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0068"));
        }
        catch (VirtualDatabaseException e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (Exception e2) {
                I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0006", e2);
            }
            throw e;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e3) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0001", e3);
                }
            }
        }
        try {
            ExtensionModuleManager extension = ExtensionModuleManager.getInstance();
            extension.addSource(userName, "VDB File", vdb.getFileName(), VDBArchive.writeToByteArray((VDBArchive)vdbArchive), vdbInfo.getDescription(), true);
        }
        catch (MetaMatrixComponentException e1) {
            throw new VirtualDatabaseException((Exception)((Object)e1));
        }
        catch (DuplicateExtensionModuleException e1) {
            throw new VirtualDatabaseException((Exception)((Object)e1));
        }
        catch (InvalidExtensionModuleTypeException e1) {
            throw new VirtualDatabaseException((Exception)((Object)e1));
        }
        I18nLogManager.logInfo("RUNTIME_METADATA", "MSG.008.005.0003", new Object[]{vdb});
        return vdb;
    }

    public byte[] getVDBArchive(String fileName) throws VirtualDatabaseException {
        byte[] archive = null;
        ExtensionModuleManager extension = ExtensionModuleManager.getInstance();
        try {
            if (extension.isSourceInUse(fileName)) {
                archive = extension.getSource(fileName);
            } else {
                try {
                    InputStream in = ClassLoader.getSystemResourceAsStream(fileName);
                    if (in != null) {
                        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(102400);
                        FileUtils.write((InputStream)in, (OutputStream)byteStream, (int)10240);
                        archive = byteStream.toByteArray();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (archive == null) {
                throw new VirtualDatabaseException(RuntimeMetadataPlugin.Util.getString("UpdateController.VDB_File_does_not_exist_in_extension_modules_1", new Object[]{fileName}));
            }
        }
        catch (ExtensionModuleNotFoundException e) {
            throw new VirtualDatabaseException((Exception)((Object)e));
        }
        catch (VirtualDatabaseException e) {
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            throw new VirtualDatabaseException((Exception)((Object)e));
        }
        return archive;
    }

    private long getNextModelUid() throws VirtualDatabaseException {
        long uid = 0L;
        try {
            uid = DBIDGenerator.getInstance().getID("model");
        }
        catch (DBIDGeneratorException e) {
            throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.000.0004", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0004"));
        }
        return uid;
    }
}

