/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.spi.jdbc;

import com.metamatrix.common.connection.BaseTransaction;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.jdbc.JDBCMgdResourceConnection;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.InvalidStateException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseDoesNotExistException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicModel;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import com.metamatrix.metadata.runtime.spi.MetaBaseConnector;
import com.metamatrix.metadata.runtime.spi.jdbc.JDBCRuntimeMetadataReader;
import com.metamatrix.metadata.runtime.spi.jdbc.JDBCRuntimeMetadataWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class JDBCConnector
extends BaseTransaction
implements MetaBaseConnector {
    private static String IS_TRUE = "1";
    private static String IS_FALSE = "0";
    private Connection jdbcConnection;
    private JDBCPlatform platform;

    JDBCConnector(ManagedConnection connection, boolean readonly) throws ManagedConnectionException {
        super(connection, readonly);
        try {
            JDBCMgdResourceConnection jdbcManagedConnection = (JDBCMgdResourceConnection)connection;
            this.jdbcConnection = jdbcManagedConnection.getConnection();
            this.platform = JDBCPlatformFactory.getPlatform(this.jdbcConnection);
        }
        catch (Exception e) {
            throw new ManagedConnectionException("ERR.008.006.0002", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0002", new Object[]{JDBCMgdResourceConnection.class.getName()}));
        }
        JDBCRuntimeMetadataReader.setJDBCPlatform(this.platform);
    }

    @Override
    public VirtualDatabase getVirtualDatabase(VirtualDatabaseID virtualDatabaseID) throws VirtualDatabaseException {
        return JDBCRuntimeMetadataReader.getVirtualDatabase(virtualDatabaseID, this.jdbcConnection);
    }

    @Override
    public VirtualDatabaseID getVirtualDatabaseID(String fullName, String version) throws VirtualDatabaseDoesNotExistException, VirtualDatabaseException {
        return this.getVirtualDatabaseID(fullName, version, false);
    }

    @Override
    public Collection getVirtualDatabases() throws VirtualDatabaseException {
        return JDBCRuntimeMetadataReader.getVirtualDatabases(this.jdbcConnection);
    }

    @Override
    public Collection getDeletedVirtualDatabaseIDs() throws VirtualDatabaseException {
        return JDBCRuntimeMetadataReader.getDeletedVirtualDatabaseIDs(this.jdbcConnection);
    }

    @Override
    public Collection getModels(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        return JDBCRuntimeMetadataReader.getModels(vdbID, this.jdbcConnection);
    }

    @Override
    public VirtualDatabaseID getActiveVirtualDatabaseID(String vdbName, String vdbVersion) throws VirtualDatabaseException, VirtualDatabaseDoesNotExistException {
        return this.getVirtualDatabaseID(vdbName, vdbVersion, true);
    }

    public Collection getModelIDsOnlyInVDB(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        return JDBCRuntimeMetadataReader.getModelIDsOnlyInVDB(vdbID, this.jdbcConnection);
    }

    @Override
    public void setStatus(VirtualDatabaseID virtualDBID, short status, String userName) throws InvalidStateException, VirtualDatabaseException {
        VirtualDatabase vdb = this.getVirtualDatabase(virtualDBID);
        if (status == vdb.getStatus()) {
            return;
        }
        if (vdb.getStatus() == 4) {
            throw new InvalidStateException("ERR.008.006.0008", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0008", new Object[]{virtualDBID}));
        }
        long uid = ((BasicVirtualDatabaseID)vdb.getVirtualDatabaseID()).getUID();
        JDBCRuntimeMetadataWriter.setStatus(virtualDBID, uid, status, userName, this.jdbcConnection);
    }

    @Override
    public void insertModels(Collection metadataObjects, VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        PreparedStatement statement = null;
        String sql = null;
        BasicModel model = null;
        Iterator iter = metadataObjects.iterator();
        try {
            sql = "INSERT  INTO RT_MDLS(MDL_UID,MDL_NM,MDL_VERSION,DESCRIPTION,IS_PHYSICAL,MULTI_SOURCED,VISIBILITY,MDL_UUID,MDL_TYPE,MDL_URI) VALUES (?,?,?,?,?,?,?,?,?,?)";
            statement = this.jdbcConnection.prepareStatement(sql);
            while (iter.hasNext()) {
                statement.clearParameters();
                model = (BasicModel)iter.next();
                BasicModelID modelID = (BasicModelID)model.getID();
                statement.setLong(1, modelID.getUID());
                statement.setString(2, model.getName());
                statement.setString(3, ((ModelID)model.getID()).getVersion());
                statement.setString(4, this.adjustLengthToFit(model.getDescription()));
                statement.setString(5, model.isPhysical() ? IS_TRUE : IS_FALSE);
                statement.setString(6, model.isMultiSourceBindingEnabled() ? IS_TRUE : IS_FALSE);
                statement.setShort(7, model.getVisibility());
                statement.setString(8, ((BasicModelID)model.getID()).getUuid());
                statement.setInt(9, model.getModelType());
                statement.setString(10, model.getModelURI());
                if (statement.executeUpdate() != 1) {
                    throw new VirtualDatabaseException("ERR.008.006.0009", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0009"));
                }
                LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"Inserted Model with DBID ", new Long(modelID.getUID())});
            }
            this.insertVDBModels(metadataObjects, vdbID);
        }
        catch (SQLException se) {
            BasicModelID modelID = (BasicModelID)model.getID();
            sql = StringUtil.replace((String)sql, (String)"?", (String)Long.toString(modelID.getUID()));
            sql = StringUtil.replace((String)sql, (String)"?", (String)model.getName());
            sql = StringUtil.replace((String)sql, (String)"?", (String)((ModelID)model.getID()).getVersion());
            sql = StringUtil.replace((String)sql, (String)"?", (String)(this.adjustLengthToFit(model.getDescription()) == null ? "NULL" : this.adjustLengthToFit(model.getDescription())));
            sql = StringUtil.replace((String)sql, (String)"?", (String)(model.isPhysical() ? IS_TRUE : IS_FALSE));
            sql = StringUtil.replace((String)sql, (String)"?", (String)(model.isMultiSourceBindingEnabled() ? IS_TRUE : IS_FALSE));
            sql = StringUtil.replace((String)sql, (String)"?", (String)(model.isVisible() ? IS_TRUE : IS_FALSE));
            sql = StringUtil.replace((String)sql, (String)"?", (String)((BasicModelID)model.getID()).getUuid());
            sql = StringUtil.replace((String)sql, (String)"?", (String)Integer.toString(model.getModelType()));
            sql = StringUtil.replace((String)sql, (String)"?", (String)model.getModelURI());
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0003", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }

    @Override
    public void insertVirtualDatabase(VirtualDatabase vdb) throws VirtualDatabaseException {
        PreparedStatement statement = null;
        String sql = null;
        try {
            sql = "INSERT  INTO RT_VIRTUAL_DBS(VDB_UID,VDB_VERSION,VDB_NM,DESCRIPTION,PROJECT_GUID,VDB_STATUS,WSDL_DEFINED,VERSION_BY,VERSION_DATE,CREATED_BY,CREATION_DATE,UPDATED_BY,UPDATED_DATE,VDB_FILE_NM) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setLong(1, ((BasicVirtualDatabaseID)vdb.getID()).getUID());
            statement.setString(2, ((VirtualDatabaseID)vdb.getID()).getVersion());
            statement.setString(3, vdb.getName());
            statement.setString(4, this.adjustLengthToFit(vdb.getDescription()));
            statement.setString(5, vdb.getGUID());
            statement.setShort(6, vdb.getStatus());
            statement.setString(7, vdb.hasWSDLDefined() ? IS_TRUE : IS_FALSE);
            statement.setString(8, vdb.getVersionBy());
            statement.setString(9, DateUtil.getDateAsString((Date)vdb.getVersionDate()));
            statement.setString(10, vdb.getCreatedBy());
            statement.setString(11, DateUtil.getDateAsString((Date)vdb.getCreationDate()));
            statement.setString(12, vdb.getUpdatedBy());
            statement.setString(13, DateUtil.getDateAsString((Date)vdb.getUpdateDate()));
            statement.setString(14, vdb.getFileName());
            if (statement.executeUpdate() != 1) {
                throw new VirtualDatabaseException("ERR.008.006.0023", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0023", new Object[]{vdb.getName()}));
            }
            LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"Inserted VirtualDatabase with DBID ", new Long(((BasicVirtualDatabaseID)vdb.getID()).getUID())});
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0003", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }

    private void insertVDBModels(Collection models, VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        JDBCRuntimeMetadataWriter.insertVDBModels(models, vdbID, this.jdbcConnection);
    }

    @Override
    public void deleteVirtualDatabase(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        this.getModels(vdbID);
        Collection modelIDsToBeDeleted = this.getModelIDsOnlyInVDB(vdbID);
        Statement statement = null;
        String sql = null;
        long vdbUID = ((BasicVirtualDatabaseID)vdbID).getUID();
        try {
            Iterator iter = modelIDsToBeDeleted.iterator();
            sql = "DELETE  FROM RT_VDB_MDLS WHERE VDB_UID=?";
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setLong(1, vdbUID);
            this.executeStatement((PreparedStatement)statement);
            statement.close();
            iter = modelIDsToBeDeleted.iterator();
            while (iter.hasNext()) {
                long uid = ((BasicModelID)iter.next()).getUID();
                sql = "DELETE  FROM RT_MDL_PRP_VLS WHERE PRP_UID IN (SELECT PRP_UID FROM RT_MDL_PRP_NMS WHERE MDL_UID=?)";
                statement = this.jdbcConnection.prepareStatement(sql);
                statement.setLong(1, uid);
                this.executeStatement((PreparedStatement)statement);
                statement.close();
                sql = "DELETE  FROM RT_MDL_PRP_NMS WHERE MDL_UID=?";
                statement = this.jdbcConnection.prepareStatement(sql);
                statement.setLong(1, uid);
                this.executeStatement((PreparedStatement)statement);
                statement.close();
                sql = "DELETE  FROM RT_MDLS WHERE MDL_UID=?";
                statement = this.jdbcConnection.prepareStatement(sql);
                statement.setLong(1, uid);
                this.executeStatement((PreparedStatement)statement);
                statement.close();
            }
            sql = "DELETE  FROM RT_VIRTUAL_DBS WHERE VDB_UID=?";
            statement = this.jdbcConnection.prepareStatement(sql);
            statement.setLong(1, vdbUID);
            this.executeStatement((PreparedStatement)statement);
            statement.close();
            statement = null;
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0003", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }

    @Override
    public void setConnectorBindingNames(VirtualDatabaseID vdbID, Collection models, Map modelAndCBNames) throws VirtualDatabaseException {
        JDBCRuntimeMetadataWriter.setConnectorBindingNames(vdbID, models, modelAndCBNames, this.jdbcConnection);
    }

    @Override
    public void updateVirtualDatabase(VirtualDatabase vdb, String userName) throws VirtualDatabaseException {
        JDBCRuntimeMetadataWriter.updateVirtualDatabase(vdb, userName, this.jdbcConnection);
    }

    private VirtualDatabaseID getVirtualDatabaseID(String fullName, String version, boolean isActive) throws VirtualDatabaseDoesNotExistException, VirtualDatabaseException {
        return JDBCRuntimeMetadataReader.getVirtualDatabaseID(fullName, version, isActive, this.jdbcConnection);
    }

    private void executeStatement(PreparedStatement statement) throws SQLException {
        int lines = statement.executeUpdate();
        try {
            statement.close();
        }
        catch (SQLException e) {
            I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
        }
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"" + lines + " rows deleted."});
    }

    private String adjustLengthToFit(String oriString) {
        if (oriString != null && oriString.length() > 255) {
            oriString = oriString.substring(0, 255);
        }
        return oriString;
    }
}

