/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.spi.jdbc;

import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.CorePlugin;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseDoesNotExistException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicMetadataID;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import com.metamatrix.metadata.runtime.spi.jdbc.JDBCTranslator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public final class JDBCRuntimeMetadataReader {
    private static JDBCPlatform platform;

    public static void setJDBCPlatform(JDBCPlatform jdbcPlatform) {
        platform = jdbcPlatform;
    }

    public static VirtualDatabase getVirtualDatabase(VirtualDatabaseID virtualDatabaseID, Connection jdbcConnection) throws VirtualDatabaseException {
        Statement statement = null;
        String sql = null;
        VirtualDatabase result = null;
        try {
            long uid = ((BasicVirtualDatabaseID)virtualDatabaseID).getUID();
            sql = "SELECT DESCRIPTION,PROJECT_GUID,VDB_STATUS,WSDL_DEFINED,VERSION_BY,VERSION_DATE,CREATED_BY,CREATION_DATE,UPDATED_BY,UPDATED_DATE,VDB_FILE_NM FROM RT_VIRTUAL_DBS WHERE VDB_UID=?";
            LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{"MSG.008.006.0004", new Object[]{virtualDatabaseID.getFullName(), virtualDatabaseID.getVersion(), new Long(uid)}});
            statement = jdbcConnection.prepareStatement(sql);
            statement.setLong(1, uid);
            if (!statement.execute()) {
                throw new VirtualDatabaseException("ERR.008.000.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0007", new Object[]{sql}));
            }
            ResultSet results = statement.getResultSet();
            if (results.next()) {
                result = JDBCTranslator.getVirtualDatabase(results, virtualDatabaseID);
            }
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LogManager.logDetail((String)"RUNTIME_METADATA", (Throwable)e, (String)CorePlugin.Util.getString("ERR.008.000.0008"));
                }
            }
        }
        return result;
    }

    public static VirtualDatabaseID getVirtualDatabaseID(String fullName, String version, Connection jdbcConnection) throws VirtualDatabaseDoesNotExistException, VirtualDatabaseException {
        return JDBCRuntimeMetadataReader.getVirtualDatabaseID(fullName, version, false, jdbcConnection);
    }

    public static Collection getVirtualDatabases(Connection jdbcConnection) throws VirtualDatabaseException {
        Statement statement = null;
        String sql = null;
        Collection result = null;
        try {
            sql = "SELECT VDB_NM,VDB_VERSION,VDB_UID,DESCRIPTION,PROJECT_GUID,VDB_STATUS,WSDL_DEFINED,VERSION_BY,VERSION_DATE,CREATED_BY,CREATION_DATE,UPDATED_BY,UPDATED_DATE,VDB_FILE_NM FROM RT_VIRTUAL_DBS";
            statement = jdbcConnection.createStatement();
            if (!statement.execute(sql)) {
                throw new VirtualDatabaseException("ERR.008.000.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0007", new Object[]{sql}));
            }
            ResultSet results = statement.getResultSet();
            result = JDBCTranslator.getVirtualDatabases(results);
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
        return result;
    }

    public static Collection getDeletedVirtualDatabaseIDs(Connection jdbcConnection) throws VirtualDatabaseException {
        Statement statement = null;
        String sql = null;
        Collection result = null;
        try {
            sql = "SELECT VDB_NM,VDB_VERSION,VDB_UID FROM RT_VIRTUAL_DBS WHERE VDB_STATUS=4";
            statement = jdbcConnection.createStatement();
            if (!statement.execute(sql)) {
                throw new VirtualDatabaseException("ERR.008.000.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0007", new Object[]{sql}));
            }
            ResultSet results = statement.getResultSet();
            result = JDBCTranslator.getVirtualDatabaseIDs(results);
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
        return result;
    }

    public static Collection getModels(VirtualDatabaseID vdbID, Connection jdbcConnection) throws VirtualDatabaseException {
        PreparedStatement statement = null;
        String sql = null;
        Collection result = null;
        long uid = ((BasicVirtualDatabaseID)vdbID).getUID();
        Collection smUids = null;
        try {
            sql = "SELECT RT_VDB_MDLS.MDL_UID,MDL_NM,MDL_VERSION,MDL_UUID,MDL_TYPE,MDL_URI,DESCRIPTION,IS_PHYSICAL,MULTI_SOURCED,VISIBILITY,CNCTR_BNDNG_NM FROM RT_MDLS,RT_VDB_MDLS WHERE RT_VDB_MDLS.MDL_UID=RT_MDLS.MDL_UID AND VDB_UID=? ORDER BY MDL_NM";
            statement = jdbcConnection.prepareStatement(sql);
            statement.setLong(1, uid);
            if (!statement.execute()) {
                throw new VirtualDatabaseException("ERR.008.000.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0007", new Object[]{sql}));
            }
            ResultSet results = statement.getResultSet();
            result = JDBCTranslator.getModels(results, vdbID, smUids);
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
        return result;
    }

    public static VirtualDatabaseID getActiveVirtualDatabaseID(String vdbName, String vdbVersion, Connection jdbcConnection) throws VirtualDatabaseException, VirtualDatabaseDoesNotExistException {
        return JDBCRuntimeMetadataReader.getVirtualDatabaseID(vdbName, vdbVersion, true, jdbcConnection);
    }

    public static Properties getProperties(MetadataID metadataID, Connection jdbcConnection) throws VirtualDatabaseException {
        Statement statement = null;
        String sql = null;
        Properties result = null;
        try {
            sql = JDBCTranslator.getPropertyQuery(metadataID, 1);
            if (sql == null) {
                Properties properties = result;
                return properties;
            }
            statement = jdbcConnection.prepareStatement(sql);
            statement.setLong(1, ((BasicMetadataID)metadataID).getUID());
            if (!statement.execute()) {
                throw new VirtualDatabaseException("ERR.008.000.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0007", new Object[]{sql}));
            }
            ResultSet results = statement.getResultSet();
            result = JDBCTranslator.getProperties(results);
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
        return result;
    }

    public static List getAllModelIDs(Connection jdbcConnection) throws VirtualDatabaseException {
        Statement statement = null;
        String sql = null;
        List result = null;
        try {
            sql = "SELECT MDL_UID,MDL_VERSION,MDL_NM,MDL_UUID FROM RT_MDLS";
            statement = jdbcConnection.createStatement();
            if (!statement.execute(sql)) {
                throw new VirtualDatabaseException("ERR.008.000.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0007", new Object[]{sql}));
            }
            ResultSet results = statement.getResultSet();
            result = JDBCTranslator.getModelIDs(results);
            for (BasicModelID mID : result) {
                String versionDate;
                Properties props = JDBCRuntimeMetadataReader.getProperties((MetadataID)mID, jdbcConnection);
                if (props == null || (versionDate = props.getProperty("versionDate")) == null) continue;
                mID.setVersionDate(versionDate);
            }
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
        return result;
    }

    public static Collection getModelIDsOnlyInVDB(VirtualDatabaseID vdbID, Connection jdbcConnection) throws VirtualDatabaseException {
        Statement statement = null;
        String sql = null;
        List result = null;
        try {
            long uid = ((BasicVirtualDatabaseID)vdbID).getUID();
            sql = "SELECT RT_MDLS.MDL_UID,MDL_VERSION,MDL_NM,MDL_UUID FROM RT_MDLS WHERE MDL_UID NOT IN (SELECT RT_MDLS.MDL_UID FROM RT_MDLS,RT_VDB_MDLS WHERE RT_VDB_MDLS.MDL_UID=RT_MDLS.MDL_UID AND VDB_UID !=?)";
            statement = jdbcConnection.prepareStatement(sql);
            statement.setLong(1, uid);
            if (!statement.execute()) {
                throw new VirtualDatabaseException("ERR.008.000.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0007", new Object[]{sql}));
            }
            ResultSet results = statement.getResultSet();
            result = JDBCTranslator.getModelIDs(results);
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
        return result;
    }

    protected static VirtualDatabaseID getVirtualDatabaseID(String fullName, String version, boolean isActive, Connection jdbcConnection) throws VirtualDatabaseDoesNotExistException, VirtualDatabaseException {
        Statement statement = null;
        String sql = null;
        VirtualDatabaseID result = null;
        String uVdbName = platform.getOperator("toUpperCase").buildExpression("VDB_NM");
        int nParms = 2;
        try {
            if (isActive) {
                if (version == null) {
                    sql = JDBCRuntimeMetadataReader.replace(JDBCTranslator.SELECT_ACTIVE_VIRTUAL_DATABASE_ID_LV, JDBCTranslator.PLATFORM_DEPENDENT_MARK, uVdbName);
                    sql = JDBCRuntimeMetadataReader.replace(sql, JDBCTranslator.PLATFORM_DEPENDENT_MARK, uVdbName);
                    sql = JDBCRuntimeMetadataReader.replace(sql, JDBCTranslator.PLATFORM_DEPENDENT_MARK, uVdbName);
                    nParms = 3;
                } else {
                    sql = JDBCRuntimeMetadataReader.replace(JDBCTranslator.SELECT_ACTIVE_VIRTUAL_DATABASE_ID, JDBCTranslator.PLATFORM_DEPENDENT_MARK, uVdbName);
                }
            } else if (version == null) {
                sql = JDBCRuntimeMetadataReader.replace(JDBCTranslator.SELECT_VIRTUAL_DATABASE_ID_LV, JDBCTranslator.PLATFORM_DEPENDENT_MARK, uVdbName);
                sql = JDBCRuntimeMetadataReader.replace(sql, JDBCTranslator.PLATFORM_DEPENDENT_MARK, uVdbName);
            } else {
                sql = JDBCRuntimeMetadataReader.replace(JDBCTranslator.SELECT_VIRTUAL_DATABASE_ID, JDBCTranslator.PLATFORM_DEPENDENT_MARK, uVdbName);
            }
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, fullName.toUpperCase());
            if (version != null) {
                statement.setString(2, version);
            } else {
                statement.setString(2, fullName.toUpperCase());
                if (nParms == 3) {
                    statement.setString(3, fullName.toUpperCase());
                }
            }
            if (!statement.execute()) {
                throw new VirtualDatabaseException("ERR.008.000.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0007", new Object[]{sql}));
            }
            ResultSet results = statement.getResultSet();
            if (results.next()) {
                result = JDBCTranslator.getVirtualDatabaseID(results);
            }
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
        if (result != null) {
            LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{CorePlugin.Util.getString("MSG.008.006.0005", new Object[]{result.getFullName(), result.getVersion(), new Long(((BasicVirtualDatabaseID)result).getUID())})});
        } else {
            LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{CorePlugin.Util.getString("MSG.008.006.0006", new Object[]{fullName})});
        }
        return result;
    }

    private static String replace(String oriString, String from, String to) {
        int index = oriString.indexOf(from);
        if (index == -1) {
            return oriString;
        }
        StringBuffer temp = new StringBuffer(oriString);
        temp.replace(index, index + from.length(), to);
        return temp.toString();
    }
}

