/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.spi.jdbc;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.InvalidStateException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabase;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JDBCRuntimeMetadataWriter {
    public static void setStatus(VirtualDatabaseID virtualDBID, long uid, short status, String userName, Connection jdbcConnection) throws InvalidStateException, VirtualDatabaseException {
        PreparedStatement statement = null;
        String sql = null;
        try {
            sql = "UPDATE RT_VIRTUAL_DBS SET VDB_STATUS=?,UPDATED_BY=?,UPDATED_DATE=? WHERE VDB_UID=?";
            statement = jdbcConnection.prepareStatement(sql);
            statement.setShort(1, status);
            statement.setString(2, userName);
            statement.setString(3, DateUtil.getCurrentDateAsString());
            statement.setLong(4, uid);
            if (statement.executeUpdate() != 1) {
                throw new VirtualDatabaseException("ERR.008.006.0038", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0038", new Object[]{new Short(status), virtualDBID}));
            }
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }

    public static void setConnectorBindingNames(VirtualDatabaseID vdbID, Collection models, Map modelAndCBNames, Connection jdbcConnection) throws VirtualDatabaseException {
        HashMap multiModels = new HashMap(models.size());
        HashMap singleModels = new HashMap(models.size());
        for (Model m : models) {
            if (m.supportsMultiSourceBindings()) {
                multiModels.put(m.getID(), modelAndCBNames.get(m.getID()));
                continue;
            }
            singleModels.put(m.getID(), modelAndCBNames.get(m.getID()));
        }
        if (singleModels.size() > 0) {
            JDBCRuntimeMetadataWriter.updatetSingleConnectorBindingName(vdbID, singleModels, jdbcConnection);
        }
        if (multiModels.size() > 0) {
            JDBCRuntimeMetadataWriter.deleteVDBModels(multiModels.keySet(), vdbID, jdbcConnection);
            JDBCRuntimeMetadataWriter.insertMultiSourceVDBModels(multiModels, vdbID, jdbcConnection);
        }
    }

    private static void insertMultiSourceVDBModels(Map models, VirtualDatabaseID vdbID, Connection jdbcConnection) throws VirtualDatabaseException {
        PreparedStatement statement = null;
        String sql = null;
        try {
            sql = "INSERT  INTO RT_VDB_MDLS(VDB_UID,MDL_UID,CNCTR_BNDNG_NM) VALUES (?,?,?)";
            statement = jdbcConnection.prepareStatement(sql);
            for (ModelID modelID : models.keySet()) {
                long modelUID;
                List bindings = (List)models.get(modelID);
                if (bindings != null && bindings.size() > 0) {
                    for (String cbName : bindings) {
                        statement.clearParameters();
                        statement.setLong(1, ((BasicVirtualDatabaseID)vdbID).getUID());
                        modelUID = ((BasicModelID)modelID).getUID();
                        statement.setLong(2, modelUID);
                        statement.setString(3, cbName);
                        if (statement.executeUpdate() == 1) continue;
                        throw new VirtualDatabaseException("ERR.008.006.0044", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0044", new Object[]{vdbID.getName()}));
                    }
                    continue;
                }
                statement.clearParameters();
                statement.setLong(1, ((BasicVirtualDatabaseID)vdbID).getUID());
                modelUID = ((BasicModelID)modelID).getUID();
                statement.setLong(2, modelUID);
                statement.setNull(3, 12);
                if (statement.executeUpdate() == 1) continue;
                throw new VirtualDatabaseException("ERR.008.006.0044", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0044", new Object[]{vdbID.getName()}));
            }
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }

    public static void updatetSingleConnectorBindingName(VirtualDatabaseID vdbID, Map modelAndCBNames, Connection jdbcConnection) throws VirtualDatabaseException {
        Set modelIDs = modelAndCBNames.keySet();
        PreparedStatement statement = null;
        String sql = null;
        try {
            sql = "UPDATE RT_VDB_MDLS SET CNCTR_BNDNG_NM=? WHERE VDB_UID=? AND MDL_UID=?";
            statement = jdbcConnection.prepareStatement(sql);
            for (BasicModelID modelID : modelIDs) {
                String cbName = null;
                List cbNames = (List)modelAndCBNames.get(modelID);
                if (cbNames != null && !cbNames.isEmpty()) {
                    cbName = (String)cbNames.get(0);
                }
                statement.clearParameters();
                if (cbName == null) {
                    statement.setNull(1, 12);
                } else {
                    statement.setString(1, cbName);
                }
                statement.setLong(2, ((BasicVirtualDatabaseID)vdbID).getUID());
                statement.setLong(3, modelID.getUID());
                if (statement.executeUpdate() == 1) continue;
                throw new VirtualDatabaseException("ERR.008.006.0039", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
            }
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }

    public static void updateVirtualDatabase(VirtualDatabase vdb, String userName, Connection jdbcConnection) throws VirtualDatabaseException {
        Collection attributesList = ((BasicVirtualDatabase)vdb).getUpdatedAttributesList();
        if (attributesList == null) {
            return;
        }
        Statement statement = null;
        String sql = null;
        try {
            String oriSql = "UPDATE RT_VIRTUAL_DBS SET UPDATED_BY=?,UPDATED_DATE=? WHERE VDB_UID=?";
            StringBuffer attributes = new StringBuffer();
            boolean descChanged = false;
            for (String attributeName : attributesList) {
                if (!attributeName.equals("description")) continue;
                attributes.append("DESCRIPTION");
                attributes.append("=?,");
                descChanged = true;
            }
            int setIndex = oriSql.indexOf("SET") + 4;
            sql = oriSql.substring(0, setIndex) + attributes.toString() + oriSql.substring(setIndex);
            statement = jdbcConnection.prepareStatement(sql);
            int index = 0;
            if (descChanged) {
                statement.setString(++index, vdb.getDescription());
            }
            statement.setString(++index, userName);
            statement.setString(++index, DateUtil.getCurrentDateAsString());
            statement.setLong(++index, ((BasicVirtualDatabaseID)vdb.getID()).getUID());
            if (statement.executeUpdate() != 1) {
                throw new VirtualDatabaseException("ERR.008.006.0041", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0041", new Object[]{vdb.getName()}));
            }
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }

    public static void updateVDBVersion(VirtualDatabaseID vdbID, Connection jdbcConnection) throws VirtualDatabaseException {
        PreparedStatement statement = null;
        String sql = null;
        try {
            sql = "UPDATE RT_VIRTUAL_DBS SET VDB_VERSION=? WHERE VDB_UID=?";
            statement = jdbcConnection.prepareStatement(sql);
            statement.setString(1, vdbID.getVersion());
            statement.setLong(2, ((BasicVirtualDatabaseID)vdbID).getUID());
            if (statement.executeUpdate() != 1) {
                throw new VirtualDatabaseException("ERR.008.006.0043", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0043", new Object[]{vdbID.getName()}));
            }
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }

    public static void insertVDBModels(Collection models, VirtualDatabaseID vdbID, Connection jdbcConnection) throws VirtualDatabaseException {
        ArrayList<Model> multiModels = new ArrayList<Model>(models.size());
        ArrayList<Model> singleModels = new ArrayList<Model>(models.size());
        for (Model m : models) {
            if (m.supportsMultiSourceBindings()) {
                multiModels.add(m);
                continue;
            }
            singleModels.add(m);
        }
        if (singleModels.size() > 0) {
            JDBCRuntimeMetadataWriter.insertSingleBindingVDBModels(singleModels, vdbID, jdbcConnection);
        }
        if (multiModels.size() > 0) {
            JDBCRuntimeMetadataWriter.insertMultiSourceVDBModels(multiModels, vdbID, jdbcConnection);
        }
    }

    private static void insertSingleBindingVDBModels(Collection models, VirtualDatabaseID vdbID, Connection jdbcConnection) throws VirtualDatabaseException {
        PreparedStatement statement = null;
        String sql = null;
        try {
            sql = "INSERT  INTO RT_VDB_MDLS(VDB_UID,MDL_UID,CNCTR_BNDNG_NM) VALUES (?,?,?)";
            statement = jdbcConnection.prepareStatement(sql);
            Iterator iter = models.iterator();
            String routing = null;
            while (iter.hasNext()) {
                long modelUID;
                statement.clearParameters();
                statement.setLong(1, ((BasicVirtualDatabaseID)vdbID).getUID());
                Object next = iter.next();
                routing = null;
                if (next instanceof Model) {
                    Model m = (Model)next;
                    modelUID = ((BasicModelID)m.getID()).getUID();
                    List bindings = m.getConnectorBindingNames();
                    if (bindings != null && bindings.size() > 0) {
                        String cbName = (String)bindings.get(0);
                        ConnectorBinding cb = CurrentConfiguration.getInstance().getConfiguration().getConnectorBinding(cbName);
                        if (cb != null) {
                            routing = cb.getRoutingUUID();
                        }
                    }
                } else {
                    modelUID = ((BasicModelID)next).getUID();
                }
                statement.setLong(2, modelUID);
                if (routing == null) {
                    statement.setNull(3, 12);
                } else {
                    statement.setString(3, routing);
                }
                if (statement.executeUpdate() == 1) continue;
                throw new VirtualDatabaseException("ERR.008.006.0044", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0044", new Object[]{vdbID.getName()}));
            }
        }
        catch (Exception se) {
            throw new VirtualDatabaseException(se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }

    private static void insertMultiSourceVDBModels(Collection models, VirtualDatabaseID vdbID, Connection jdbcConnection) throws VirtualDatabaseException {
        PreparedStatement statement = null;
        String sql = null;
        try {
            sql = "INSERT  INTO RT_VDB_MDLS(VDB_UID,MDL_UID,CNCTR_BNDNG_NM) VALUES (?,?,?)";
            statement = jdbcConnection.prepareStatement(sql);
            for (Model m : models) {
                long modelUID;
                List bindings = m.getConnectorBindingNames();
                if (bindings != null && bindings.size() > 0) {
                    for (String cbName : bindings) {
                        ConnectorBinding cb = CurrentConfiguration.getInstance().getConfiguration().getConnectorBinding(cbName);
                        String routing = null;
                        if (cb != null) {
                            routing = cb.getRoutingUUID();
                        }
                        statement.clearParameters();
                        statement.setLong(1, ((BasicVirtualDatabaseID)vdbID).getUID());
                        modelUID = ((BasicModelID)m.getID()).getUID();
                        statement.setLong(2, modelUID);
                        if (routing == null) {
                            statement.setNull(3, 12);
                        } else {
                            statement.setString(3, routing);
                        }
                        if (statement.executeUpdate() == 1) continue;
                        throw new VirtualDatabaseException("ERR.008.006.0044", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0044", new Object[]{vdbID.getName()}));
                    }
                    continue;
                }
                statement.clearParameters();
                statement.setLong(1, ((BasicVirtualDatabaseID)vdbID).getUID());
                modelUID = ((BasicModelID)m.getID()).getUID();
                statement.setLong(2, modelUID);
                statement.setNull(3, 12);
                if (statement.executeUpdate() == 1) continue;
                throw new VirtualDatabaseException("ERR.008.006.0044", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0044", new Object[]{vdbID.getName()}));
            }
        }
        catch (Exception se) {
            throw new VirtualDatabaseException(se, "ERR.008.006.0035", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0035", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }

    public static void deleteVDBModels(Collection modelIDs, VirtualDatabaseID vdbID, Connection jdbcConnection) throws VirtualDatabaseException {
        PreparedStatement statement = null;
        String sql = null;
        Iterator iter = modelIDs.iterator();
        try {
            sql = "DELETE  FROM RT_VDB_MDLS WHERE VDB_UID=? AND MDL_UID=?";
            statement = jdbcConnection.prepareStatement(sql);
            while (iter.hasNext()) {
                statement.clearParameters();
                BasicModelID modelID = (BasicModelID)iter.next();
                BasicVirtualDatabaseID basicVdbID = (BasicVirtualDatabaseID)vdbID;
                statement.setLong(1, basicVdbID.getUID());
                statement.setLong(2, modelID.getUID());
                statement.executeUpdate();
            }
        }
        catch (SQLException se) {
            throw new VirtualDatabaseException((Exception)se, "ERR.008.006.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0003", new Object[]{sql}));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    I18nLogManager.logError("RUNTIME_METADATA", "ERR.008.000.0008", e);
                }
            }
        }
    }
}

