/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.spi.jdbc;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.model.BasicModel;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabase;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class JDBCTranslator {
    public static long NA_LONG = 0L;
    public static int NA_INT = 0;
    public static short NA_SHORT = 0;
    public static String PLATFORM_DEPENDENT_MARK = "??";
    private static String IS_TRUE = "1";
    private static final String MAX = "MAX";
    private static final String INSERT = "INSERT ";
    private static final String UPDATE = "UPDATE ";
    private static final String DELETE = "DELETE ";
    private static final String SELECT = "SELECT ";
    private static final String FROM = " FROM ";
    private static final String WHERE = " WHERE ";
    private static final String ORDER_BY = " ORDER BY ";
    private static final String SET = " SET ";
    private static final String INTO = " INTO ";
    private static final String DISTINCT = " DISTINCT ";
    private static final String VALUES = " VALUES ";
    private static final String AND = " AND ";
    private static final String IN = " IN ";
    private static final String NOT_IN = " NOT IN ";
    private static final String OR = " OR ";
    public static final String SELECT_ACTIVE_VIRTUAL_DATABASE_ID = "SELECT VDB_UID,VDB_NM,VDB_VERSION FROM RT_VIRTUAL_DBS WHERE " + PLATFORM_DEPENDENT_MARK + "=?" + " AND " + "VDB_VERSION" + "=?" + " AND " + "(" + "VDB_STATUS" + "=" + 3 + " OR " + "VDB_STATUS" + "=" + 3 + ")";
    public static final String SELECT_VIRTUAL_DATABASE_ID = "SELECT VDB_UID,VDB_NM,VDB_VERSION FROM RT_VIRTUAL_DBS WHERE " + PLATFORM_DEPENDENT_MARK + "=?" + " AND " + "VDB_VERSION" + "=?";
    public static final String SELECT_ACTIVE_VIRTUAL_DATABASE_ID_LV = "SELECT VDB_UID,VDB_NM,VDB_VERSION FROM RT_VIRTUAL_DBS WHERE " + PLATFORM_DEPENDENT_MARK + "=?" + " AND " + "VERSION_DATE" + "=(" + "SELECT " + "MAX" + "(" + "VERSION_DATE" + ")" + " FROM " + "RT_VIRTUAL_DBS" + " WHERE " + PLATFORM_DEPENDENT_MARK + "=?" + " AND " + "VDB_STATUS" + "=" + "(" + "SELECT " + "MAX" + "(" + "VDB_STATUS" + ")" + " FROM " + "RT_VIRTUAL_DBS" + " WHERE " + PLATFORM_DEPENDENT_MARK + "=?" + " AND " + "(" + "VDB_STATUS" + "=" + 3 + " OR " + "VDB_STATUS" + "=" + 3 + ")))";
    public static final String SELECT_VIRTUAL_DATABASE_ID_LV = "SELECT VDB_UID,VDB_NM,VDB_VERSION FROM RT_VIRTUAL_DBS WHERE " + PLATFORM_DEPENDENT_MARK + "=?" + " AND " + "VERSION_DATE" + "=(" + "SELECT " + "MAX" + "(" + "VERSION_DATE" + ")" + " FROM " + "RT_VIRTUAL_DBS" + " WHERE " + PLATFORM_DEPENDENT_MARK + "=?)";
    public static final String SELECT_VIRTUAL_DATABASES = "SELECT VDB_NM,VDB_VERSION,VDB_UID,DESCRIPTION,PROJECT_GUID,VDB_STATUS,WSDL_DEFINED,VERSION_BY,VERSION_DATE,CREATED_BY,CREATION_DATE,UPDATED_BY,UPDATED_DATE,VDB_FILE_NM FROM RT_VIRTUAL_DBS";
    public static final String SELECT_SCHEMA_UIDS = "SELECT  DISTINCT MDL_UID FROM RT_VDB_MDLS WHERE VDB_UID=?";
    public static final String SELECT_DELETED_VIRTUAL_DATABASES = "SELECT VDB_NM,VDB_VERSION,VDB_UID FROM RT_VIRTUAL_DBS WHERE VDB_STATUS=4";
    public static final String SELECT_VIRTUAL_DATABASE = "SELECT DESCRIPTION,PROJECT_GUID,VDB_STATUS,WSDL_DEFINED,VERSION_BY,VERSION_DATE,CREATED_BY,CREATION_DATE,UPDATED_BY,UPDATED_DATE,VDB_FILE_NM FROM RT_VIRTUAL_DBS WHERE VDB_UID=?";
    public static final String SELECT_MODELS = "SELECT RT_VDB_MDLS.MDL_UID,MDL_NM,MDL_VERSION,MDL_UUID,MDL_TYPE,MDL_URI,DESCRIPTION,IS_PHYSICAL,MULTI_SOURCED,VISIBILITY,CNCTR_BNDNG_NM FROM RT_MDLS,RT_VDB_MDLS WHERE RT_VDB_MDLS.MDL_UID=RT_MDLS.MDL_UID AND VDB_UID=? ORDER BY MDL_NM";
    public static final String SELECT_MODEL_IDS = "SELECT MDL_UID,MDL_VERSION,MDL_NM,MDL_UUID FROM RT_MDLS";
    public static final String SELECT_MODEL_IDS_ONLY_IN_VDB = "SELECT RT_MDLS.MDL_UID,MDL_VERSION,MDL_NM,MDL_UUID FROM RT_MDLS WHERE MDL_UID NOT IN (SELECT RT_MDLS.MDL_UID FROM RT_MDLS,RT_VDB_MDLS WHERE RT_VDB_MDLS.MDL_UID=RT_MDLS.MDL_UID AND VDB_UID !=?)";
    public static final String SELECT_PROPERTIES = "SELECT PRP_NM,PRP_VL FROM ? WHERE = AND ?=? ORDER BY PRP_NM,PART_ID";
    public static final String INSERT_VIRTUAL_DATABASE = "INSERT  INTO RT_VIRTUAL_DBS(VDB_UID,VDB_VERSION,VDB_NM,DESCRIPTION,PROJECT_GUID,VDB_STATUS,WSDL_DEFINED,VERSION_BY,VERSION_DATE,CREATED_BY,CREATION_DATE,UPDATED_BY,UPDATED_DATE,VDB_FILE_NM) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    public static final String INSERT_MODELS = "INSERT  INTO RT_MDLS(MDL_UID,MDL_NM,MDL_VERSION,DESCRIPTION,IS_PHYSICAL,MULTI_SOURCED,VISIBILITY,MDL_UUID,MDL_TYPE,MDL_URI) VALUES (?,?,?,?,?,?,?,?,?,?)";
    public static final String INSERT_VDB_MODELS = "INSERT  INTO RT_VDB_MDLS(VDB_UID,MDL_UID) VALUES (?,?)";
    public static final String INSERT_VDB_MODELS_WITH_BINDING = "INSERT  INTO RT_VDB_MDLS(VDB_UID,MDL_UID,CNCTR_BNDNG_NM) VALUES (?,?,?)";
    public static final String INSERT_PROP_NAMES = "INSERT  INTO ?(PRP_UID,?,PRP_NM) VALUES (?,?,?)";
    public static final String INSERT_PROP_VALUES = "INSERT  INTO ?(PRP_UID,PART_ID,PRP_VL) VALUES (?,?,?)";
    public static final String UPDATE_SET_STATUS = "UPDATE RT_VIRTUAL_DBS SET VDB_STATUS=?,UPDATED_BY=?,UPDATED_DATE=? WHERE VDB_UID=?";
    public static final String UPDATE_CONNECTOR_BINGING_NAME = "UPDATE RT_VDB_MDLS SET CNCTR_BNDNG_NM=? WHERE VDB_UID=? AND MDL_UID=?";
    public static final String UPDATE_VDB = "UPDATE RT_VIRTUAL_DBS SET UPDATED_BY=?,UPDATED_DATE=? WHERE VDB_UID=?";
    public static final String UPDATE_VDB_VERSION = "UPDATE RT_VIRTUAL_DBS SET VDB_VERSION=? WHERE VDB_UID=?";
    public static final String UPDATE_VDB_MODELS = "UPDATE RT_VDB_MDLS SET MDL_UID=? WHERE VDB_UID=? AND MDL_UID=?";
    public static final String UPDATE_MODEL_NAME = "UPDATE RT_MDLS SET MDL_NM=? WHERE MDL_UID=?";
    public static final String DELETE_MODEL_PROP_VALS = "DELETE  FROM RT_MDL_PRP_VLS WHERE PRP_UID IN (SELECT PRP_UID FROM RT_MDL_PRP_NMS WHERE MDL_UID=?)";
    public static final String DELETE_MODEL_PROP_NMS = "DELETE  FROM RT_MDL_PRP_NMS WHERE MDL_UID=?";
    public static final String DELETE_VDB_MODELS = "DELETE  FROM RT_VDB_MDLS WHERE VDB_UID=?";
    public static final String DELETE_VDB_MODEL = "DELETE  FROM RT_VDB_MDLS WHERE VDB_UID=? AND MDL_UID=?";
    public static final String DELETE_MODEL = "DELETE  FROM RT_MDLS WHERE MDL_UID=?";
    public static final String DELETE_VDB = "DELETE  FROM RT_VIRTUAL_DBS WHERE VDB_UID=?";

    public static int getCount(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return resultSet.getInt(1);
        }
        return 0;
    }

    public static Collection getVirtualDatabases(ResultSet resultSet) throws SQLException {
        HashSet<BasicVirtualDatabase> result = new HashSet<BasicVirtualDatabase>();
        try {
            while (resultSet.next()) {
                String name = resultSet.getString("VDB_NM");
                String version = resultSet.getString("VDB_VERSION");
                long uid = resultSet.getLong("VDB_UID");
                BasicVirtualDatabaseID vdbID = new BasicVirtualDatabaseID(name, version, uid);
                BasicVirtualDatabase vdb = new BasicVirtualDatabase(vdbID);
                vdb.setDescription(resultSet.getString("DESCRIPTION"));
                vdb.setGUID(resultSet.getString("PROJECT_GUID"));
                vdb.setStatus(resultSet.getShort("VDB_STATUS"));
                String v = resultSet.getString("WSDL_DEFINED");
                vdb.setHasWSDLDefined(v != null && v.equals(IS_TRUE) ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue());
                vdb.setVersionBy(resultSet.getString("VERSION_BY"));
                vdb.setVersionDate(DateUtil.convertStringToDate((String)resultSet.getString("VERSION_DATE")));
                vdb.setCreatedBy(resultSet.getString("CREATED_BY"));
                vdb.setCreationDate(DateUtil.convertStringToDate((String)resultSet.getString("CREATION_DATE")));
                vdb.setUpdatedBy(resultSet.getString("UPDATED_BY"));
                vdb.setUpdateDate(DateUtil.convertStringToDate((String)resultSet.getString("UPDATED_DATE")));
                vdb.setFileName(resultSet.getString("VDB_FILE_NM"));
                result.add(vdb);
            }
        }
        catch (ParseException pe) {
            throw new MetaMatrixRuntimeException("ERR.008.006.0045", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0045"));
        }
        return result;
    }

    public static Collection getVirtualDatabaseIDs(ResultSet resultSet) throws SQLException {
        HashSet<BasicVirtualDatabaseID> result = new HashSet<BasicVirtualDatabaseID>();
        while (resultSet.next()) {
            String name = resultSet.getString("VDB_NM");
            String version = resultSet.getString("VDB_VERSION");
            long uid = resultSet.getLong("VDB_UID");
            BasicVirtualDatabaseID vdbID = new BasicVirtualDatabaseID(name, version, uid);
            result.add(vdbID);
        }
        return result;
    }

    public static VirtualDatabase getVirtualDatabase(ResultSet resultSet, VirtualDatabaseID vdbID) throws SQLException {
        BasicVirtualDatabase vdb = new BasicVirtualDatabase((BasicVirtualDatabaseID)vdbID);
        try {
            vdb.setDescription(resultSet.getString("DESCRIPTION"));
            vdb.setGUID(resultSet.getString("PROJECT_GUID"));
            vdb.setStatus(resultSet.getShort("VDB_STATUS"));
            String v = resultSet.getString("WSDL_DEFINED");
            vdb.setHasWSDLDefined(v != null && v.equals(IS_TRUE) ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue());
            vdb.setVersionBy(resultSet.getString("VERSION_BY"));
            vdb.setVersionDate(DateUtil.convertStringToDate((String)resultSet.getString("VERSION_DATE")));
            vdb.setCreatedBy(resultSet.getString("CREATED_BY"));
            vdb.setCreationDate(DateUtil.convertStringToDate((String)resultSet.getString("CREATION_DATE")));
            vdb.setUpdatedBy(resultSet.getString("UPDATED_BY"));
            vdb.setUpdateDate(DateUtil.convertStringToDate((String)resultSet.getString("UPDATED_DATE")));
            vdb.setFileName(resultSet.getString("VDB_FILE_NM"));
        }
        catch (ParseException pe) {
            throw new MetaMatrixRuntimeException("ERR.008.006.0045", RuntimeMetadataPlugin.Util.getString("ERR.008.006.0045"));
        }
        return vdb;
    }

    public static VirtualDatabaseID getVirtualDatabaseID(ResultSet resultSet) throws SQLException {
        long uid = resultSet.getLong("VDB_UID");
        String name = resultSet.getString("VDB_NM");
        String version = resultSet.getString("VDB_VERSION");
        return new BasicVirtualDatabaseID(name, version, uid);
    }

    public static Collection getModels(ResultSet resultSet, VirtualDatabaseID vdbID, Collection smUids) throws SQLException {
        HashSet<BasicModel> result = new HashSet<BasicModel>();
        String currentModelName = null;
        BasicModelID modelID = null;
        BasicModel model = null;
        while (resultSet.next()) {
            String cbName;
            String name = resultSet.getString("MDL_NM");
            if (currentModelName == null || !currentModelName.equals(name)) {
                String version = resultSet.getString("MDL_VERSION");
                long uid = resultSet.getLong("MDL_UID");
                modelID = new BasicModelID(name, version, uid);
                modelID.setUuid(resultSet.getString("MDL_UUID"));
                model = new BasicModel(modelID, (BasicVirtualDatabaseID)vdbID);
                model.setDescription(resultSet.getString("DESCRIPTION"));
                model.setModelType(resultSet.getInt("MDL_TYPE"));
                model.setModelURI(resultSet.getString("MDL_URI"));
                String v = resultSet.getString("MULTI_SOURCED");
                model.enableMutliSourceBindings(v != null && v.equals(IS_TRUE) ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue());
                if (resultSet.getObject("VISIBILITY") == null) {
                    model.setIsVisible(true);
                } else {
                    short vis = resultSet.getShort("VISIBILITY");
                    if (vis == 0) {
                        model.setIsVisible(true);
                    } else {
                        model.setIsVisible(false);
                    }
                }
                result.add(model);
                currentModelName = name;
            }
            if ((cbName = resultSet.getString("CNCTR_BNDNG_NM")) == null || cbName.trim().length() <= 0) continue;
            model.addConnectorBindingName(cbName);
        }
        return result;
    }

    public static List getModelIDs(ResultSet resultSet) throws SQLException {
        ArrayList<BasicModelID> result = new ArrayList<BasicModelID>();
        while (resultSet.next()) {
            String name = resultSet.getString("MDL_NM");
            String version = resultSet.getString("MDL_VERSION");
            long uid = resultSet.getLong("MDL_UID");
            BasicModelID modelID = new BasicModelID(name, version, uid);
            modelID.setUuid(resultSet.getString("MDL_UUID"));
            result.add(modelID);
        }
        return result;
    }

    public static Model getModel(ResultSet resultSet) throws SQLException {
        return null;
    }

    public static Properties getProperties(ResultSet resultSet) throws SQLException {
        Properties result = null;
        String name = null;
        String value = null;
        if (!resultSet.next()) {
            return result;
        }
        name = resultSet.getString("PRP_NM");
        value = resultSet.getString("PRP_VL");
        result = new Properties();
        while (resultSet.next()) {
            String nextName = resultSet.getString("PRP_NM");
            if (nextName.equals(name)) {
                value = value + resultSet.getString("PRP_VL");
                continue;
            }
            result.put(name, value);
            name = nextName;
            value = resultSet.getString("PRP_VL");
        }
        result.put(name, value);
        return result;
    }

    static String getPropertyQuery(MetadataID id, int queryID) {
        String sql = null;
        if (queryID == 1) {
            sql = SELECT_PROPERTIES;
        } else if (queryID == 2) {
            sql = INSERT_PROP_NAMES;
        } else if (queryID == 3) {
            sql = INSERT_PROP_VALUES;
        }
        if (id instanceof ModelID) {
            int i = sql.indexOf("?");
            if (queryID == 1) {
                sql = sql.substring(0, i) + "RT_MDL_PRP_NMS, RT_MDL_PRP_VLS" + sql.substring(i + 1);
                int j = sql.indexOf("=");
                sql = sql.substring(0, j) + "RT_MDL_PRP_NMS" + "." + "PRP_UID" + "=" + "RT_MDL_PRP_VLS" + "." + "PRP_UID" + sql.substring(j + 1);
            } else {
                sql = queryID == 2 ? sql.substring(0, i) + "RT_MDL_PRP_NMS" + sql.substring(i + 1) : sql.substring(0, i) + "RT_MDL_PRP_VLS" + sql.substring(i + 1);
            }
            if (queryID != 3) {
                i = sql.indexOf("?");
                sql = sql.substring(0, i) + "MDL_UID" + sql.substring(i + 1);
            }
        } else {
            return null;
        }
        return sql;
    }
}

