/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.vdb.defn;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationConnector;
import com.metamatrix.platform.config.spi.xml.XMLConfigurationConnectorFactory;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class VDBCreation {
    private static final String UNDEFINED_PRINCIPAL = "VDBCreation_UndefinedPrincipal";
    private static PrintStream logger = null;
    private Properties runtimeProps;
    private XMLConfigurationConnectorFactory factory = null;
    private boolean updateBindingProperties = false;
    private List vmsToDeployTo = null;
    private ManagedConnection conn = null;
    private String thePrincipal;

    public void setUpdateBindingProperties(boolean updateProperties) {
        this.updateBindingProperties = updateProperties;
    }

    public void setVMsToDeployBindings(List vms) {
        this.vmsToDeployTo = vms;
    }

    public VirtualDatabase loadVDBDefn(VDBArchive vdbArchive, String principal) throws Exception {
        this.thePrincipal = principal == null || principal.length() == 0 ? UNDEFINED_PRINCIPAL : principal;
        ArgCheck.isNotNull((Object)vdbArchive.getName(), (String)"VDBDefn name must not be null");
        BasicVDBDefn def = vdbArchive.getConfigurationDef();
        Map connectorBindings = def.getConnectorBindings();
        Map connectorTypes = def.getConnectorTypes();
        HashMap createdPSC = new HashMap(10);
        ConfigurationModelContainer cmc = null;
        HashMap<String, ConnectorBinding> reMapBinding = new HashMap<String, ConnectorBinding>(connectorBindings.size());
        XMLConfigurationConnector writer = this.getWriter();
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(true);
        for (ConnectorBinding cb : connectorBindings.values()) {
            ConnectorBinding existingBinding;
            ComponentType ct = (ComponentType)connectorTypes.get(cb.getComponentTypeID().getName());
            if (cmc == null) {
                cmc = CurrentConfiguration.getInstance().getConfigurationModel();
            }
            if ((existingBinding = this.addConfigurationObjects(cmc, cb, ct, createdPSC, writer, editor)) == null) continue;
            reMapBinding.put(cb.getRoutingUUID(), existingBinding);
        }
        try {
            writer.executeActions(editor.getDestination().popActions(), this.thePrincipal);
            writer.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            writer.rollback();
            throw e;
        }
        VirtualDatabase vdb = RuntimeMetadataCatalog.getInstance().createVirtualDatabase(vdbArchive, principal);
        VirtualDatabaseID vdbID = (VirtualDatabaseID)vdb.getID();
        RuntimeMetadataCatalog.getInstance().setVDBStatus(vdbID, vdbArchive.getStatus(), principal);
        return vdb;
    }

    protected void setVDBInfo(VDBDefn vdbDefn, String vdbName) {
        if (vdbName == null) {
            ArgCheck.isNotNull((Object)vdbName, (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.Invalid_VDB_name"));
        }
        String desc = vdbDefn.getDescription();
        String guid = vdbDefn.getUUID();
        this.runtimeProps.setProperty("metamatrix.metadata.runtime.uservdb.name", vdbName);
        this.runtimeProps.setProperty("metamatrix.metadata.runtime.uservdb.guid", guid + "_" + new Date());
        this.runtimeProps.setProperty("metamatrix.metadata.runtime.uservdb.guid", guid);
        this.runtimeProps.setProperty("metamatrix.metadata.runtime.uservdb.principalName", this.thePrincipal);
        this.runtimeProps.setProperty("metamatrix.metadata.runtime.uservdb.description", desc);
    }

    protected ConnectorBinding addConfigurationObjects(ConfigurationModelContainer cmc, ConnectorBinding binding, ComponentType type, Map createdPSC, XMLConfigurationConnector writer, BasicConfigurationObjectEditor editor) throws Exception {
        ComponentType tExist = null;
        if (type != null) {
            tExist = cmc.getComponentType(type.getFullName());
        } else {
            type = tExist = cmc.getComponentType(binding.getComponentTypeID().getFullName());
        }
        boolean addType = false;
        if (tExist != null) {
            addType = false;
        } else if (type != null) {
            addType = true;
        } else {
            throw new MetaMatrixException(RuntimeMetadataPlugin.Util.getString("VDBCreation.No_type_passed_and_bindingtype_not_found", new Object[]{binding.getFullName(), binding.getComponentTypeID().getFullName()}));
        }
        boolean bindingExist = false;
        LogManager.logWarning((String)"CONFIG", (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.Does_connectorbinding_exist", new Object[]{binding.getFullName()}));
        ConnectorBinding bExist = cmc.getConfiguration().getConnectorBinding((ComponentDefnID)binding.getID());
        if (bExist != null) {
            bindingExist = true;
            LogManager.logWarning((String)"CONFIG", (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.Connectorbinding_exist", new Object[]{binding.getFullName()}));
        } else {
            LogManager.logWarning((String)"CONFIG", (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.Connectorbinding_will_be_added", new Object[]{binding.getFullName()}));
        }
        if (addType) {
            editor.createComponentType(2, type.getFullName(), type.getParentComponentTypeID(), type.getSuperComponentTypeID(), true, false);
            for (ComponentTypeDefn ctd : type.getComponentTypeDefinitions()) {
                editor.createComponentTypeDefn(type, ctd.getPropertyDefinition(), false);
            }
        } else if (this.updateBindingProperties) {
            editor.updateComponentType(tExist, type);
        }
        if (this.vmsToDeployTo != null && this.vmsToDeployTo.size() > 0) {
            boolean beenCreated = false;
            for (String processName : this.vmsToDeployTo) {
                DeployedComponent depBinding;
                VMComponentDefn depVM = this.getDeployedVM(processName, cmc);
                if (depVM == null) {
                    LogManager.logWarning((String)"CONFIG", (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.0", new Object[]{processName}));
                    continue;
                }
                if (bindingExist && (depBinding = this.getDeployedBinding(binding.getName(), depVM, cmc)) != null) continue;
                LogManager.logWarning((String)"CONFIG", (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.5", new Object[]{binding.getName(), processName}));
                this.processDeployment(depVM, cmc, beenCreated ? beenCreated : bindingExist, binding, type, createdPSC, (ConfigurationObjectEditor)editor);
                beenCreated = true;
            }
        } else {
            DeployedComponent depBinding;
            boolean bindingDeployed = false;
            if (bindingExist && (depBinding = this.getDeployedBinding(binding.getName(), cmc)) != null) {
                bindingDeployed = true;
            }
            if (!bindingDeployed) {
                VMComponentDefn depVM = this.getDeployedVM(cmc);
                if (depVM == null) {
                    throw new MetaMatrixException(RuntimeMetadataPlugin.Util.getString("VDBCreation.4"));
                }
                this.processDeployment(depVM, cmc, bindingExist, binding, type, createdPSC, (ConfigurationObjectEditor)editor);
            }
        }
        if (this.updateBindingProperties && bindingExist) {
            LogManager.logWarning((String)"CONFIG", (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.7", new Object[]{bExist.getName()}));
            Properties props = (Properties)bExist.getProperties().clone();
            props.putAll((Map<?, ?>)((Properties)binding.getProperties().clone()));
            editor.modifyProperties((ComponentObject)bExist, props, 0);
        }
        return bExist;
    }

    private void processDeployment(VMComponentDefn depVM, ConfigurationModelContainer cmc, boolean bindingExist, ConnectorBinding binding, ComponentType type, Map createdPSC, ConfigurationObjectEditor editor) throws Exception {
        ProductServiceConfig pscdep = null;
        pscdep = this.getPSCForDeployedVM(depVM, cmc);
        boolean isPSCDeployed = false;
        if (pscdep == null) {
            String pscName = depVM.getName() + "PSC";
            ProductServiceConfigID did = new ProductServiceConfigID(pscName);
            if (cmc.getConfiguration().getPSC((ComponentDefnID)did) != null) {
                pscdep = cmc.getConfiguration().getPSC((ComponentDefnID)did);
                isPSCDeployed = true;
            } else if (createdPSC.containsKey(pscName)) {
                pscdep = (ProductServiceConfig)createdPSC.get(pscName);
                isPSCDeployed = true;
            } else {
                LogManager.logWarning((String)"CONFIG", (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.11", new Object[]{pscName, binding.getName()}));
                pscdep = editor.createProductServiceConfig(cmc.getConfiguration(), ConnectorBindingType.CONNECTOR_PROD_TYPEID, pscName);
                createdPSC.put(pscdep.getName(), pscdep);
            }
        } else {
            isPSCDeployed = true;
        }
        ProductServiceConfigID deployPSCID = (ProductServiceConfigID)pscdep.getID();
        if (!bindingExist) {
            ConnectorBinding defn;
            if (isPSCDeployed) {
                defn = editor.createConnectorComponent(cmc.getConfiguration(), (ComponentTypeID)type.getID(), binding.getName(), (ProductServiceConfigID)pscdep.getID());
                editor.setRoutingUUID((ServiceComponentDefn)defn, binding.getRoutingUUID());
                editor.modifyProperties((ComponentObject)defn, binding.getProperties(), 1);
                pscdep = editor.addServiceComponentDefn(pscdep, (ServiceComponentDefnID)defn.getID());
            } else {
                defn = editor.createConnectorComponent(cmc.getConfiguration(), (ComponentTypeID)type.getID(), binding.getName(), deployPSCID);
                editor.setRoutingUUID((ServiceComponentDefn)defn, binding.getRoutingUUID());
                editor.modifyProperties((ComponentObject)defn, binding.getProperties(), 1);
                pscdep = editor.addServiceComponentDefn(pscdep, (ServiceComponentDefnID)defn.getID());
                Collection dcs = editor.deployProductServiceConfig(cmc.getConfiguration(), pscdep, depVM.getHostID(), (VMComponentDefnID)depVM.getID());
                if (dcs.isEmpty()) {
                    String msg = RuntimeMetadataPlugin.Util.getString("VDBCreation.Error_deploying_binding", new Object[]{defn.getName(), pscdep.getName()});
                    throw new Exception(msg);
                }
            }
            createdPSC.put(pscdep.getName(), pscdep);
            LogManager.logWarning((String)"CONFIG", (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.3", new Object[]{binding.getName(), depVM.getName(), pscdep.getName()}));
        } else {
            if (isPSCDeployed) {
                pscdep = editor.addServiceComponentDefn(pscdep, (ServiceComponentDefnID)((ConnectorBindingID)binding.getID()));
                editor.deployServiceDefn(cmc.getConfiguration(), (ServiceComponentDefn)binding, (ProductServiceConfigID)pscdep.getID());
            } else {
                pscdep = editor.addServiceComponentDefn(pscdep, (ServiceComponentDefnID)((ConnectorBindingID)binding.getID()));
                editor.deployProductServiceConfig(cmc.getConfiguration(), pscdep, depVM.getHostID(), (VMComponentDefnID)depVM.getID());
            }
            createdPSC.put(pscdep.getName(), pscdep);
            LogManager.logWarning((String)"CONFIG", (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.2", new Object[]{binding.getName(), depVM.getName(), pscdep.getName()}));
        }
    }

    private VMComponentDefn getDeployedVM(String processName, ConfigurationModelContainer cmc) throws Exception {
        Collection vms = cmc.getConfiguration().getVMComponentDefns();
        for (VMComponentDefn vm : vms) {
            if (!vm.getName().equalsIgnoreCase(processName)) continue;
            return vm;
        }
        return null;
    }

    private VMComponentDefn getDeployedVM(ConfigurationModelContainer cmc) throws Exception {
        Collection vms = cmc.getConfiguration().getVMComponentDefns();
        if (vms == null || vms.size() == 0) {
            return null;
        }
        for (VMComponentDefn vm : vms) {
            Collection depsvcs = cmc.getConfiguration().getDeployedServicesForVM(vm);
            if (depsvcs == null || depsvcs.size() <= 0) continue;
            return vm;
        }
        return null;
    }

    private ProductServiceConfig getPSCForDeployedVM(VMComponentDefn vm, ConfigurationModelContainer cmc) throws Exception {
        ProductServiceConfig psc = null;
        Collection pscs = cmc.getConfiguration().getPSCsForVM(vm);
        for (ProductServiceConfig p : pscs) {
            if (!p.getComponentTypeID().equals((Object)ConnectorBindingType.CONNECTOR_PROD_TYPEID)) continue;
            psc = p;
            break;
        }
        if (psc == null) {
            return null;
        }
        return psc;
    }

    private DeployedComponent getDeployedBinding(String bindingName, VMComponentDefn depVM, ConfigurationModelContainer cmc) throws Exception {
        Collection deployedServices = cmc.getConfiguration().getDeployedServicesForVM(depVM);
        for (DeployedComponent dc : deployedServices) {
            if (!dc.isDeployedConnector() || !dc.getServiceComponentDefnID().getName().equalsIgnoreCase(bindingName)) continue;
            return dc;
        }
        return null;
    }

    private DeployedComponent getDeployedBinding(String bindingName, ConfigurationModelContainer cmc) throws Exception {
        Collection deployedServices = cmc.getConfiguration().getDeployedComponents();
        for (DeployedComponent dc : deployedServices) {
            if (!dc.isDeployedConnector() || !dc.getServiceComponentDefnID().getName().equalsIgnoreCase(bindingName)) continue;
            return dc;
        }
        return null;
    }

    protected Short getVisibility(String visibility) {
        if (visibility == null || visibility.length() == 0) {
            return new Short(2);
        }
        if (visibility.equalsIgnoreCase("Public")) {
            return new Short(0);
        }
        return new Short(2);
    }

    protected static void log(String msg) {
        if (logger != null) {
            logger.println(msg);
        } else {
            LogManager.logWarning((String)"CONFIG", (String)msg);
        }
    }

    private XMLConfigurationConnector getWriter() throws Exception {
        if (this.factory == null) {
            this.factory = new XMLConfigurationConnectorFactory();
            this.conn = this.factory.createConnection(new Properties(), this.thePrincipal);
        }
        XMLConfigurationConnector writer = (XMLConfigurationConnector)this.factory.createTransaction(this.conn, false);
        return writer;
    }
}

